/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.JoinRawLinesHandlerDelegate;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class CommentJoinLinesHandler
implements JoinRawLinesHandlerDelegate {
    @Override
    public int tryJoinLines(@NotNull Document document, @NotNull PsiFile file2, int start, int end) {
        if (document == null) {
            CommentJoinLinesHandler.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            CommentJoinLinesHandler.$$$reportNull$$$0(1);
        }
        return -1;
    }

    @Override
    public int tryJoinRawLines(@NotNull Document document, @NotNull PsiFile file2, int start, int end) {
        if (document == null) {
            CommentJoinLinesHandler.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            CommentJoinLinesHandler.$$$reportNull$$$0(3);
        }
        String text2 = document.getText();
        PsiComment prevComment = (PsiComment)PsiTreeUtil.getNonStrictParentOfType(file2.findElementAt(start - 1), PsiComment.class);
        PsiComment nextComment = (PsiComment)PsiTreeUtil.getNonStrictParentOfType(file2.findElementAt(end), PsiComment.class);
        if (prevComment == null || nextComment == null) {
            return -1;
        }
        boolean sameComment = prevComment == nextComment;
        boolean adjacentLineComments = false;
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(file2.getLanguage());
        if (commenter == null) {
            return -1;
        }
        String blockCommentSuffix = commenter.getBlockCommentSuffix();
        if ("*/".equals(blockCommentSuffix) && text2.charAt(end) == '*' && end < text2.length() && text2.charAt(end + 1) != '/') {
            end = StringUtil.skipWhitespaceForward(text2, end + 1);
        } else if (!(sameComment || blockCommentSuffix != null && CharArrayUtil.regionMatches(text2, start - 2, blockCommentSuffix))) {
            for (String lineCommentPrefix : commenter.getLineCommentPrefixes()) {
                int allowedEnd;
                if (!CharArrayUtil.regionMatches(text2, end, lineCommentPrefix)) continue;
                adjacentLineComments = true;
                end = StringUtil.skipWhitespaceForward(text2, end + lineCommentPrefix.length());
                int lineNumber = document.getLineNumber(start);
                int lineStart = document.getLineStartOffset(lineNumber);
                int nextEnd = document.getLineEndOffset(lineNumber + 1);
                int lineLength = start - lineStart;
                int margin = CodeStyle.getSettings((PsiFile)file2).getRightMargin(file2.getLanguage());
                if (lineLength > margin || lineLength + (nextEnd - end) + 1 <= margin) continue;
                assert (allowedEnd < nextEnd);
                for (allowedEnd = end + margin - lineLength - 1; allowedEnd > end && !Character.isWhitespace(text2.charAt(allowedEnd)); --allowedEnd) {
                }
                if (allowedEnd <= end) {
                    return end;
                }
                int endOfMovedPart = StringUtil.skipWhitespaceBackward(text2, allowedEnd);
                CharSequence toMove = text2.subSequence(end, endOfMovedPart);
                int lineBreakPos = CharArrayUtil.indexOf(text2, (CharSequence)"\n", start);
                document.deleteString(end, allowedEnd + 1);
                document.replaceString(start, lineBreakPos, " " + toMove);
                return start + 1 + toMove.length() + (end - lineBreakPos);
            }
        }
        document.replaceString(start, end, adjacentLineComments || sameComment ? " " : "");
        return start;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/CommentJoinLinesHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryJoinLines";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "tryJoinRawLines";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

