/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class CompletionAutoPopupHandler
extends TypedHandlerDelegate {
    private static final Logger LOG = Logger.getInstance(CompletionAutoPopupHandler.class);
    public static final Key<Boolean> ourTestingAutopopup = Key.create("TestingAutopopup");

    @Override
    @NotNull
    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, @NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (project2 == null) {
            CompletionAutoPopupHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            CompletionAutoPopupHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            CompletionAutoPopupHandler.$$$reportNull$$$0(2);
        }
        LookupImpl lookup2 = (LookupImpl)LookupManager.getActiveLookup(editor2);
        CompletionPhase phase = CompletionServiceImpl.getCompletionPhase();
        if (LOG.isDebugEnabled()) {
            LOG.debug("checkAutoPopup: character=" + charTyped + ";");
            LOG.debug("phase=" + phase);
            LOG.debug("lookup=" + lookup2);
            LOG.debug("currentCompletion=" + CompletionServiceImpl.getCompletionService().getCurrentCompletion());
        }
        if (lookup2 != null) {
            if (editor2.getSelectionModel().hasSelection()) {
                lookup2.performGuardedChange(() -> EditorModificationUtil.deleteSelectedText((Editor)editor2));
            }
            TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.STOP;
            if (result2 == null) {
                CompletionAutoPopupHandler.$$$reportNull$$$0(3);
            }
            return result2;
        }
        if (Character.isLetterOrDigit(charTyped) || charTyped == '_') {
            if (phase instanceof CompletionPhase.EmptyAutoPopup && ((CompletionPhase.EmptyAutoPopup)phase).allowsSkippingNewAutoPopup(editor2, charTyped)) {
                TypedHandlerDelegate.Result result3 = TypedHandlerDelegate.Result.CONTINUE;
                if (result3 == null) {
                    CompletionAutoPopupHandler.$$$reportNull$$$0(4);
                }
                return result3;
            }
            AutoPopupController.getInstance(project2).scheduleAutoPopup(editor2);
            TypedHandlerDelegate.Result result4 = TypedHandlerDelegate.Result.STOP;
            if (result4 == null) {
                CompletionAutoPopupHandler.$$$reportNull$$$0(5);
            }
            return result4;
        }
        TypedHandlerDelegate.Result result5 = TypedHandlerDelegate.Result.CONTINUE;
        if (result5 == null) {
            CompletionAutoPopupHandler.$$$reportNull$$$0(6);
        }
        return result5;
    }

    @Deprecated(forRemoval=true)
    public static void runLaterWithCommitted(@NotNull Project project2, Document document, @NotNull Runnable runnable) {
        if (project2 == null) {
            CompletionAutoPopupHandler.$$$reportNull$$$0(7);
        }
        if (runnable == null) {
            CompletionAutoPopupHandler.$$$reportNull$$$0(8);
        }
        AppUIExecutor.onUiThread().later().withDocumentsCommitted(project2).execute(runnable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/CompletionAutoPopupHandler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/CompletionAutoPopupHandler";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAutoPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkAutoPopup";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "runLaterWithCommitted";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4, 5, 6 -> new IllegalStateException(string2);
        };
    }
}

