/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.IndentTransferableData;
import com.intellij.codeInsight.editorActions.PreserveIndentOnPasteBean;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CopyPasteIndentProcessor
extends CopyPastePostProcessor<IndentTransferableData> {
    @Override
    @NotNull
    public List<IndentTransferableData> collectTransferableData(@NotNull PsiFile file2, @NotNull Editor editor2, int @NotNull [] startOffsets, int @NotNull [] endOffsets) {
        if (file2 == null) {
            CopyPasteIndentProcessor.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            CopyPasteIndentProcessor.$$$reportNull$$$0(1);
        }
        if (startOffsets == null) {
            CopyPasteIndentProcessor.$$$reportNull$$$0(2);
        }
        if (endOffsets == null) {
            CopyPasteIndentProcessor.$$$reportNull$$$0(3);
        }
        if (!CopyPasteIndentProcessor.acceptFileType(file2.getFileType())) {
            List<IndentTransferableData> list2 = Collections.emptyList();
            if (list2 == null) {
                CopyPasteIndentProcessor.$$$reportNull$$$0(4);
            }
            return list2;
        }
        List<IndentTransferableData> list3 = Collections.singletonList(new IndentTransferableData(editor2.getCaretModel().getOffset()));
        if (list3 == null) {
            CopyPasteIndentProcessor.$$$reportNull$$$0(5);
        }
        return list3;
    }

    private static boolean acceptFileType(FileType fileType) {
        return PreserveIndentOnPasteBean.EP_NAME.getExtensionList().stream().anyMatch(bean -> fileType.getName().equals(bean.fileType));
    }

    @Override
    @NotNull
    public List<IndentTransferableData> extractTransferableData(@NotNull Transferable content2) {
        if (content2 == null) {
            CopyPasteIndentProcessor.$$$reportNull$$$0(6);
        }
        IndentTransferableData indentData = new IndentTransferableData(-1);
        try {
            Object transferData;
            DataFlavor flavor = IndentTransferableData.getDataFlavorStatic();
            if (flavor != null && (transferData = content2.getTransferData(flavor)) instanceof IndentTransferableData) {
                indentData = (IndentTransferableData)transferData;
            }
        }
        catch (UnsupportedFlavorException | IOException exception) {
            // empty catch block
        }
        List<IndentTransferableData> list2 = Collections.singletonList(indentData);
        if (list2 == null) {
            CopyPasteIndentProcessor.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Override
    public void processTransferableData(final @NotNull Project project2, final @NotNull Editor editor2, final @NotNull RangeMarker bounds, final int caretOffset, final @NotNull Ref<? super Boolean> indented, @NotNull List<? extends IndentTransferableData> values2) {
        if (project2 == null) {
            CopyPasteIndentProcessor.$$$reportNull$$$0(8);
        }
        if (editor2 == null) {
            CopyPasteIndentProcessor.$$$reportNull$$$0(9);
        }
        if (bounds == null) {
            CopyPasteIndentProcessor.$$$reportNull$$$0(10);
        }
        if (indented == null) {
            CopyPasteIndentProcessor.$$$reportNull$$$0(11);
        }
        if (values2 == null) {
            CopyPasteIndentProcessor.$$$reportNull$$$0(12);
        }
        if (!CodeInsightSettings.getInstance().INDENT_TO_CARET_ON_PASTE) {
            return;
        }
        assert (values2.size() == 1);
        if (values2.get(0).getOffset() == caretOffset) {
            return;
        }
        final Document document = editor2.getDocument();
        final PsiFile psiFile = PsiDocumentManager.getInstance(project2).getPsiFile(document);
        if (psiFile == null || !CopyPasteIndentProcessor.acceptFileType(psiFile.getFileType())) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                boolean useTabs = CodeStyle.getSettings((PsiFile)psiFile).useTabCharacter(psiFile.getFileType());
                CharFilter NOT_INDENT_FILTER = ch -> useTabs ? ch != '\t' : ch != ' ';
                String pastedText = document.getText(bounds.getTextRange());
                int startLine = document.getLineNumber(bounds.getStartOffset());
                int endLine = document.getLineNumber(bounds.getEndOffset());
                int fromIndent = StringUtil.findFirst(pastedText, NOT_INDENT_FILTER);
                if (fromIndent < 0) {
                    fromIndent = 0;
                }
                String initialText = document.getText(TextRange.create(0, bounds.getStartOffset())) + document.getText(TextRange.create(bounds.getEndOffset(), document.getTextLength()));
                int toIndent = 0;
                if (initialText.length() > 0) {
                    DocumentImpl initialDocument = new DocumentImpl(initialText);
                    int lineNumber = initialDocument.getTextLength() > caretOffset ? initialDocument.getLineNumber(caretOffset) : initialDocument.getLineCount() - 1;
                    int offset2 = CopyPasteIndentProcessor.getLineStartSafeOffset(initialDocument, lineNumber);
                    if (bounds.getStartOffset() == offset2) {
                        String toString2 = initialDocument.getText(TextRange.create(offset2, initialDocument.getLineEndOffset(lineNumber)));
                        toIndent = StringUtil.findFirst(toString2, NOT_INDENT_FILTER);
                        if (toIndent < 0 && StringUtil.isEmptyOrSpaces(toString2)) {
                            toIndent = toString2.length();
                        } else if ((toIndent < 0 || toString2.startsWith("\n")) && initialText.length() >= caretOffset) {
                            toIndent = caretOffset - offset2;
                        }
                    } else {
                        if (this.isNotApplicable(initialDocument, offset2)) {
                            return;
                        }
                        ++startLine;
                        toIndent = Math.abs(bounds.getStartOffset() - offset2);
                    }
                }
                int indent = toIndent - fromIndent;
                if (useTabs) {
                    indent *= CodeStyle.getSettings((PsiFile)psiFile).getTabSize(psiFile.getFileType());
                }
                if (!StringUtil.startsWithWhitespace(pastedText) && !StringUtil.endsWithLineBreak(pastedText) && StringUtil.splitByLines(pastedText).length <= 1) {
                    return;
                }
                if (pastedText.endsWith("\n")) {
                    --endLine;
                }
                for (int i2 = startLine; i2 <= endLine; ++i2) {
                    EditorActionUtil.indentLine((Project)project2, (Editor)editor2, (int)i2, (int)indent);
                }
                indented.set(Boolean.TRUE);
            }

            private boolean isNotApplicable(DocumentImpl initialDocument, int offset2) {
                return caretOffset < initialDocument.getTextLength() && !StringUtil.isEmptyOrSpaces(initialDocument.getText(TextRange.create(offset2, caretOffset)));
            }
        });
    }

    private static int getLineStartSafeOffset(Document document, int line) {
        if (line >= document.getLineCount()) {
            return document.getTextLength();
        }
        return document.getLineStartOffset(line);
    }

    @Override
    public boolean requiresAllDocumentsToBeCommitted(@NotNull Editor editor2, @NotNull Project project2) {
        if (editor2 == null) {
            CopyPasteIndentProcessor.$$$reportNull$$$0(13);
        }
        if (project2 == null) {
            CopyPasteIndentProcessor.$$$reportNull$$$0(14);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startOffsets";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endOffsets";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/CopyPasteIndentProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indented";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/CopyPasteIndentProcessor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTransferableData";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "extractTransferableData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectTransferableData";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "extractTransferableData";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processTransferableData";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "requiresAllDocumentsToBeCommitted";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 5, 7 -> new IllegalStateException(string2);
        };
    }
}

