/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.CopyAction;
import com.intellij.openapi.editor.actions.DocumentGuardedTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class CutHandler
extends EditorWriteActionHandler {
    private final EditorActionHandler myOriginalHandler;

    public CutHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public void executeWriteAction(@NotNull Editor editor2, Caret caret, DataContext dataContext2) {
        PsiFile file2;
        if (editor2 == null) {
            CutHandler.$$$reportNull$$$0(0);
        }
        assert (caret == null) : "Invocation of 'cut' operation for specific caret is not supported";
        Project project2 = editor2.getProject();
        PsiFile psiFile = file2 = project2 == null ? null : PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument());
        if (file2 == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor2, null, dataContext2);
            }
            return;
        }
        SelectionModel selectionModel = editor2.getSelectionModel();
        CopyAction.SelectionToCopy selectionToCopy = CopyAction.prepareSelectionToCut((Editor)editor2);
        if (selectionToCopy == null) {
            return;
        }
        dataContext2 = selectionToCopy.extendDataContext(dataContext2);
        int start = selectionModel.getSelectionStart();
        int end = selectionModel.getSelectionEnd();
        ArrayList selections2 = new ArrayList();
        if (editor2.getCaretModel().supportsMultipleCarets()) {
            editor2.getCaretModel().runForEachCaret(__ -> selections2.add(new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd())));
        }
        EditorActionManager.getInstance().getActionHandler("EditorCopy").execute(editor2, null, dataContext2);
        if (editor2.getCaretModel().supportsMultipleCarets()) {
            Collections.reverse(selections2);
            Iterator it = selections2.iterator();
            editor2.getCaretModel().runForEachCaret(__ -> {
                TextRange range = (TextRange)it.next();
                editor2.getCaretModel().moveToOffset(range.getStartOffset());
                selectionModel.removeSelection();
                DocumentGuardedTextUtil.deleteString((Document)editor2.getDocument(), (int)range.getStartOffset(), (int)range.getEndOffset());
            });
            editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        } else if (start != end) {
            editor2.getDocument().deleteString(start, end);
        } else {
            EditorModificationUtil.deleteSelectedText((Editor)editor2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/CutHandler", "executeWriteAction"));
    }
}

