/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandler;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExtendWordSelectionHandlerBase
implements ExtendWordSelectionHandler {
    private static final Logger LOG = Logger.getInstance(ExtendWordSelectionHandlerBase.class);

    @Override
    public abstract boolean canSelect(@NotNull PsiElement var1);

    @Override
    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor2) {
        TextRange originalRange;
        if (e == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(0);
        }
        if (editorText == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(1);
        }
        if (editor2 == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(2);
        }
        if ((originalRange = e.getTextRange()).getEndOffset() > editorText.length()) {
            throw new RuntimeExceptionWithAttachments("Invalid element range in " + this.getClass(), "element=" + e + "; range=" + originalRange + "; text length=" + editorText.length() + "; editor=" + editor2 + "; committed=" + PsiDocumentManager.getInstance(e.getProject()).isCommitted(editor2.getDocument()), new Attachment("editor_text.txt", editorText.toString()), new Attachment("psi_text.txt", e.getText()));
        }
        List<TextRange> ranges2 = ExtendWordSelectionHandlerBase.expandToWholeLine(editorText, originalRange, true);
        if (ranges2.size() == 1 && ranges2.contains(originalRange)) {
            return ExtendWordSelectionHandlerBase.expandToWholeLine(editorText, originalRange, false);
        }
        return ranges2;
    }

    public int getMinimalTextRangeLength(@NotNull PsiElement element, @NotNull CharSequence text2, int cursorOffset) {
        if (element == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(3);
        }
        if (text2 == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(4);
        }
        return 0;
    }

    @NotNull
    public static List<TextRange> expandToWholeLine(@NotNull CharSequence text2, @Nullable TextRange range, boolean isSymmetric) {
        TextRange expanded;
        if (text2 == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(5);
        }
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        if (range == null) {
            ArrayList<TextRange> arrayList = result2;
            if (arrayList == null) {
                ExtendWordSelectionHandlerBase.$$$reportNull$$$0(6);
            }
            return arrayList;
        }
        LOG.assertTrue(range.getEndOffset() <= text2.length());
        if (!StringUtil.contains(text2, range.getStartOffset(), range.getEndOffset(), '\n')) {
            result2.add(range);
        }
        if ((expanded = ExtendWordSelectionHandlerBase.getExpandedRange(text2, range, isSymmetric)) != null) {
            result2.add(expanded);
        } else {
            result2.add(range);
        }
        ArrayList<TextRange> arrayList = result2;
        if (arrayList == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Nullable
    private static TextRange getExpandedRange(@NotNull CharSequence text2, @NotNull TextRange range, boolean isSymmetric) {
        if (text2 == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(8);
        }
        if (range == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(9);
        }
        int startOffset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        int index1 = CharArrayUtil.shiftBackward(text2, startOffset - 1, " \t");
        if (endOffset > startOffset && text2.charAt(endOffset - 1) == '\n') {
            --endOffset;
        }
        int textLength = text2.length();
        int index2 = Math.min(textLength, CharArrayUtil.shiftForward(text2, endOffset, " \t"));
        if (index1 < 0 || text2.charAt(index1) == '\n' || index2 == textLength || text2.charAt(index2) == '\n') {
            if (!isSymmetric) {
                if (index1 < 0 || text2.charAt(index1) == '\n') {
                    startOffset = index1 + 1;
                }
                if ((index2 == textLength || text2.charAt(index2) == '\n') && (endOffset = index2) < textLength) {
                    ++endOffset;
                }
                return new TextRange(startOffset, endOffset);
            }
            if (!(index1 >= 0 && text2.charAt(index1) != '\n' || index2 != textLength && text2.charAt(index2) != '\n')) {
                startOffset = index1 + 1;
                endOffset = index2;
                if (endOffset < textLength) {
                    ++endOffset;
                }
                return new TextRange(startOffset, endOffset);
            }
        }
        return null;
    }

    @NotNull
    public static List<TextRange> expandToWholeLinesWithBlanks(@NotNull CharSequence text2, @NotNull TextRange range) {
        int blankLineEnd;
        if (text2 == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(10);
        }
        if (range == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(11);
        }
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        result2.addAll(ExtendWordSelectionHandlerBase.expandToWholeLine(text2, range, true));
        TextRange last2 = result2.isEmpty() ? range : (TextRange)result2.get(result2.size() - 1);
        int start = last2.getStartOffset();
        int end = last2.getEndOffset();
        while ((blankLineEnd = CharArrayUtil.shiftForward(text2, end, " \t")) < text2.length() && text2.charAt(blankLineEnd) == '\n') {
            end = blankLineEnd + 1;
        }
        if (end == last2.getEndOffset()) {
            int blankLineStart;
            while (start > 0 && text2.charAt(start - 1) == '\n' && (blankLineStart = CharArrayUtil.shiftBackward(text2, start - 2, " \t")) > 0 && text2.charAt(blankLineStart) == '\n') {
                start = blankLineStart + 1;
            }
        }
        if (start != last2.getStartOffset() || end != last2.getEndOffset()) {
            result2.add(new TextRange(start, end));
        }
        ArrayList<TextRange> arrayList = result2;
        if (arrayList == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    public static List<TextRange> expandToWholeLine(@NotNull CharSequence text2, @Nullable TextRange range) {
        if (text2 == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(13);
        }
        return ExtendWordSelectionHandlerBase.expandToWholeLine(text2, range, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/ExtendWordSelectionHandlerBase";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/ExtendWordSelectionHandlerBase";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "expandToWholeLine";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "expandToWholeLinesWithBlanks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMinimalTextRangeLength";
                break;
            }
            case 5: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "expandToWholeLine";
                break;
            }
            case 6: 
            case 7: 
            case 12: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getExpandedRange";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "expandToWholeLinesWithBlanks";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 7, 12 -> new IllegalStateException(string2);
        };
    }
}

