/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.execution.console.ConsoleExecutionEditor;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000e"}, d2={"Lcom/intellij/codeInsight/editorActions/LanguageConsolePasteHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "originalHandler", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "getOriginalHandler", "()Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "doExecute", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.platform.lang.impl"})
public final class LanguageConsolePasteHandler
extends EditorActionHandler {
    @NotNull
    private final EditorActionHandler originalHandler;

    public LanguageConsolePasteHandler(@NotNull EditorActionHandler originalHandler) {
        Intrinsics.checkNotNullParameter((Object)originalHandler, (String)"originalHandler");
        this.originalHandler = originalHandler;
    }

    @NotNull
    public final EditorActionHandler getOriginalHandler() {
        return this.originalHandler;
    }

    protected void doExecute(@NotNull Editor editor2, @Nullable Caret caret, @Nullable DataContext dataContext2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (editor2.getEditorKind() == EditorKind.CONSOLE && editor2.isViewer() && dataContext2 != null) {
            ConsoleExecutionEditor consoleExecutionEditor = (ConsoleExecutionEditor)editor2.getUserData(LanguageConsoleView.EXECUTION_EDITOR_KEY);
            if (consoleExecutionEditor != null) {
                ConsoleExecutionEditor executionEditor = consoleExecutionEditor;
                boolean bl = false;
                if (executionEditor.isConsoleEditorEnabled()) {
                    executionEditor.getEditor().getPasteProvider().performPaste(dataContext2);
                    IdeFocusManager.getGlobalInstance().requestFocus((Component)executionEditor.getEditor().getContentComponent(), true);
                    return;
                }
            }
        }
        this.originalHandler.execute(editor2, caret, dataContext2);
    }
}

