/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineCommentCopyPastePreProcessor
implements CopyPastePreProcessor {
    @Override
    @Nullable
    public String preprocessOnCopy(PsiFile file2, int[] startOffsets, int[] endOffsets, String text2) {
        return null;
    }

    @Override
    @NotNull
    public String preprocessOnPaste(Project project2, PsiFile file2, Editor editor2, String text2, RawText rawText) {
        Language language = file2.getLanguage();
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        if (commenter == null) {
            String string2 = text2;
            if (string2 == null) {
                LineCommentCopyPastePreProcessor.$$$reportNull$$$0(0);
            }
            return string2;
        }
        String lineCommentPrefix = commenter.getLineCommentPrefix();
        if (lineCommentPrefix == null) {
            String string3 = text2;
            if (string3 == null) {
                LineCommentCopyPastePreProcessor.$$$reportNull$$$0(1);
            }
            return string3;
        }
        Document document = editor2.getDocument();
        int offset2 = editor2.getSelectionModel().getSelectionStart();
        if (DocumentUtil.isAtLineEnd(offset2, editor2.getDocument()) && text2.startsWith("\n")) {
            String string4 = text2;
            if (string4 == null) {
                LineCommentCopyPastePreProcessor.$$$reportNull$$$0(2);
            }
            return string4;
        }
        int lineStartOffset = DocumentUtil.getLineStartOffset(offset2, document);
        CharSequence chars = document.getImmutableCharSequence();
        int firstNonWsLineOffset = CharArrayUtil.shiftForward(chars, lineStartOffset, " \t");
        if (offset2 < firstNonWsLineOffset + lineCommentPrefix.length() || !CharArrayUtil.regionMatches(chars, firstNonWsLineOffset, lineCommentPrefix)) {
            String string5 = text2;
            if (string5 == null) {
                LineCommentCopyPastePreProcessor.$$$reportNull$$$0(3);
            }
            return string5;
        }
        CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((PsiFile)file2);
        String lineStartReplacement = "\n" + chars.subSequence(lineStartOffset, firstNonWsLineOffset + lineCommentPrefix.length()) + (codeStyleSettings.getCommonSettings((Language)language).LINE_COMMENT_ADD_SPACE ? " " : "");
        String string6 = StringUtil.trimTrailing(text2, '\n').replace("\n", lineStartReplacement);
        if (string6 == null) {
            LineCommentCopyPastePreProcessor.$$$reportNull$$$0(4);
        }
        return string6;
    }

    @Override
    public boolean requiresAllDocumentsToBeCommitted(@NotNull Editor editor2, @NotNull Project project2) {
        if (editor2 == null) {
            LineCommentCopyPastePreProcessor.$$$reportNull$$$0(5);
        }
        if (project2 == null) {
            LineCommentCopyPastePreProcessor.$$$reportNull$$$0(6);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/LineCommentCopyPastePreProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOnPaste";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/LineCommentCopyPastePreProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "requiresAllDocumentsToBeCommitted";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 5, 6 -> new IllegalArgumentException(string2);
        };
    }
}

