/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class SelectionQuotingTypedHandler
extends TypedHandlerDelegate {
    private static final ExtensionPointName<UnquotingFilter> EP_NAME = ExtensionPointName.create("com.intellij.selectionUnquotingFilter");

    @Override
    @NotNull
    public TypedHandlerDelegate.Result beforeSelectionRemoved(char c2, @NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        char selectedChar;
        String selectedText;
        if (project2 == null) {
            SelectionQuotingTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            SelectionQuotingTypedHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            SelectionQuotingTypedHandler.$$$reportNull$$$0(2);
        }
        SelectionModel selectionModel = editor2.getSelectionModel();
        if (CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE && selectionModel.hasSelection() && SelectionQuotingTypedHandler.isDelimiter(c2) && (selectedText = selectionModel.getSelectedText()) != null && selectedText.length() == 1 && SelectionQuotingTypedHandler.isSimilarDelimiters(selectedChar = selectedText.charAt(0), c2) && selectedChar != c2 && !SelectionQuotingTypedHandler.shouldSkipReplacementOfQuotesOrBraces(file2, editor2, selectedText, c2) && SelectionQuotingTypedHandler.replaceQuotesBySelected(c2, editor2, file2, selectionModel, selectedChar)) {
            TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.STOP;
            if (result2 == null) {
                SelectionQuotingTypedHandler.$$$reportNull$$$0(3);
            }
            return result2;
        }
        if (CodeInsightSettings.getInstance().SURROUND_SELECTION_ON_QUOTE_TYPED && selectionModel.hasSelection() && SelectionQuotingTypedHandler.isDelimiter(c2) && !StringUtil.isEmpty(selectedText = selectionModel.getSelectedText())) {
            int selectionStart = selectionModel.getSelectionStart();
            int selectionEnd = selectionModel.getSelectionEnd();
            if (SelectionQuotingTypedHandler.isReplaceInComparisonOperation(file2, selectionStart, selectedText, c2)) {
                TypedHandlerDelegate.Result result3 = super.beforeSelectionRemoved(c2, project2, editor2, file2);
                if (result3 == null) {
                    SelectionQuotingTypedHandler.$$$reportNull$$$0(4);
                }
                return result3;
            }
            if (selectedText.length() > 1) {
                char firstChar = selectedText.charAt(0);
                char lastChar = selectedText.charAt(selectedText.length() - 1);
                if (SelectionQuotingTypedHandler.isSimilarDelimiters(firstChar, c2) && lastChar == SelectionQuotingTypedHandler.getMatchingDelimiter(firstChar) && (SelectionQuotingTypedHandler.isQuote(firstChar) || firstChar != c2) && !SelectionQuotingTypedHandler.shouldSkipReplacementOfQuotesOrBraces(file2, editor2, selectedText, c2) && !SelectionQuotingTypedHandler.containsQuoteInside(selectedText, lastChar)) {
                    selectedText = selectedText.substring(1, selectedText.length() - 1);
                }
            }
            int caretOffset = selectionModel.getSelectionStart();
            char c22 = SelectionQuotingTypedHandler.getMatchingDelimiter(c2);
            String newText = c2 + selectedText + c22;
            boolean ltrSelection = selectionModel.getLeadSelectionOffset() != selectionModel.getSelectionEnd();
            boolean restoreStickySelection = editor2 instanceof EditorEx && ((EditorEx)editor2).isStickySelection();
            selectionModel.removeSelection();
            editor2.getDocument().replaceString(selectionStart, selectionEnd, newText);
            int startOffset = caretOffset + 1;
            int endOffset = caretOffset + newText.length() - 1;
            int length = editor2.getDocument().getTextLength();
            if (endOffset <= length) {
                if (restoreStickySelection) {
                    EditorEx editorEx = (EditorEx)editor2;
                    CaretModel caretModel = editorEx.getCaretModel();
                    caretModel.moveToOffset(ltrSelection ? startOffset : endOffset);
                    editorEx.setStickySelection(true);
                    caretModel.moveToOffset(ltrSelection ? endOffset : startOffset);
                } else {
                    if (ltrSelection || editor2 instanceof EditorWindow) {
                        editor2.getSelectionModel().setSelection(startOffset, endOffset);
                    } else {
                        editor2.getSelectionModel().setSelection(endOffset, startOffset);
                    }
                    editor2.getCaretModel().moveToOffset(ltrSelection ? endOffset : startOffset);
                }
                if (c2 == '{') {
                    int startOffsetToReformat = startOffset - 1;
                    int endOffsetToReformat = length > endOffset ? endOffset + 1 : endOffset;
                    CodeStyleManager.getInstance(project2).reformatText(file2, startOffsetToReformat, endOffsetToReformat);
                }
            }
            TypedHandlerDelegate.Result result4 = TypedHandlerDelegate.Result.STOP;
            if (result4 == null) {
                SelectionQuotingTypedHandler.$$$reportNull$$$0(5);
            }
            return result4;
        }
        TypedHandlerDelegate.Result result5 = super.beforeSelectionRemoved(c2, project2, editor2, file2);
        if (result5 == null) {
            SelectionQuotingTypedHandler.$$$reportNull$$$0(6);
        }
        return result5;
    }

    private static boolean isReplaceInComparisonOperation(@NotNull PsiFile file2, int offset2, @NotNull String selectedText, char c2) {
        if (file2 == null) {
            SelectionQuotingTypedHandler.$$$reportNull$$$0(7);
        }
        if (selectedText == null) {
            SelectionQuotingTypedHandler.$$$reportNull$$$0(8);
        }
        if ((c2 == '<' || c2 == '>') && selectedText.length() <= 3 && SelectionQuotingTypedHandler.isOnlyComparisons(selectedText)) {
            PsiElement elementAtOffset = file2.findElementAt(offset2);
            if (elementAtOffset != null) {
                IElementType tokenType = elementAtOffset.getNode().getElementType();
                ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(elementAtOffset.getLanguage());
                if (parserDefinition != null && (parserDefinition.getCommentTokens().contains(tokenType) || parserDefinition.getStringLiteralElements().contains(tokenType))) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static boolean isOnlyComparisons(@NotNull String text2) {
        if (text2 == null) {
            SelectionQuotingTypedHandler.$$$reportNull$$$0(9);
        }
        for (int i2 = 0; i2 < text2.length(); ++i2) {
            char c2 = text2.charAt(i2);
            if (c2 == '>' || c2 == '<' || c2 == '=' || c2 == '!') continue;
            return false;
        }
        return true;
    }

    private static boolean containsQuoteInside(String selectedText, char quote) {
        return selectedText.indexOf(quote, 1) != selectedText.length() - 1;
    }

    private static boolean replaceQuotesBySelected(char c2, @NotNull Editor editor2, @NotNull PsiFile file2, @NotNull SelectionModel selectionModel, char selectedChar) {
        if (editor2 == null) {
            SelectionQuotingTypedHandler.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            SelectionQuotingTypedHandler.$$$reportNull$$$0(11);
        }
        if (selectionModel == null) {
            SelectionQuotingTypedHandler.$$$reportNull$$$0(12);
        }
        int selectionStart = selectionModel.getSelectionStart();
        for (PsiElement element = file2.findElementAt(selectionStart); element != null; element = element.getParent()) {
            TextRange textRange = element.getTextRange();
            if (textRange != null && textRange.getLength() >= 2) {
                Document document;
                CharSequence charsSequence;
                int matchingCharOffset;
                boolean isAtStart;
                boolean bl = isAtStart = textRange.getStartOffset() == selectionStart;
                if ((isAtStart || textRange.getEndOffset() == selectionStart + 1 && SelectionQuotingTypedHandler.isQuote(c2)) && (matchingCharOffset = isAtStart ? textRange.getEndOffset() - 1 : textRange.getStartOffset()) < (charsSequence = (document = editor2.getDocument()).getCharsSequence()).length()) {
                    boolean otherQuoteMatchesSelected;
                    char matchingChar = charsSequence.charAt(matchingCharOffset);
                    boolean bl2 = isAtStart ? matchingChar == SelectionQuotingTypedHandler.getMatchingDelimiter(selectedChar) : (otherQuoteMatchesSelected = selectedChar == SelectionQuotingTypedHandler.getMatchingDelimiter(matchingChar));
                    if (otherQuoteMatchesSelected && !SelectionQuotingTypedHandler.containsQuoteInside(document.getText(textRange), charsSequence.charAt(textRange.getEndOffset() - 1))) {
                        SelectionQuotingTypedHandler.replaceChar(document, textRange.getStartOffset(), c2);
                        char c22 = SelectionQuotingTypedHandler.getMatchingDelimiter(c2);
                        SelectionQuotingTypedHandler.replaceChar(document, textRange.getEndOffset() - 1, c22);
                        editor2.getCaretModel().moveToOffset(selectionModel.getSelectionEnd());
                        selectionModel.removeSelection();
                        return true;
                    }
                }
            }
            if (element instanceof PsiFile) break;
        }
        return false;
    }

    public static boolean shouldSkipReplacementOfQuotesOrBraces(PsiFile psiFile, Editor editor2, String selectedText, char c2) {
        return EP_NAME.getExtensionList().stream().anyMatch(filter2 -> filter2.skipReplacementQuotesOrBraces(psiFile, editor2, selectedText, c2));
    }

    private static char getMatchingDelimiter(char c2) {
        if (c2 == '(') {
            return ')';
        }
        if (c2 == '[') {
            return ']';
        }
        if (c2 == '{') {
            return '}';
        }
        if (c2 == '<') {
            return '>';
        }
        return c2;
    }

    private static boolean isDelimiter(char c2) {
        return SelectionQuotingTypedHandler.isBracket(c2) || SelectionQuotingTypedHandler.isQuote(c2);
    }

    private static boolean isBracket(char c2) {
        return c2 == '(' || c2 == '{' || c2 == '[' || c2 == '<';
    }

    private static boolean isQuote(char c2) {
        return c2 == '\"' || c2 == '\'' || c2 == '`';
    }

    private static boolean isSimilarDelimiters(char c1, char c2) {
        return SelectionQuotingTypedHandler.isBracket(c1) && SelectionQuotingTypedHandler.isBracket(c2) || SelectionQuotingTypedHandler.isQuote(c1) && SelectionQuotingTypedHandler.isQuote(c2);
    }

    private static void replaceChar(Document document, int offset2, char newChar) {
        document.replaceString(offset2, offset2 + 1, String.valueOf(newChar));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/SelectionQuotingTypedHandler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedText";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/SelectionQuotingTypedHandler";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeSelectionRemoved";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeSelectionRemoved";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isReplaceInComparisonOperation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isOnlyComparisons";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "replaceQuotesBySelected";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4, 5, 6 -> new IllegalStateException(string2);
        };
    }

    public static abstract class UnquotingFilter {
        public abstract boolean skipReplacementQuotesOrBraces(@NotNull PsiFile var1, @NotNull Editor var2, @NotNull String var3, char var4);
    }
}

