/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.editorActions.AutoHardWrapHandler;
import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.MultiCharQuoteHandler;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.QuoteHandlerEP;
import com.intellij.codeInsight.editorActions.TabOutScopesTracker;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.editorActions.TypingActionsExtension;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.codeInsight.highlighting.NontrivialBraceMatcher;
import com.intellij.codeInsight.template.impl.editorActions.TypedActionHandlerBase;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LanguageQuoteHandling;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PreloadingActivity;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.ActionPlan;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.DefaultRawTypedHandler;
import com.intellij.openapi.editor.impl.TypedActionImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileWithOneLanguage;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypedHandler
extends TypedActionHandlerBase {
    private static final Set<Character> COMPLEX_CHARS = Set.of(Character.valueOf('\n'), Character.valueOf('\t'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('\"'), Character.valueOf('\''));
    private static final Logger LOG = Logger.getInstance(TypedHandler.class);
    private static final KeyedExtensionCollector<QuoteHandler, String> quoteHandlers = new KeyedExtensionCollector(QuoteHandlerEP.EP_NAME);

    public TypedHandler(TypedActionHandler originalHandler) {
        super(originalHandler);
    }

    @Nullable
    public static QuoteHandler getQuoteHandler(@NotNull PsiFile file2, @NotNull Editor editor2) {
        FileType fileFileType;
        FileType fileType;
        QuoteHandler quoteHandler;
        if (file2 == null) {
            TypedHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            TypedHandler.$$$reportNull$$$0(1);
        }
        if ((quoteHandler = TypedHandler.getQuoteHandlerForType(fileType = TypedHandler.getFileType(file2, editor2))) == null && (fileFileType = file2.getFileType()) != fileType) {
            quoteHandler = TypedHandler.getQuoteHandlerForType(fileFileType);
        }
        if (quoteHandler == null) {
            return TypedHandler.getLanguageQuoteHandler(file2.getViewProvider().getBaseLanguage());
        }
        return quoteHandler;
    }

    private static QuoteHandler getLanguageQuoteHandler(Language baseLanguage) {
        return (QuoteHandler)LanguageQuoteHandling.INSTANCE.forLanguage(baseLanguage);
    }

    @NotNull
    private static FileType getFileType(@NotNull PsiFile file2, @NotNull Editor editor2) {
        LanguageFileType associatedFileType;
        if (file2 == null) {
            TypedHandler.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            TypedHandler.$$$reportNull$$$0(3);
        }
        FileType fileType = file2.getFileType();
        Language language = PsiUtilBase.getLanguageInEditor(editor2, file2.getProject());
        if (language != null && language != PlainTextLanguage.INSTANCE && (associatedFileType = language.getAssociatedFileType()) != null) {
            fileType = associatedFileType;
        }
        FileType fileType2 = fileType;
        if (fileType2 == null) {
            TypedHandler.$$$reportNull$$$0(4);
        }
        return fileType2;
    }

    private static QuoteHandler getQuoteHandlerForType(@NotNull FileType fileType) {
        if (fileType == null) {
            TypedHandler.$$$reportNull$$$0(5);
        }
        return ContainerUtil.getFirstItem(quoteHandlers.forKey(fileType.getName()));
    }

    @Deprecated
    public static void registerQuoteHandler(@NotNull FileType fileType, @NotNull QuoteHandler quoteHandler) {
        if (fileType == null) {
            TypedHandler.$$$reportNull$$$0(6);
        }
        if (quoteHandler == null) {
            TypedHandler.$$$reportNull$$$0(7);
        }
        quoteHandlers.addExplicitExtension(fileType.getName(), quoteHandler);
    }

    @Override
    public void beforeExecute(@NotNull Editor editor2, char c2, @NotNull DataContext context2, @NotNull ActionPlan plan) {
        if (editor2 == null) {
            TypedHandler.$$$reportNull$$$0(8);
        }
        if (context2 == null) {
            TypedHandler.$$$reportNull$$$0(9);
        }
        if (plan == null) {
            TypedHandler.$$$reportNull$$$0(10);
        }
        if (COMPLEX_CHARS.contains(Character.valueOf(c2)) || Character.isSurrogate(c2)) {
            return;
        }
        for (TypedHandlerDelegate delegate2 : TypedHandlerDelegate.EP_NAME.getExtensionList()) {
            if (delegate2.isImmediatePaintingEnabled(editor2, c2, context2)) continue;
            return;
        }
        if (editor2.isInsertMode()) {
            int offset2 = plan.getCaretOffset();
            plan.replace(offset2, offset2, String.valueOf(c2));
        }
        super.beforeExecute(editor2, c2, context2, plan);
    }

    public void execute(@NotNull Editor originalEditor, char charTyped, @NotNull DataContext dataContext2) {
        if (originalEditor == null) {
            TypedHandler.$$$reportNull$$$0(11);
        }
        if (dataContext2 == null) {
            TypedHandler.$$$reportNull$$$0(12);
        }
        SlowOperations.allowSlowOperations(() -> this.doExecute(originalEditor, charTyped, dataContext2));
    }

    private void doExecute(@NotNull Editor originalEditor, char charTyped, @NotNull DataContext dataContext2) {
        PsiFile originalFile;
        Project project2;
        if (originalEditor == null) {
            TypedHandler.$$$reportNull$$$0(13);
        }
        if (dataContext2 == null) {
            TypedHandler.$$$reportNull$$$0(14);
        }
        if ((project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2)) == null || (originalFile = PsiUtilBase.getPsiFileInEditor(originalEditor, project2)) == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(originalEditor, charTyped, dataContext2);
            }
            return;
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)originalEditor)) {
            return;
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance(project2);
        Document originalDocument = originalEditor.getDocument();
        for (TypedHandlerDelegate delegate2 : TypedHandlerDelegate.EP_NAME.getExtensionList()) {
            delegate2.newTypingStarted(charTyped, originalEditor, dataContext2);
        }
        originalEditor.getCaretModel().runForEachCaret(caret -> {
            boolean handled;
            Editor editor2;
            PsiFile file2;
            if (psiDocumentManager.isDocumentBlockedByPsi(originalDocument)) {
                psiDocumentManager.doPostponedOperationsAndUnblockDocument(originalDocument);
            }
            PsiFile psiFile = file2 = (editor2 = TypedHandler.injectedEditorIfCharTypedIsSignificant(charTyped, originalEditor, originalFile)) == originalEditor ? originalFile : Objects.requireNonNull(psiDocumentManager.getPsiFile(editor2.getDocument()));
            if (caret == originalEditor.getCaretModel().getPrimaryCaret() && !(handled = TypedHandler.callDelegates(TypedHandlerDelegate::checkAutoPopup, charTyped, project2, editor2, file2))) {
                TypedHandler.autoPopupCompletion(editor2, charTyped, project2, file2);
                TypedHandler.autoPopupParameterInfo(editor2, charTyped, project2, file2);
            }
            if (editor2 instanceof EditorWindow && !((EditorWindow)editor2).isValid()) {
                editor2 = TypedHandler.injectedEditorIfCharTypedIsSignificant(charTyped, originalEditor, originalFile);
                PsiFile psiFile2 = file2 = editor2 == originalEditor ? originalFile : Objects.requireNonNull(psiDocumentManager.getPsiFile(editor2.getDocument()));
            }
            if (!editor2.isInsertMode()) {
                TypedHandler.type(originalEditor, project2, charTyped);
                return;
            }
            if (TypedHandler.callDelegates(TypedHandlerDelegate::beforeSelectionRemoved, charTyped, project2, editor2, file2)) {
                return;
            }
            EditorModificationUtilEx.deleteSelectedText((Editor)editor2);
            FileType fileType = TypedHandler.getFileType(file2, editor2);
            TypedDelegateFunc func = (delegate2, c1, p1, e1, f1) -> delegate2.beforeCharTyped(c1, p1, e1, f1, fileType);
            if (TypedHandler.callDelegates(func, charTyped, project2, editor2, file2)) {
                return;
            }
            if (')' == charTyped || ']' == charTyped || '}' == charTyped ? FileTypes.PLAIN_TEXT != fileType && TypedHandler.handleRParen(editor2, fileType, charTyped) : ('\"' == charTyped || '\'' == charTyped || '`' == charTyped) && TypedHandler.handleQuote(editor2, charTyped, file2)) {
                return;
            }
            long modificationStampBeforeTyping = editor2.getDocument().getModificationStamp();
            TypedHandler.type(originalEditor, project2, charTyped);
            AutoHardWrapHandler.getInstance().wrapLineIfNecessary(originalEditor, dataContext2, modificationStampBeforeTyping);
            if (editor2.isDisposed()) {
                return;
            }
            if (('(' == charTyped || '[' == charTyped || '{' == charTyped) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && fileType != FileTypes.PLAIN_TEXT) {
                TypedHandler.handleAfterLParen(editor2, fileType, charTyped);
            } else if ('}' == charTyped) {
                TypedHandler.indentClosingBrace(project2, editor2);
            } else if (')' == charTyped) {
                TypedHandler.indentClosingParenth(project2, editor2);
            }
            if (TypedHandler.callDelegates(TypedHandlerDelegate::charTyped, charTyped, project2, editor2, file2)) {
                return;
            }
            if ('{' == charTyped) {
                TypedHandler.indentOpenedBrace(project2, editor2);
            } else if ('(' == charTyped) {
                TypedHandler.indentOpenedParenth(project2, editor2);
            }
        });
    }

    private static boolean callDelegates(@NotNull TypedDelegateFunc action2, char charTyped, @NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (action2 == null) {
            TypedHandler.$$$reportNull$$$0(15);
        }
        if (project2 == null) {
            TypedHandler.$$$reportNull$$$0(16);
        }
        if (editor2 == null) {
            TypedHandler.$$$reportNull$$$0(17);
        }
        if (file2 == null) {
            TypedHandler.$$$reportNull$$$0(18);
        }
        boolean warned = false;
        for (TypedHandlerDelegate delegate2 : TypedHandlerDelegate.EP_NAME.getExtensionList()) {
            TypedHandlerDelegate.Result result2 = action2.call(delegate2, charTyped, project2, editor2, file2);
            if (editor2 instanceof EditorWindow && !((EditorWindow)editor2).isValid() && !warned) {
                LOG.warn(new IllegalStateException(delegate2.getClass() + " has invalidated injected editor on typing char '" + charTyped + "'. Please don't call commitDocument() there or other destructive methods"));
                warned = true;
            }
            if (result2 == TypedHandlerDelegate.Result.STOP) {
                return true;
            }
            if (result2 != TypedHandlerDelegate.Result.DEFAULT) continue;
            break;
        }
        return false;
    }

    private static void type(@NotNull Editor editor2, @NotNull Project project2, char charTyped) {
        if (editor2 == null) {
            TypedHandler.$$$reportNull$$$0(19);
        }
        if (project2 == null) {
            TypedHandler.$$$reportNull$$$0(20);
        }
        CommandProcessor.getInstance().setCurrentCommandName(EditorBundle.message((String)"typing.in.editor.command.name", (Object[])new Object[0]));
        EditorModificationUtilEx.insertStringAtCaret((Editor)editor2, (String)String.valueOf(charTyped), (boolean)true, (boolean)true);
        ((UndoManagerImpl)UndoManager.getInstance(project2)).addDocumentAsAffected(editor2.getDocument());
    }

    private static void autoPopupParameterInfo(@NotNull Editor editor2, char charTyped, @NotNull Project project2, @NotNull PsiFile file2) {
        if (editor2 == null) {
            TypedHandler.$$$reportNull$$$0(21);
        }
        if (project2 == null) {
            TypedHandler.$$$reportNull$$$0(22);
        }
        if (file2 == null) {
            TypedHandler.$$$reportNull$$$0(23);
        }
        if (!(charTyped != '(' && charTyped != ',' || TypedHandler.isInsideStringLiteral(editor2, file2))) {
            AutoPopupController.getInstance(project2).autoPopupParameterInfo(editor2, null);
        }
    }

    public static void autoPopupCompletion(@NotNull Editor editor2, char charTyped, @NotNull Project project2, @NotNull PsiFile file2) {
        if (editor2 == null) {
            TypedHandler.$$$reportNull$$$0(24);
        }
        if (project2 == null) {
            TypedHandler.$$$reportNull$$$0(25);
        }
        if (file2 == null) {
            TypedHandler.$$$reportNull$$$0(26);
        }
        boolean allowSlashes = Boolean.TRUE.equals(editor2.getUserData(AutoPopupController.ALLOW_AUTO_POPUP_FOR_SLASHES_IN_PATHS));
        if (charTyped == '.' || allowSlashes && charTyped == '/' || TypedHandler.isAutoPopup(editor2, file2, charTyped)) {
            AutoPopupController.getInstance(project2).autoPopupMemberLookup(editor2, null);
        }
    }

    public static void commitDocumentIfCurrentCaretIsNotTheFirstOne(@NotNull Editor editor2, @NotNull Project project2) {
        if (editor2 == null) {
            TypedHandler.$$$reportNull$$$0(27);
        }
        if (project2 == null) {
            TypedHandler.$$$reportNull$$$0(28);
        }
        if (ContainerUtil.getFirstItem(editor2.getCaretModel().getAllCarets()) != editor2.getCaretModel().getCurrentCaret()) {
            PsiDocumentManager.getInstance(project2).commitDocument(editor2.getDocument());
        }
    }

    private static boolean isAutoPopup(@NotNull Editor editor2, @NotNull PsiFile file2, char charTyped) {
        int offset2;
        if (editor2 == null) {
            TypedHandler.$$$reportNull$$$0(29);
        }
        if (file2 == null) {
            TypedHandler.$$$reportNull$$$0(30);
        }
        if ((offset2 = editor2.getCaretModel().getOffset() - 1) >= 0) {
            Language language;
            PsiElement element;
            if (file2 instanceof PsiFileWithOneLanguage) {
                element = null;
                language = file2.getLanguage();
            } else {
                element = file2.findElementAt(offset2);
                if (element == null) {
                    return false;
                }
                language = element.getLanguage();
            }
            for (CompletionContributor contributor : CompletionContributor.forLanguageHonorDumbness(language, file2.getProject())) {
                if (element == null && (element = file2.findElementAt(offset2)) == null) {
                    return false;
                }
                if (!contributor.invokeAutoPopup(element, charTyped)) continue;
                LOG.debug(contributor + " requested completion autopopup when typing '" + charTyped + "'");
                return true;
            }
        }
        return false;
    }

    private static boolean isInsideStringLiteral(@NotNull Editor editor2, @NotNull PsiFile file2) {
        int offset2;
        PsiElement element;
        if (editor2 == null) {
            TypedHandler.$$$reportNull$$$0(31);
        }
        if (file2 == null) {
            TypedHandler.$$$reportNull$$$0(32);
        }
        if ((element = file2.findElementAt(offset2 = editor2.getCaretModel().getOffset())) == null) {
            return false;
        }
        ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(element.getLanguage());
        if (definition != null) {
            TokenSet stringLiteralElements = definition.getStringLiteralElements();
            ASTNode node2 = element.getNode();
            if (node2 == null) {
                return false;
            }
            IElementType elementType = node2.getElementType();
            if (stringLiteralElements.contains(elementType)) {
                return true;
            }
            PsiElement parent2 = element.getParent();
            if (parent2 != null) {
                ASTNode parentNode = parent2.getNode();
                return parentNode != null && stringLiteralElements.contains(parentNode.getElementType());
            }
        }
        return false;
    }

    @NotNull
    public static Editor injectedEditorIfCharTypedIsSignificant(char charTyped, @NotNull Editor editor2, @NotNull PsiFile oldFile) {
        if (editor2 == null) {
            TypedHandler.$$$reportNull$$$0(33);
        }
        if (oldFile == null) {
            TypedHandler.$$$reportNull$$$0(34);
        }
        return TypedHandler.injectedEditorIfCharTypedIsSignificant((int)charTyped, editor2, oldFile);
    }

    @NotNull
    static Editor injectedEditorIfCharTypedIsSignificant(int charTyped, @NotNull Editor editor2, @NotNull PsiFile oldFile) {
        if (editor2 == null) {
            TypedHandler.$$$reportNull$$$0(35);
        }
        if (oldFile == null) {
            TypedHandler.$$$reportNull$$$0(36);
        }
        int offset2 = editor2.getCaretModel().getOffset();
        List<DocumentWindow> injected = InjectedLanguageManager.getInstance(oldFile.getProject()).getCachedInjectedDocumentsInRange(oldFile, ProperTextRange.create(offset2, offset2));
        for (DocumentWindow documentWindow : injected) {
            PsiFile injectedFile;
            if (!documentWindow.isValid() || !documentWindow.containsRange(offset2, offset2) || (injectedFile = PsiDocumentManager.getInstance(oldFile.getProject()).getPsiFile(documentWindow)) == null) continue;
            Editor injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor2, injectedFile);
            TextRange hostRange = documentWindow.getHostRange(offset2);
            CharSequence sequence = editor2.getDocument().getCharsSequence();
            if ((sequence.length() <= offset2 || charTyped == Character.codePointAt(sequence, offset2)) && (hostRange == null || !hostRange.contains(offset2))) continue;
            Editor editor3 = injectedEditor;
            if (editor3 == null) {
                TypedHandler.$$$reportNull$$$0(37);
            }
            return editor3;
        }
        Editor editor4 = editor2;
        if (editor4 == null) {
            TypedHandler.$$$reportNull$$$0(38);
        }
        return editor4;
    }

    private static void handleAfterLParen(@NotNull Editor editor2, @NotNull FileType fileType, char lparenChar) {
        boolean matched;
        int lparenOffset;
        boolean atEndOfDocument;
        if (editor2 == null) {
            TypedHandler.$$$reportNull$$$0(39);
        }
        if (fileType == null) {
            TypedHandler.$$$reportNull$$$0(40);
        }
        int offset2 = editor2.getCaretModel().getOffset();
        HighlighterIterator iterator2 = editor2.getHighlighter().createIterator(offset2);
        boolean bl = atEndOfDocument = offset2 == editor2.getDocument().getTextLength();
        if (!atEndOfDocument) {
            iterator2.retreat();
        }
        if (iterator2.atEnd()) {
            return;
        }
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator2);
        if (iterator2.atEnd()) {
            return;
        }
        IElementType braceTokenType = iterator2.getTokenType();
        CharSequence fileText = editor2.getDocument().getCharsSequence();
        if (!braceMatcher.isLBraceToken(iterator2, fileText, fileType)) {
            return;
        }
        if (!iterator2.atEnd()) {
            iterator2.advance();
            if (!iterator2.atEnd() && !BraceMatchingUtil.isPairedBracesAllowedBeforeTypeInFileType(braceTokenType, iterator2.getTokenType(), fileType)) {
                return;
            }
            iterator2.retreat();
        }
        if ((lparenOffset = BraceMatchingUtil.findLeftmostLParen(iterator2, braceTokenType, fileText, fileType)) < 0) {
            lparenOffset = 0;
        }
        if (!(matched = BraceMatchingUtil.matchBrace(fileText, fileType, iterator2 = editor2.getHighlighter().createIterator(lparenOffset), true, true))) {
            String text2 = switch (lparenChar) {
                case '(' -> ")";
                case '[' -> "]";
                case '<' -> ">";
                case '{' -> "}";
                default -> throw new AssertionError((Object)("Unknown char '" + lparenChar + "'"));
            };
            editor2.getDocument().insertString(offset2, text2);
            TabOutScopesTracker.getInstance().registerEmptyScope(editor2, offset2);
        }
    }

    public static boolean handleRParen(@NotNull Editor editor2, @NotNull FileType fileType, char charTyped) {
        boolean matched;
        CharSequence text2;
        if (editor2 == null) {
            TypedHandler.$$$reportNull$$$0(41);
        }
        if (fileType == null) {
            TypedHandler.$$$reportNull$$$0(42);
        }
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return false;
        }
        int offset2 = editor2.getCaretModel().getOffset();
        if (offset2 == editor2.getDocument().getTextLength()) {
            return false;
        }
        HighlighterIterator iterator2 = editor2.getHighlighter().createIterator(offset2);
        if (iterator2.atEnd()) {
            return false;
        }
        if (iterator2.getEnd() - iterator2.getStart() != 1 || editor2.getDocument().getCharsSequence().charAt(iterator2.getStart()) != charTyped) {
            return false;
        }
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator2);
        if (!braceMatcher.isRBraceToken(iterator2, text2 = editor2.getDocument().getCharsSequence(), fileType)) {
            return false;
        }
        IElementType tokenType = iterator2.getTokenType();
        iterator2.retreat();
        IElementType lparenTokenType = braceMatcher.getOppositeBraceTokenType(tokenType);
        int lparenthOffset = BraceMatchingUtil.findLeftmostLParen(iterator2, lparenTokenType, text2, fileType);
        if (lparenthOffset < 0) {
            if (braceMatcher instanceof NontrivialBraceMatcher) {
                for (IElementType t : ((NontrivialBraceMatcher)braceMatcher).getOppositeBraceTokenTypes(tokenType)) {
                    if (t != lparenTokenType && (lparenthOffset = BraceMatchingUtil.findLeftmostLParen(iterator2, t, text2, fileType)) >= 0) break;
                }
            }
            if (lparenthOffset < 0) {
                return false;
            }
        }
        if (!(matched = BraceMatchingUtil.matchBrace(text2, fileType, iterator2 = editor2.getHighlighter().createIterator(lparenthOffset), true, true))) {
            return false;
        }
        EditorModificationUtil.moveCaretRelatively((Editor)editor2, (int)1);
        return true;
    }

    @ApiStatus.Internal
    public static boolean handleQuote(@NotNull Editor editor2, char quote, @NotNull PsiFile file2) {
        CharSequence closingQuote;
        if (editor2 == null) {
            TypedHandler.$$$reportNull$$$0(43);
        }
        if (file2 == null) {
            TypedHandler.$$$reportNull$$$0(44);
        }
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE) {
            return false;
        }
        QuoteHandler quoteHandler = TypedHandler.getQuoteHandler(file2, editor2);
        if (quoteHandler == null) {
            return false;
        }
        int offset2 = editor2.getCaretModel().getOffset();
        Document document = editor2.getDocument();
        CharSequence chars = document.getCharsSequence();
        int length = document.getTextLength();
        if (TypedHandler.isTypingEscapeQuote(editor2, quoteHandler, offset2)) {
            return false;
        }
        if (offset2 < length && chars.charAt(offset2) == quote && TypedHandler.isClosingQuote(editor2, quoteHandler, offset2)) {
            EditorModificationUtil.moveCaretRelatively((Editor)editor2, (int)1);
            return true;
        }
        HighlighterIterator iterator2 = editor2.getHighlighter().createIterator(offset2);
        if (!iterator2.atEnd()) {
            IElementType tokenType = iterator2.getTokenType();
            if (quoteHandler instanceof JavaLikeQuoteHandler) {
                try {
                    if (!((JavaLikeQuoteHandler)quoteHandler).isAppropriateElementTypeForLiteral(tokenType)) {
                        return false;
                    }
                }
                catch (AbstractMethodError abstractMethodError) {
                    // empty catch block
                }
            }
        }
        TypedHandler.type(editor2, file2.getProject(), quote);
        offset2 = editor2.getCaretModel().getOffset();
        if (quoteHandler instanceof MultiCharQuoteHandler && (closingQuote = TypedHandler.getClosingQuote(editor2, (MultiCharQuoteHandler)quoteHandler, offset2)) != null && TypedHandler.hasNonClosedLiterals(editor2, quoteHandler, offset2 - 1) && (offset2 == document.getTextLength() || !Character.isUnicodeIdentifierPart(document.getCharsSequence().charAt(offset2)))) {
            ((MultiCharQuoteHandler)quoteHandler).insertClosingQuote(editor2, offset2, file2, closingQuote);
            return true;
        }
        if (offset2 > 0 && TypedHandler.isOpeningQuote(editor2, quoteHandler, offset2 - 1) && TypedHandler.hasNonClosedLiterals(editor2, quoteHandler, offset2 - 1) && (offset2 == document.getTextLength() || !Character.isUnicodeIdentifierPart(document.getCharsSequence().charAt(offset2)))) {
            document.insertString(offset2, String.valueOf(quote));
            TabOutScopesTracker.getInstance().registerEmptyScope(editor2, offset2);
        }
        return true;
    }

    private static boolean isClosingQuote(@NotNull Editor editor2, @NotNull QuoteHandler quoteHandler, int offset2) {
        HighlighterIterator iterator2;
        if (editor2 == null) {
            TypedHandler.$$$reportNull$$$0(45);
        }
        if (quoteHandler == null) {
            TypedHandler.$$$reportNull$$$0(46);
        }
        if ((iterator2 = TypedHandler.createIteratorAndCheckNotAtEnd(editor2, offset2)) == null) {
            return false;
        }
        return quoteHandler.isClosingQuote(iterator2, offset2);
    }

    @Nullable
    private static HighlighterIterator createIteratorAndCheckNotAtEnd(@NotNull Editor editor2, int offset2) {
        HighlighterIterator iterator2;
        if (editor2 == null) {
            TypedHandler.$$$reportNull$$$0(47);
        }
        if ((iterator2 = editor2.getHighlighter().createIterator(offset2)).atEnd()) {
            LOG.error("Iterator " + iterator2 + " ended unexpectedly right after creation");
            return null;
        }
        return iterator2;
    }

    @Nullable
    private static CharSequence getClosingQuote(@NotNull Editor editor2, @NotNull MultiCharQuoteHandler quoteHandler, int offset2) {
        HighlighterIterator iterator2;
        if (editor2 == null) {
            TypedHandler.$$$reportNull$$$0(48);
        }
        if (quoteHandler == null) {
            TypedHandler.$$$reportNull$$$0(49);
        }
        if ((iterator2 = TypedHandler.createIteratorAndCheckNotAtEnd(editor2, offset2)) == null) {
            return null;
        }
        return quoteHandler.getClosingQuote(iterator2, offset2);
    }

    private static boolean isOpeningQuote(@NotNull Editor editor2, @NotNull QuoteHandler quoteHandler, int offset2) {
        HighlighterIterator iterator2;
        if (editor2 == null) {
            TypedHandler.$$$reportNull$$$0(50);
        }
        if (quoteHandler == null) {
            TypedHandler.$$$reportNull$$$0(51);
        }
        if ((iterator2 = TypedHandler.createIteratorAndCheckNotAtEnd(editor2, offset2)) == null) {
            return false;
        }
        return quoteHandler.isOpeningQuote(iterator2, offset2);
    }

    private static boolean hasNonClosedLiterals(@NotNull Editor editor2, @NotNull QuoteHandler quoteHandler, int offset2) {
        HighlighterIterator iterator2;
        if (editor2 == null) {
            TypedHandler.$$$reportNull$$$0(52);
        }
        if (quoteHandler == null) {
            TypedHandler.$$$reportNull$$$0(53);
        }
        if ((iterator2 = TypedHandler.createIteratorAndCheckNotAtEnd(editor2, offset2)) == null) {
            return false;
        }
        return quoteHandler.hasNonClosedLiteral(editor2, iterator2, offset2);
    }

    private static boolean isTypingEscapeQuote(@NotNull Editor editor2, @NotNull QuoteHandler quoteHandler, int offset2) {
        if (editor2 == null) {
            TypedHandler.$$$reportNull$$$0(54);
        }
        if (quoteHandler == null) {
            TypedHandler.$$$reportNull$$$0(55);
        }
        if (offset2 == 0) {
            return false;
        }
        CharSequence chars = editor2.getDocument().getCharsSequence();
        int offset1 = CharArrayUtil.shiftBackward(chars, offset2 - 1, "\\");
        int slashCount = offset2 - 1 - offset1;
        return slashCount % 2 != 0 && TypedHandler.isInsideLiteral(editor2, quoteHandler, offset2);
    }

    private static boolean isInsideLiteral(@NotNull Editor editor2, @NotNull QuoteHandler quoteHandler, int offset2) {
        if (editor2 == null) {
            TypedHandler.$$$reportNull$$$0(56);
        }
        if (quoteHandler == null) {
            TypedHandler.$$$reportNull$$$0(57);
        }
        if (offset2 == 0) {
            return false;
        }
        HighlighterIterator iterator2 = TypedHandler.createIteratorAndCheckNotAtEnd(editor2, offset2 - 1);
        if (iterator2 == null) {
            return false;
        }
        return quoteHandler.isInsideLiteral(iterator2);
    }

    private static void indentClosingBrace(@NotNull Project project2, @NotNull Editor editor2) {
        if (project2 == null) {
            TypedHandler.$$$reportNull$$$0(58);
        }
        if (editor2 == null) {
            TypedHandler.$$$reportNull$$$0(59);
        }
        TypedHandler.indentBrace(project2, editor2, '}');
    }

    public static void indentOpenedBrace(@NotNull Project project2, @NotNull Editor editor2) {
        if (project2 == null) {
            TypedHandler.$$$reportNull$$$0(60);
        }
        if (editor2 == null) {
            TypedHandler.$$$reportNull$$$0(61);
        }
        TypedHandler.indentBrace(project2, editor2, '{');
    }

    private static void indentOpenedParenth(@NotNull Project project2, @NotNull Editor editor2) {
        if (project2 == null) {
            TypedHandler.$$$reportNull$$$0(62);
        }
        if (editor2 == null) {
            TypedHandler.$$$reportNull$$$0(63);
        }
        TypedHandler.indentBrace(project2, editor2, '(');
    }

    private static void indentClosingParenth(@NotNull Project project2, @NotNull Editor editor2) {
        if (project2 == null) {
            TypedHandler.$$$reportNull$$$0(64);
        }
        if (editor2 == null) {
            TypedHandler.$$$reportNull$$$0(65);
        }
        TypedHandler.indentBrace(project2, editor2, ')');
    }

    public static void indentBrace(@NotNull Project project2, @NotNull Editor editor2, char braceChar) {
        if (project2 == null) {
            TypedHandler.$$$reportNull$$$0(66);
        }
        if (editor2 == null) {
            TypedHandler.$$$reportNull$$$0(67);
        }
        int offset2 = editor2.getCaretModel().getOffset() - 1;
        Document document = editor2.getDocument();
        CharSequence chars = document.getCharsSequence();
        if (offset2 < 0 || chars.charAt(offset2) != braceChar) {
            return;
        }
        int spaceStart = CharArrayUtil.shiftBackward(chars, offset2 - 1, " \t");
        if (spaceStart < 0 || chars.charAt(spaceStart) == '\n' || chars.charAt(spaceStart) == '\r') {
            PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(document);
            if (file2 == null || !file2.isWritable()) {
                return;
            }
            EditorHighlighter highlighter = editor2.getHighlighter();
            HighlighterIterator iterator2 = highlighter.createIterator(offset2);
            FileType fileType = file2.getFileType();
            BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator2);
            boolean rBraceToken = braceMatcher.isRBraceToken(iterator2, chars, fileType);
            boolean isBrace = braceMatcher.isLBraceToken(iterator2, chars, fileType) || rBraceToken;
            int lBraceOffset = -1;
            if (CodeInsightSettings.getInstance().REFORMAT_BLOCK_ON_RBRACE && rBraceToken && braceMatcher.isStructuralBrace(iterator2, chars, fileType) && offset2 > 0) {
                lBraceOffset = BraceMatchingUtil.findLeftLParen(highlighter.createIterator(offset2 - 1), braceMatcher.getOppositeBraceTokenType(iterator2.getTokenType()), editor2.getDocument().getCharsSequence(), fileType);
            }
            if (isBrace) {
                DefaultRawTypedHandler handler2 = ((TypedActionImpl)TypedAction.getInstance()).getDefaultRawTypedHandler();
                handler2.beginUndoablePostProcessing();
                int finalLBraceOffset = lBraceOffset;
                ApplicationManager.getApplication().runWriteAction(() -> {
                    TypingActionsExtension extension2 = TypingActionsExtension.findForContext(project2, editor2);
                    try {
                        RangeMarker marker = document.createRangeMarker(offset2, offset2 + 1);
                        if (finalLBraceOffset != -1) {
                            extension2.format(project2, editor2, 4, finalLBraceOffset, offset2, 0, false);
                        } else {
                            extension2.format(project2, editor2, 3, offset2, offset2, 0, false);
                        }
                        editor2.getCaretModel().moveToOffset(marker.getStartOffset() + 1);
                        editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                        editor2.getSelectionModel().removeSelection();
                        marker.dispose();
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error(e);
                    }
                });
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 37, 38 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 59: 
            case 61: 
            case 63: 
            case 65: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/TypedHandler";
                break;
            }
            case 5: 
            case 6: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 7: 
            case 46: 
            case 49: 
            case 51: 
            case 53: 
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quoteHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plan";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalEditor";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 16: 
            case 20: 
            case 22: 
            case 25: 
            case 28: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/TypedHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "injectedEditorIfCharTypedIsSignificant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuoteHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFileType";
                break;
            }
            case 4: 
            case 37: 
            case 38: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getQuoteHandlerForType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerQuoteHandler";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "beforeExecute";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "callDelegates";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "type";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "autoPopupParameterInfo";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "autoPopupCompletion";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "commitDocumentIfCurrentCaretIsNotTheFirstOne";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isAutoPopup";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isInsideStringLiteral";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "injectedEditorIfCharTypedIsSignificant";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "handleAfterLParen";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "handleRParen";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "handleQuote";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isClosingQuote";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "createIteratorAndCheckNotAtEnd";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getClosingQuote";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isOpeningQuote";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "hasNonClosedLiterals";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isTypingEscapeQuote";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isInsideLiteral";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "indentClosingBrace";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "indentOpenedBrace";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "indentOpenedParenth";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "indentClosingParenth";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "indentBrace";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 37, 38 -> new IllegalStateException(string2);
        };
    }

    @FunctionalInterface
    static interface TypedDelegateFunc {
        public TypedHandlerDelegate.Result call(@NotNull TypedHandlerDelegate var1, char var2, @NotNull Project var3, @NotNull Editor var4, @NotNull PsiFile var5);
    }

    static final class TypedHandlerDelegatePreloader
    extends PreloadingActivity {
        TypedHandlerDelegatePreloader() {
        }

        public void preload() {
            if (!ApplicationManagerEx.getApplicationEx().isLightEditMode()) {
                TypedHandlerDelegate.EP_NAME.getExtensionList();
            }
        }
    }
}

