/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TabOutScopesTracker;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public final class TypedHandlerUtil {
    private static int computeBracesBalance(@NotNull Editor editor2, int offset2, @NotNull IElementType lt, @NotNull IElementType gt, @NotNull TokenSet invalidInsideReference, boolean forwardDirection) {
        if (editor2 == null) {
            TypedHandlerUtil.$$$reportNull$$$0(0);
        }
        if (lt == null) {
            TypedHandlerUtil.$$$reportNull$$$0(1);
        }
        if (gt == null) {
            TypedHandlerUtil.$$$reportNull$$$0(2);
        }
        if (invalidInsideReference == null) {
            TypedHandlerUtil.$$$reportNull$$$0(3);
        }
        HighlighterIterator iterator2 = editor2.getHighlighter().createIterator(offset2);
        if (!forwardDirection && iterator2.getTokenType() != gt) {
            return -1;
        }
        while ((forwardDirection && iterator2.getStart() > 0 || !forwardDirection && !iterator2.atEnd()) && !invalidInsideReference.contains(iterator2.getTokenType())) {
            TypedHandlerUtil.incLookup(!forwardDirection, iterator2);
        }
        if ((forwardDirection || !iterator2.atEnd()) && invalidInsideReference.contains(iterator2.getTokenType())) {
            TypedHandlerUtil.incLookup(forwardDirection, iterator2);
        }
        int balance = 0;
        while (!iterator2.atEnd() && balance >= 0) {
            IElementType tokenType = iterator2.getTokenType();
            if (tokenType == lt) {
                balance = forwardDirection ? ++balance : --balance;
            } else if (tokenType == gt) {
                balance = forwardDirection ? --balance : ++balance;
            } else if (invalidInsideReference.contains(tokenType)) break;
            TypedHandlerUtil.incLookup(forwardDirection, iterator2);
        }
        return balance;
    }

    private static void incLookup(boolean forwardDirection, @NotNull HighlighterIterator iterator2) {
        if (iterator2 == null) {
            TypedHandlerUtil.$$$reportNull$$$0(4);
        }
        if (forwardDirection) {
            iterator2.advance();
        } else {
            iterator2.retreat();
        }
    }

    public static boolean isAfterClassLikeIdentifierOrDot(int offset2, @NotNull Editor editor2, @NotNull IElementType dot, @NotNull IElementType identifier, boolean allowAfterDot) {
        HighlighterIterator iterator2;
        if (editor2 == null) {
            TypedHandlerUtil.$$$reportNull$$$0(5);
        }
        if (dot == null) {
            TypedHandlerUtil.$$$reportNull$$$0(6);
        }
        if (identifier == null) {
            TypedHandlerUtil.$$$reportNull$$$0(7);
        }
        if ((iterator2 = editor2.getHighlighter().createIterator(offset2)).atEnd()) {
            return false;
        }
        if (offset2 != iterator2.getEnd() && iterator2.getStart() > 0) {
            iterator2.retreat();
        }
        IElementType tokenType = iterator2.getTokenType();
        if (allowAfterDot && tokenType == dot) {
            return true;
        }
        return TypedHandlerUtil.isClassLikeIdentifier(offset2, editor2, iterator2, identifier);
    }

    public static boolean isClassLikeIdentifier(int offset2, @NotNull Editor editor2, @NotNull HighlighterIterator iterator2, @NotNull IElementType idType) {
        if (editor2 == null) {
            TypedHandlerUtil.$$$reportNull$$$0(8);
        }
        if (iterator2 == null) {
            TypedHandlerUtil.$$$reportNull$$$0(9);
        }
        if (idType == null) {
            TypedHandlerUtil.$$$reportNull$$$0(10);
        }
        if (iterator2.getTokenType() == idType && iterator2.getEnd() == offset2) {
            CharSequence chars = editor2.getDocument().getCharsSequence();
            char startChar = chars.charAt(iterator2.getStart());
            if (!Character.isUpperCase(startChar)) {
                return false;
            }
            CharSequence word2 = chars.subSequence(iterator2.getStart(), iterator2.getEnd());
            if (word2.length() == 1) {
                return true;
            }
            for (int i2 = 1; i2 < word2.length(); ++i2) {
                if (!Character.isLowerCase(word2.charAt(i2))) continue;
                return true;
            }
        }
        return false;
    }

    public static void handleAfterGenericLT(@NotNull Editor editor2, @NotNull IElementType lt, @NotNull IElementType gt, @NotNull TokenSet invalidInsideReference) {
        if (editor2 == null) {
            TypedHandlerUtil.$$$reportNull$$$0(11);
        }
        if (lt == null) {
            TypedHandlerUtil.$$$reportNull$$$0(12);
        }
        if (gt == null) {
            TypedHandlerUtil.$$$reportNull$$$0(13);
        }
        if (invalidInsideReference == null) {
            TypedHandlerUtil.$$$reportNull$$$0(14);
        }
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return;
        }
        int offset2 = editor2.getCaretModel().getOffset();
        if (TypedHandlerUtil.computeBracesBalance(editor2, offset2, lt, gt, invalidInsideReference, true) == 1) {
            editor2.getDocument().insertString(offset2, ">");
            TabOutScopesTracker.getInstance().registerEmptyScope(editor2, offset2);
        }
    }

    public static boolean handleGenericGT(@NotNull Editor editor2, @NotNull IElementType lt, @NotNull IElementType gt, @NotNull TokenSet invalidInsideReference) {
        if (editor2 == null) {
            TypedHandlerUtil.$$$reportNull$$$0(15);
        }
        if (lt == null) {
            TypedHandlerUtil.$$$reportNull$$$0(16);
        }
        if (gt == null) {
            TypedHandlerUtil.$$$reportNull$$$0(17);
        }
        if (invalidInsideReference == null) {
            TypedHandlerUtil.$$$reportNull$$$0(18);
        }
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return false;
        }
        int offset2 = editor2.getCaretModel().getOffset();
        if (offset2 == editor2.getDocument().getTextLength()) {
            return false;
        }
        if (TypedHandlerUtil.computeBracesBalance(editor2, offset2, lt, gt, invalidInsideReference, false) != 0) {
            return false;
        }
        EditorModificationUtil.moveCaretRelatively((Editor)editor2, (int)1);
        return true;
    }

    public static void handleGenericLTDeletion(@NotNull Editor editor2, int offset2, @NotNull IElementType lt, @NotNull IElementType gt, @NotNull TokenSet invalidInsideReference) {
        if (editor2 == null) {
            TypedHandlerUtil.$$$reportNull$$$0(19);
        }
        if (lt == null) {
            TypedHandlerUtil.$$$reportNull$$$0(20);
        }
        if (gt == null) {
            TypedHandlerUtil.$$$reportNull$$$0(21);
        }
        if (invalidInsideReference == null) {
            TypedHandlerUtil.$$$reportNull$$$0(22);
        }
        if (TypedHandlerUtil.computeBracesBalance(editor2, offset2, lt, gt, invalidInsideReference, true) < 0) {
            editor2.getDocument().deleteString(offset2, offset2 + 1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 12: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lt";
                break;
            }
            case 2: 
            case 13: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gt";
                break;
            }
            case 3: 
            case 14: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalidInsideReference";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dot";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/TypedHandlerUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "computeBracesBalance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "incLookup";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isAfterClassLikeIdentifierOrDot";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isClassLikeIdentifier";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "handleAfterGenericLT";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "handleGenericGT";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "handleGenericLTDeletion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

