/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class UnSelectWordHandler
extends EditorActionHandler.ForEachCaret {
    private final EditorActionHandler myOriginalHandler;

    public UnSelectWordHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public void doExecute(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext2) {
        Project project2;
        if (editor2 == null) {
            UnSelectWordHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            UnSelectWordHandler.$$$reportNull$$$0(1);
        }
        if ((project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2)) == null) {
            return;
        }
        Document document = editor2.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(document);
        if (file2 == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor2, caret, dataContext2);
            }
            return;
        }
        PsiDocumentManager.getInstance(project2).commitDocument(document);
        UnSelectWordHandler.doAction(editor2, file2);
    }

    private static void doAction(final @NotNull Editor editor2, @NotNull PsiFile file2) {
        PsiElement anotherElement;
        PsiElement element;
        if (editor2 == null) {
            UnSelectWordHandler.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            UnSelectWordHandler.$$$reportNull$$$0(3);
        }
        if (!editor2.getSelectionModel().hasSelection()) {
            return;
        }
        CharSequence text2 = editor2.getDocument().getCharsSequence();
        int cursorOffset = editor2.getCaretModel().getOffset();
        if (cursorOffset > 0 && cursorOffset < text2.length() && !Character.isJavaIdentifierPart(text2.charAt(cursorOffset)) && Character.isJavaIdentifierPart(text2.charAt(cursorOffset - 1))) {
            --cursorOffset;
        }
        if ((element = file2.findElementAt(cursorOffset)) instanceof PsiWhiteSpace && cursorOffset > 0 && !((anotherElement = file2.findElementAt(cursorOffset - 1)) instanceof PsiWhiteSpace)) {
            element = anotherElement;
        }
        if (element instanceof PsiWhiteSpace) {
            PsiElement nextSibling = element.getNextSibling();
            if (nextSibling == null) {
                if ((element = element.getParent()) == null || element instanceof PsiFile) {
                    return;
                }
                nextSibling = element.getNextSibling();
                if (nextSibling == null) {
                    return;
                }
            }
            element = nextSibling;
            cursorOffset = element.getTextRange().getStartOffset();
        }
        final TextRange selectionRange = new TextRange(editor2.getSelectionModel().getSelectionStart(), editor2.getSelectionModel().getSelectionEnd());
        final Ref maximumRange = new Ref();
        final int finalCursorOffset = cursorOffset;
        SelectWordUtil.processRanges(element, text2, cursorOffset, editor2, (Processor<? super TextRange>)new Processor<TextRange>(){

            @Override
            public boolean process(TextRange range) {
                if (selectionRange.contains(range = this.expandToFoldingBoundaries(range)) && !range.equals(selectionRange) && (range.contains(finalCursorOffset) || finalCursorOffset == range.getEndOffset()) && (maximumRange.get() == null || range.contains((TextRange)maximumRange.get()))) {
                    maximumRange.set(range);
                }
                return false;
            }

            private TextRange expandToFoldingBoundaries(TextRange range) {
                int startOffset = range.getStartOffset();
                FoldRegion region = editor2.getFoldingModel().getCollapsedRegionAtOffset(startOffset);
                if (region != null) {
                    startOffset = region.getStartOffset();
                }
                int endOffset = range.getEndOffset();
                region = editor2.getFoldingModel().getCollapsedRegionAtOffset(endOffset);
                if (region != null && endOffset > region.getStartOffset()) {
                    endOffset = region.getEndOffset();
                }
                return new TextRange(startOffset, endOffset);
            }
        });
        TextRange range = (TextRange)maximumRange.get();
        if (range == null) {
            editor2.getSelectionModel().setSelection(cursorOffset, cursorOffset);
        } else {
            editor2.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/UnSelectWordHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

