/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.codeInsight.editorActions.enter.EnterInCommentUtil;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class EnterInBlockCommentHandler
extends EnterHandlerDelegateAdapter {
    private static final String WHITESPACE = " \t";

    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor2, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext2, EditorActionHandler originalHandler) {
        int refOffset;
        String linePrefix;
        int nonWsLineStart;
        int lineEndOffset;
        int lineStartOffset;
        int todoOffset;
        CodeDocumentationAwareCommenter commenter;
        if (file2 == null) {
            EnterInBlockCommentHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            EnterInBlockCommentHandler.$$$reportNull$$$0(1);
        }
        if (caretOffsetRef == null) {
            EnterInBlockCommentHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            EnterInBlockCommentHandler.$$$reportNull$$$0(3);
        }
        if (dataContext2 == null) {
            EnterInBlockCommentHandler.$$$reportNull$$$0(4);
        }
        if ((commenter = EnterInCommentUtil.getDocumentationAwareCommenter(dataContext2)) == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int caretOffset = caretOffsetRef.get();
        int blockCommentStartOffset = EnterInBlockCommentHandler.getBlockCommentStartOffset(editor2, caretOffset, commenter);
        if (blockCommentStartOffset < 0) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document = editor2.getDocument();
        CharSequence text2 = document.getImmutableCharSequence();
        String docCommentPrefix = commenter.getDocumentationCommentPrefix();
        if (docCommentPrefix != null && StringUtil.startsWith(text2.subSequence(blockCommentStartOffset, caretOffset), docCommentPrefix)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int beforeWhitespace = CharArrayUtil.shiftBackward(text2, blockCommentStartOffset - 1, WHITESPACE);
        if (beforeWhitespace > 0 && text2.charAt(beforeWhitespace) != '\n') {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiDocumentManager.getInstance(file2.getProject()).commitDocument(document);
        PsiElement element = file2.findElementAt(blockCommentStartOffset);
        if (!(element instanceof PsiComment) || ((PsiComment)element).getTokenType() != commenter.getBlockCommentTokenType()) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (!EnterHandler.isCommentComplete((PsiComment)element, commenter, editor2) && CodeInsightSettings.getInstance().CLOSE_COMMENT_ON_ENTER) {
            int currentEndOfLine = CharArrayUtil.shiftForwardUntil(text2, caretOffset, "\n");
            document.insertString(currentEndOfLine, "\n" + text2.subSequence(beforeWhitespace + 1, blockCommentStartOffset) + " " + commenter.getBlockCommentSuffix());
            return EnterHandlerDelegate.Result.Default;
        }
        int additionalIndent = 0;
        if (TodoConfiguration.getInstance().isMultiLine() && (todoOffset = EnterInCommentUtil.getTodoTextOffset(text2, lineStartOffset = DocumentUtil.getLineStartOffset(caretOffset, document), caretOffset)) >= 0 && todoOffset == EnterInCommentUtil.getTodoTextOffset(text2, lineStartOffset, lineEndOffset = DocumentUtil.getLineEndOffset(caretOffset, document)) && todoOffset >= (nonWsLineStart = CharArrayUtil.shiftForward(text2, lineStartOffset, WHITESPACE))) {
            additionalIndent = todoOffset - nonWsLineStart + 1;
            document.insertString(caretOffset, StringUtil.repeat(" ", additionalIndent));
        }
        if ((linePrefix = commenter.getDocumentationCommentLinePrefix()) == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int n = refOffset = document.getLineNumber(caretOffset) > document.getLineNumber(blockCommentStartOffset) ? document.getLineStartOffset(document.getLineNumber(blockCommentStartOffset) + 1) : caretOffset;
        if (StringUtil.startsWith(text2, CharArrayUtil.shiftForward(text2, refOffset, WHITESPACE), linePrefix)) {
            int endOffset = CharArrayUtil.shiftForward(text2, caretOffset, WHITESPACE);
            if (endOffset < text2.length() && text2.charAt(endOffset) != '\n') {
                endOffset = caretOffset;
            }
            int valueLength = linePrefix.length() + 1;
            int endOffsetToReplace = endOffset > caretOffset ? endOffset : caretOffset + Math.min(additionalIndent, valueLength);
            document.replaceString(caretOffset, endOffsetToReplace, linePrefix + " ");
            caretAdvance.set(Math.max(valueLength, additionalIndent));
            return EnterHandlerDelegate.Result.DefaultForceIndent;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static int getBlockCommentStartOffset(@NotNull Editor editor2, int offset2, @NotNull CodeDocumentationAwareCommenter commenter) {
        EditorHighlighter highlighter;
        HighlighterIterator iterator2;
        if (editor2 == null) {
            EnterInBlockCommentHandler.$$$reportNull$$$0(5);
        }
        if (commenter == null) {
            EnterInBlockCommentHandler.$$$reportNull$$$0(6);
        }
        if ((iterator2 = (highlighter = editor2.getHighlighter()).createIterator(offset2)).atEnd() || iterator2.getTokenType() != commenter.getBlockCommentTokenType()) {
            return -1;
        }
        String prefix = ObjectUtils.notNull(commenter.getBlockCommentPrefix(), "");
        int tokenStart = iterator2.getStart();
        int tokenEnd = iterator2.getEnd();
        int prefixEnd = tokenStart + prefix.length();
        if (prefixEnd > tokenEnd || prefixEnd > offset2) {
            return -1;
        }
        String suffix = ObjectUtils.notNull(commenter.getBlockCommentSuffix(), "");
        if (StringUtil.endsWith(editor2.getDocument().getImmutableCharSequence().subSequence(prefixEnd, tokenEnd), suffix) && offset2 > tokenEnd - suffix.length()) {
            return -1;
        }
        return tokenStart;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffsetRef";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commenter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/enter/EnterInBlockCommentHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessEnter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getBlockCommentStartOffset";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

