/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.codeInsight.editorActions.enter.EnterInCommentUtil;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class EnterInLineCommentHandler
extends EnterHandlerDelegateAdapter {
    private static final String WHITESPACE = " \t";

    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor2, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext2, EditorActionHandler originalHandler) {
        CodeDocumentationAwareCommenter commenter;
        if (file2 == null) {
            EnterInLineCommentHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            EnterInLineCommentHandler.$$$reportNull$$$0(1);
        }
        if (caretOffsetRef == null) {
            EnterInLineCommentHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            EnterInLineCommentHandler.$$$reportNull$$$0(3);
        }
        if (dataContext2 == null) {
            EnterInLineCommentHandler.$$$reportNull$$$0(4);
        }
        if ((commenter = EnterInCommentUtil.getDocumentationAwareCommenter(dataContext2)) == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int caretOffset = caretOffsetRef.get();
        int lineCommentStartOffset = EnterInLineCommentHandler.getLineCommentStartOffset(editor2, caretOffset, commenter);
        if (lineCommentStartOffset < 0) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document = editor2.getDocument();
        CharSequence text2 = document.getImmutableCharSequence();
        int offset2 = CharArrayUtil.shiftForward(text2, caretOffset, WHITESPACE);
        if (offset2 >= document.getTextLength() || text2.charAt(offset2) == '\n') {
            return EnterHandlerDelegate.Result.Continue;
        }
        String prefix = commenter.getLineCommentPrefix();
        assert (prefix != null) : "Line Comment type is set but Line Comment Prefix is null!";
        String prefixTrimmed = prefix.trim();
        int beforeCommentOffset = CharArrayUtil.shiftBackward(text2, lineCommentStartOffset - 1, WHITESPACE);
        boolean onlyCommentInCaretLine = beforeCommentOffset < 0 || text2.charAt(beforeCommentOffset) == '\n';
        Object spacing = " ";
        if (StringUtil.startsWith(text2, offset2, prefix)) {
            int afterPrefix = offset2 + prefixTrimmed.length();
            if (afterPrefix < document.getTextLength() && text2.charAt(afterPrefix) != ' ') {
                document.insertString(afterPrefix, (CharSequence)spacing);
            }
            caretOffsetRef.set(offset2);
        } else {
            if (onlyCommentInCaretLine) {
                int indentStart = lineCommentStartOffset + prefix.trim().length();
                int indentEnd = CharArrayUtil.shiftForward(text2, indentStart, WHITESPACE);
                CharSequence currentLineSpacing = text2.subSequence(indentStart, indentEnd);
                if (TodoConfiguration.getInstance().isMultiLine() && EnterInCommentUtil.isTodoText(text2, lineCommentStartOffset, caretOffset) && EnterInCommentUtil.isTodoText(text2, lineCommentStartOffset, DocumentUtil.getLineEndOffset(lineCommentStartOffset, document))) {
                    spacing = currentLineSpacing + " ";
                } else if (currentLineSpacing.length() > 0) {
                    spacing = currentLineSpacing;
                }
                int textStart = CharArrayUtil.shiftForward(text2, caretOffset, WHITESPACE);
                document.deleteString(caretOffset, textStart);
            } else if (text2.charAt(caretOffset) == ' ') {
                spacing = "";
            }
            document.insertString(caretOffset, prefixTrimmed + (CharSequence)spacing);
        }
        if (onlyCommentInCaretLine) {
            caretAdvance.set(prefixTrimmed.length() + spacing.length());
        }
        return EnterHandlerDelegate.Result.DefaultForceIndent;
    }

    private static int getLineCommentStartOffset(@NotNull Editor editor2, int offset2, @NotNull CodeDocumentationAwareCommenter commenter) {
        if (editor2 == null) {
            EnterInLineCommentHandler.$$$reportNull$$$0(5);
        }
        if (commenter == null) {
            EnterInLineCommentHandler.$$$reportNull$$$0(6);
        }
        if (offset2 < 1) {
            return -1;
        }
        EditorHighlighter highlighter = editor2.getHighlighter();
        HighlighterIterator iterator2 = highlighter.createIterator(offset2 - 1);
        String prefix = commenter.getLineCommentPrefix();
        return iterator2.getTokenType() == commenter.getLineCommentTokenType() && iterator2.getStart() + (prefix == null ? 0 : prefix.length()) <= offset2 ? iterator2.getStart() : -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffsetRef";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commenter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/enter/EnterInLineCommentHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessEnter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineCommentStartOffset";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

