/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.fillParagraph;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.FormatterTagHandler;
import com.intellij.formatting.LineWrappingUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParagraphFillHandler {
    protected void performOnElement(@NotNull PsiElement element, @NotNull Editor editor2) {
        if (element == null) {
            ParagraphFillHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            ParagraphFillHandler.$$$reportNull$$$0(1);
        }
        Document document = editor2.getDocument();
        TextRange textRange = this.getTextRange(element, editor2);
        if (textRange.isEmpty()) {
            return;
        }
        String text2 = textRange.substring(element.getContainingFile().getText());
        List<String> subStrings = StringUtil.split(text2, "\n", true);
        String prefix = this.getPrefix(element);
        String postfix = this.getPostfix(element);
        StringBuilder stringBuilder = new StringBuilder();
        this.appendPrefix(element, text2, stringBuilder);
        stringBuilder.append(subStrings.stream().map(string2 -> StringUtil.trimStart(string2.trim(), prefix.trim())).map(string2 -> StringUtil.trimEnd(string2, postfix.trim())).map(String::trim).filter(finalString -> !StringUtil.isEmptyOrSpaces(finalString)).collect(Collectors.joining(" ")));
        this.appendPostfix(element, text2, stringBuilder);
        String replacementText = stringBuilder.toString();
        CommandProcessor.getInstance().executeCommand(element.getProject(), () -> {
            document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), replacementText);
            PsiFile file2 = element.getContainingFile();
            FormatterTagHandler formatterTagHandler = new FormatterTagHandler(CodeStyle.getSettings((PsiFile)file2));
            List enabledRanges = formatterTagHandler.getEnabledRanges((ASTNode)file2.getNode(), TextRange.create(0, document.getTextLength()));
            LineWrappingUtil.doWrapLongLinesIfNecessary((Editor)editor2, (Project)element.getProject(), (Document)document, (int)textRange.getStartOffset(), (int)(textRange.getStartOffset() + replacementText.length() + 1), (List)enabledRanges, (int)CodeStyle.getSettings((PsiFile)file2).getRightMargin(element.getLanguage()));
        }, null, document);
    }

    protected void appendPostfix(@NotNull PsiElement element, @NotNull String text2, @NotNull StringBuilder stringBuilder) {
        String postfix;
        if (element == null) {
            ParagraphFillHandler.$$$reportNull$$$0(2);
        }
        if (text2 == null) {
            ParagraphFillHandler.$$$reportNull$$$0(3);
        }
        if (stringBuilder == null) {
            ParagraphFillHandler.$$$reportNull$$$0(4);
        }
        if (text2.endsWith((postfix = this.getPostfix(element)).trim())) {
            stringBuilder.append(postfix);
        }
    }

    protected void appendPrefix(@NotNull PsiElement element, @NotNull String text2, @NotNull StringBuilder stringBuilder) {
        String prefix;
        if (element == null) {
            ParagraphFillHandler.$$$reportNull$$$0(5);
        }
        if (text2 == null) {
            ParagraphFillHandler.$$$reportNull$$$0(6);
        }
        if (stringBuilder == null) {
            ParagraphFillHandler.$$$reportNull$$$0(7);
        }
        if (text2.startsWith((prefix = this.getPrefix(element)).trim())) {
            stringBuilder.append(prefix);
        }
    }

    private TextRange getTextRange(@NotNull PsiElement element, @NotNull Editor editor2) {
        if (element == null) {
            ParagraphFillHandler.$$$reportNull$$$0(8);
        }
        if (editor2 == null) {
            ParagraphFillHandler.$$$reportNull$$$0(9);
        }
        int startOffset = this.getStartOffset(element, editor2);
        int endOffset = this.getEndOffset(element, editor2);
        return new UnfairTextRange(startOffset, endOffset);
    }

    private int getStartOffset(@NotNull PsiElement element, @NotNull Editor editor2) {
        int lineNumber;
        if (element == null) {
            ParagraphFillHandler.$$$reportNull$$$0(10);
        }
        if (editor2 == null) {
            ParagraphFillHandler.$$$reportNull$$$0(11);
        }
        if (this.isBunchOfElement(element)) {
            PsiElement firstElement = this.getFirstElement(element);
            return firstElement.getTextRange().getStartOffset();
        }
        int offset2 = editor2.getCaretModel().getOffset();
        int elementTextOffset = element.getTextOffset();
        Document document = editor2.getDocument();
        for (lineNumber = document.getLineNumber(offset2); lineNumber != document.getLineNumber(elementTextOffset); --lineNumber) {
            String text2 = document.getText(TextRange.create(document.getLineStartOffset(lineNumber), document.getLineEndOffset(lineNumber)));
            if (!StringUtil.isEmptyOrSpaces(text2)) continue;
            ++lineNumber;
            break;
        }
        int lineStartOffset = lineNumber == document.getLineNumber(elementTextOffset) ? elementTextOffset : document.getLineStartOffset(lineNumber);
        String lineText = document.getText(TextRange.create(lineStartOffset, document.getLineEndOffset(lineNumber)));
        int shift = StringUtil.findFirst(lineText, CharFilter.NOT_WHITESPACE_FILTER);
        return lineStartOffset + shift;
    }

    protected boolean isBunchOfElement(PsiElement element) {
        return element instanceof PsiComment;
    }

    private int getEndOffset(@NotNull PsiElement element, @NotNull Editor editor2) {
        int lineNumber;
        if (element == null) {
            ParagraphFillHandler.$$$reportNull$$$0(12);
        }
        if (editor2 == null) {
            ParagraphFillHandler.$$$reportNull$$$0(13);
        }
        if (this.isBunchOfElement(element)) {
            PsiElement next2 = this.getLastElement(element);
            return next2.getTextRange().getEndOffset();
        }
        int offset2 = editor2.getCaretModel().getOffset();
        int elementTextOffset = element.getTextRange().getEndOffset();
        Document document = editor2.getDocument();
        for (lineNumber = document.getLineNumber(offset2); lineNumber != document.getLineNumber(elementTextOffset); ++lineNumber) {
            String text2 = document.getText(TextRange.create(document.getLineStartOffset(lineNumber), document.getLineEndOffset(lineNumber)));
            if (!StringUtil.isEmptyOrSpaces(text2)) continue;
            --lineNumber;
            break;
        }
        return document.getLineEndOffset(lineNumber);
    }

    @NotNull
    private PsiElement getFirstElement(@NotNull PsiElement element) {
        if (element == null) {
            ParagraphFillHandler.$$$reportNull$$$0(14);
        }
        IElementType elementType = element.getNode().getElementType();
        PsiElement result2 = element;
        for (PsiElement prevSibling = element.getPrevSibling(); prevSibling != null && (prevSibling.getNode().getElementType().equals(elementType) || this.atWhitespaceToken(prevSibling) && StringUtil.countChars(prevSibling.getText(), '\n') <= 1); prevSibling = prevSibling.getPrevSibling()) {
            String text2 = prevSibling.getText();
            String prefix = this.getPrefix(element);
            String postfix = this.getPostfix(element);
            text2 = StringUtil.trimStart(text2.trim(), prefix.trim());
            text2 = StringUtil.trimEnd(text2, postfix);
            if (prevSibling.getNode().getElementType().equals(elementType) && StringUtil.isEmptyOrSpaces(text2)) break;
            if (!prevSibling.getNode().getElementType().equals(elementType)) continue;
            result2 = prevSibling;
        }
        PsiElement psiElement = result2;
        if (psiElement == null) {
            ParagraphFillHandler.$$$reportNull$$$0(15);
        }
        return psiElement;
    }

    @NotNull
    private PsiElement getLastElement(@NotNull PsiElement element) {
        if (element == null) {
            ParagraphFillHandler.$$$reportNull$$$0(16);
        }
        IElementType elementType = element.getNode().getElementType();
        PsiElement result2 = element;
        for (PsiElement nextSibling = element.getNextSibling(); nextSibling != null && (nextSibling.getNode().getElementType().equals(elementType) || this.atWhitespaceToken(nextSibling) && StringUtil.countChars(nextSibling.getText(), '\n') <= 1); nextSibling = nextSibling.getNextSibling()) {
            String text2 = nextSibling.getText();
            String prefix = this.getPrefix(element);
            String postfix = this.getPostfix(element);
            text2 = StringUtil.trimStart(text2.trim(), prefix.trim());
            text2 = StringUtil.trimEnd(text2, postfix);
            if (nextSibling.getNode().getElementType().equals(elementType) && StringUtil.isEmptyOrSpaces(text2)) break;
            if (!nextSibling.getNode().getElementType().equals(elementType)) continue;
            result2 = nextSibling;
        }
        PsiElement psiElement = result2;
        if (psiElement == null) {
            ParagraphFillHandler.$$$reportNull$$$0(17);
        }
        return psiElement;
    }

    protected boolean atWhitespaceToken(@Nullable PsiElement element) {
        return element instanceof PsiWhiteSpace;
    }

    protected boolean isAvailableForElement(@Nullable PsiElement element) {
        return element != null;
    }

    protected boolean isAvailableForFile(@Nullable PsiFile psiFile) {
        return psiFile instanceof PsiPlainTextFile;
    }

    @NotNull
    protected String getPrefix(@NotNull PsiElement element) {
        if (element == null) {
            ParagraphFillHandler.$$$reportNull$$$0(18);
        }
        return "";
    }

    @NotNull
    protected String getPostfix(@NotNull PsiElement element) {
        if (element == null) {
            ParagraphFillHandler.$$$reportNull$$$0(19);
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringBuilder";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/fillParagraph/ParagraphFillHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/fillParagraph/ParagraphFillHandler";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstElement";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "performOnElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendPostfix";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendPrefix";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTextRange";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getStartOffset";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getEndOffset";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFirstElement";
                break;
            }
            case 15: 
            case 17: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLastElement";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPrefix";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPostfix";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 15, 17 -> new IllegalStateException(string2);
        };
    }
}

