/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.moveLeftRight;

import com.intellij.codeInsight.editorActions.moveLeftRight.MoveElementLeftRightHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Range;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveElementLeftRightActionHandler
extends EditorWriteActionHandler.ForEachCaret {
    private static final Comparator<PsiElement> BY_OFFSET = Comparator.comparingInt(PsiElement::getTextOffset);
    private static final Set<String> OUR_ACTIONS = ContainerUtil.set("MoveElementLeft", "MoveElementRight");
    private final boolean myIsLeft;

    public MoveElementLeftRightActionHandler(boolean isLeft) {
        this.myIsLeft = isLeft;
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext2) {
        Project project2;
        if (editor2 == null) {
            MoveElementLeftRightActionHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            MoveElementLeftRightActionHandler.$$$reportNull$$$0(1);
        }
        if ((project2 = editor2.getProject()) == null) {
            return false;
        }
        Document document = editor2.getDocument();
        if (!(document instanceof DocumentEx)) {
            return false;
        }
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(document);
        if (file2 == null) {
            return false;
        }
        PsiElement[] elementList = MoveElementLeftRightActionHandler.getElementList(file2, caret.getSelectionStart(), caret.getSelectionEnd());
        return elementList != null;
    }

    private static PsiElement @Nullable [] getElementList(@NotNull PsiFile file2, int rangeStart, int rangeEnd) {
        PsiElement startElement;
        if (file2 == null) {
            MoveElementLeftRightActionHandler.$$$reportNull$$$0(2);
        }
        if ((startElement = file2.findElementAt(rangeStart)) == null) {
            return null;
        }
        if (rangeEnd > rangeStart) {
            PsiElement endElement = file2.findElementAt(rangeEnd - 1);
            if (endElement == null) {
                return null;
            }
            PsiElement element = PsiTreeUtil.findCommonParent(startElement, endElement);
            return MoveElementLeftRightActionHandler.getElementList(element, rangeStart, rangeEnd);
        }
        PsiElement[] list2 = MoveElementLeftRightActionHandler.getElementList(startElement, rangeStart, rangeStart);
        if (list2 != null || rangeStart <= 0) {
            return list2;
        }
        startElement = file2.findElementAt(rangeStart - 1);
        if (startElement == null) {
            return null;
        }
        return MoveElementLeftRightActionHandler.getElementList(startElement, rangeStart, rangeStart);
    }

    private static PsiElement @Nullable [] getElementList(PsiElement element, int rangeStart, int rangeEnd) {
        while (element != null) {
            List<MoveElementLeftRightHandler> handlers2 = MoveElementLeftRightHandler.EXTENSION.allForLanguageOrAny(element.getLanguage());
            for (MoveElementLeftRightHandler handler2 : handlers2) {
                PsiElement[] elementList = handler2.getMovableSubElements(element);
                if (elementList.length <= 1) continue;
                PsiElement[] elements = (PsiElement[])elementList.clone();
                Arrays.sort(elements, BY_OFFSET);
                PsiElement first2 = elements[0];
                PsiElement last2 = elements[elements.length - 1];
                if (rangeStart < first2.getTextRange().getStartOffset() || rangeEnd > last2.getTextRange().getEndOffset() || rangeStart < first2.getTextRange().getEndOffset() && rangeEnd > last2.getTextRange().getStartOffset()) continue;
                return elements;
            }
            element = element.getParent();
        }
        return null;
    }

    public void executeWriteAction(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext2) {
        int caretShift;
        if (editor2 == null) {
            MoveElementLeftRightActionHandler.$$$reportNull$$$0(3);
        }
        if (caret == null) {
            MoveElementLeftRightActionHandler.$$$reportNull$$$0(4);
        }
        DocumentEx document = (DocumentEx)editor2.getDocument();
        Project project2 = editor2.getProject();
        assert (project2 != null);
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance(project2);
        PsiFile file2 = psiDocumentManager.getPsiFile(document);
        assert (file2 != null);
        int selectionStart = caret.getSelectionStart();
        int selectionEnd = caret.getSelectionEnd();
        assert (selectionStart <= selectionEnd);
        PsiElement[] elementList = MoveElementLeftRightActionHandler.getElementList(file2, selectionStart, selectionEnd);
        assert (elementList != null);
        Range<Integer> elementRange = this.findRangeOfElementsToMove(elementList, selectionStart, selectionEnd);
        if (elementRange == null) {
            return;
        }
        int toMoveStart = elementList[elementRange.getFrom()].getTextRange().getStartOffset();
        int toMoveEnd = elementList[elementRange.getTo()].getTextRange().getEndOffset();
        int otherIndex = this.myIsLeft ? elementRange.getFrom() - 1 : elementRange.getTo() + 1;
        int otherStart = elementList[otherIndex].getTextRange().getStartOffset();
        int otherEnd = elementList[otherIndex].getTextRange().getEndOffset();
        selectionStart = MoveElementLeftRightActionHandler.trim(selectionStart, toMoveStart, toMoveEnd);
        selectionEnd = MoveElementLeftRightActionHandler.trim(selectionEnd, toMoveStart, toMoveEnd);
        int caretOffset = MoveElementLeftRightActionHandler.trim(caret.getOffset(), toMoveStart, toMoveEnd);
        if (toMoveStart < otherStart) {
            document.moveText(toMoveStart, toMoveEnd, otherStart);
            document.moveText(otherStart, otherEnd, toMoveStart);
            caretShift = otherEnd - toMoveEnd;
        } else {
            document.moveText(otherStart, otherEnd, toMoveStart);
            document.moveText(toMoveStart, toMoveEnd, otherStart);
            caretShift = otherStart - toMoveStart;
        }
        caret.moveToOffset(caretOffset + caretShift);
        caret.setSelection(selectionStart + caretShift, selectionEnd + caretShift);
    }

    @Nullable
    private Range<Integer> findRangeOfElementsToMove(PsiElement @NotNull [] elements, int startOffset, int endOffset) {
        if (elements == null) {
            MoveElementLeftRightActionHandler.$$$reportNull$$$0(5);
        }
        int startIndex = elements.length;
        int endIndex = -1;
        if (startOffset == endOffset) {
            for (int i2 = 0; i2 < elements.length; ++i2) {
                if (!elements[i2].getTextRange().containsOffset(startOffset)) continue;
                startIndex = endIndex = i2;
                break;
            }
        } else {
            int i3 = 0;
            while (i3 < elements.length) {
                PsiElement psiElement = elements[i3];
                TextRange range = psiElement.getTextRange();
                if (i3 < startIndex && startOffset < range.getEndOffset()) {
                    startIndex = i3;
                }
                if (endOffset > range.getStartOffset()) {
                    endIndex = i3++;
                    continue;
                }
                break;
            }
        }
        return startIndex > endIndex || (this.myIsLeft ? startIndex == 0 : endIndex == elements.length - 1) ? null : new Range<Integer>(startIndex, endIndex);
    }

    private static int trim(int offset2, int rangeStart, int rangeEnd) {
        return Math.max(rangeStart, Math.min(rangeEnd, offset2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/moveLeftRight/MoveElementLeftRightActionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForCaret";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementList";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "executeWriteAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findRangeOfElementsToMove";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

