/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.moveUpDown;

import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.MoverWrapper;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseMoveHandler
extends EditorWriteActionHandler.ForEachCaret {
    protected final boolean isDown;

    public BaseMoveHandler(boolean down) {
        this.isDown = down;
    }

    public void executeWriteAction(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext2) {
        if (editor2 == null) {
            BaseMoveHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            BaseMoveHandler.$$$reportNull$$$0(1);
        }
        Project project2 = editor2.getProject();
        assert (project2 != null);
        Document document = editor2.getDocument();
        PsiFile file2 = this.getPsiFile(project2, editor2);
        MoverWrapper mover = this.getSuitableMover(editor2, file2);
        if (mover != null && mover.getInfo().toMove2 != null) {
            LineRange range = mover.getInfo().toMove;
            if (!(range.startLine <= 0 && !this.isDown || range.endLine >= document.getLineCount() && this.isDown)) {
                mover.move(editor2, file2);
            }
        }
    }

    public boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext2) {
        if (editor2 == null) {
            BaseMoveHandler.$$$reportNull$$$0(2);
        }
        if (caret == null) {
            BaseMoveHandler.$$$reportNull$$$0(3);
        }
        if (editor2.isViewer() || editor2.isOneLineMode()) {
            return false;
        }
        Project project2 = editor2.getProject();
        return project2 != null && !project2.isDisposed();
    }

    @Nullable
    protected abstract PsiFile getPsiFile(@NotNull Project var1, @NotNull Editor var2);

    @Nullable
    protected abstract MoverWrapper getSuitableMover(@NotNull Editor var1, @Nullable PsiFile var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/moveUpDown/BaseMoveHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "executeWriteAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForCaret";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

