/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.moveUpDown;

import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StatementUpDownMover {
    public static final ExtensionPointName<StatementUpDownMover> STATEMENT_UP_DOWN_MOVER_EP = ExtensionPointName.create("com.intellij.statementUpDownMover");

    public abstract boolean checkAvailable(@NotNull Editor var1, @NotNull PsiFile var2, @NotNull MoveInfo var3, boolean var4);

    public void beforeMove(@NotNull Editor editor2, @NotNull MoveInfo info2, boolean down) {
        if (editor2 == null) {
            StatementUpDownMover.$$$reportNull$$$0(0);
        }
        if (info2 == null) {
            StatementUpDownMover.$$$reportNull$$$0(1);
        }
    }

    public void afterMove(@NotNull Editor editor2, @NotNull PsiFile file2, @NotNull MoveInfo info2, boolean down) {
        if (editor2 == null) {
            StatementUpDownMover.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            StatementUpDownMover.$$$reportNull$$$0(3);
        }
        if (info2 == null) {
            StatementUpDownMover.$$$reportNull$$$0(4);
        }
    }

    public static int getLineStartSafeOffset(@NotNull Document document, int line) {
        if (document == null) {
            StatementUpDownMover.$$$reportNull$$$0(5);
        }
        return line == document.getLineCount() ? document.getTextLength() : document.getLineStartOffset(line);
    }

    @NotNull
    protected static LineRange getLineRangeFromSelection(@NotNull Editor editor2) {
        LineRange range;
        SelectionModel selectionModel;
        if (editor2 == null) {
            StatementUpDownMover.$$$reportNull$$$0(6);
        }
        if ((selectionModel = editor2.getSelectionModel()).hasSelection()) {
            int startLine = editor2.offsetToLogicalPosition((int)selectionModel.getSelectionStart()).line;
            LogicalPosition endPos = editor2.offsetToLogicalPosition(selectionModel.getSelectionEnd());
            int endLine = endPos.column == 0 ? endPos.line : endPos.line + 1;
            range = new LineRange(startLine, endLine);
        } else {
            int startLine = editor2.getCaretModel().getLogicalPosition().line;
            int endLine = startLine + 1;
            range = new LineRange(startLine, endLine);
        }
        LineRange lineRange = range;
        if (lineRange == null) {
            StatementUpDownMover.$$$reportNull$$$0(7);
        }
        return lineRange;
    }

    @Nullable
    protected static Pair<PsiElement, PsiElement> getElementRange(@NotNull Editor editor2, @NotNull PsiFile file2, @NotNull LineRange range) {
        int startOffset;
        PsiElement startingElement;
        if (editor2 == null) {
            StatementUpDownMover.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            StatementUpDownMover.$$$reportNull$$$0(9);
        }
        if (range == null) {
            StatementUpDownMover.$$$reportNull$$$0(10);
        }
        if ((startingElement = StatementUpDownMover.firstNonWhiteElement(startOffset = editor2.logicalPositionToOffset(new LogicalPosition(range.startLine, 0)), file2, true)) == null) {
            return null;
        }
        int endOffset = editor2.logicalPositionToOffset(new LogicalPosition(range.endLine, 0)) - 1;
        PsiElement endingElement = StatementUpDownMover.firstNonWhiteElement(endOffset, file2, false);
        if (endingElement == null) {
            return null;
        }
        if (PsiTreeUtil.isAncestor(startingElement, endingElement, false) || startingElement.getTextRange().getEndOffset() <= endingElement.getTextRange().getStartOffset()) {
            return Pair.create(startingElement, endingElement);
        }
        if (PsiTreeUtil.isAncestor(endingElement, startingElement, false)) {
            return Pair.create(startingElement, endingElement);
        }
        return null;
    }

    @Nullable
    protected static PsiElement firstNonWhiteElement(int offset2, @NotNull PsiFile file2, boolean lookRight) {
        ASTNode leafElement;
        if (file2 == null) {
            StatementUpDownMover.$$$reportNull$$$0(11);
        }
        return (leafElement = file2.getNode().findLeafElementAt(offset2)) == null ? null : StatementUpDownMover.firstNonWhiteElement(leafElement.getPsi(), lookRight);
    }

    @Nullable
    protected static PsiElement firstNonWhiteElement(PsiElement element, boolean lookRight) {
        if (element instanceof PsiWhiteSpace) {
            element = lookRight ? element.getNextSibling() : element.getPrevSibling();
        }
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/moveUpDown/StatementUpDownMover";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/moveUpDown/StatementUpDownMover";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineRangeFromSelection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeMove";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "afterMove";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLineStartSafeOffset";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLineRangeFromSelection";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getElementRange";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "firstNonWhiteElement";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7 -> new IllegalStateException(string2);
        };
    }

    public static class MoveInfo
    extends UserDataHolderBase {
        public LineRange toMove;
        public LineRange toMove2;
        public RangeMarker range1;
        public RangeMarker range2;
        public boolean indentSource;
        public boolean indentTarget = true;

        public final boolean prohibitMove() {
            this.toMove2 = null;
            return true;
        }
    }
}

