/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SmartEnterProcessor {
    public abstract boolean process(@NotNull Project var1, @NotNull Editor var2, @NotNull PsiFile var3);

    public boolean processAfterCompletion(@NotNull Editor editor2, @NotNull PsiFile psiFile) {
        if (editor2 == null) {
            SmartEnterProcessor.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            SmartEnterProcessor.$$$reportNull$$$0(1);
        }
        return this.process(psiFile.getProject(), editor2, psiFile);
    }

    protected void reformat(PsiElement atCaret) throws IncorrectOperationException {
        TextRange range = atCaret.getTextRange();
        PsiFile file2 = atCaret.getContainingFile();
        PsiFile baseFile = file2.getViewProvider().getPsi(file2.getViewProvider().getBaseLanguage());
        CodeStyleManager.getInstance(atCaret.getProject()).reformatText(baseFile, range.getStartOffset(), range.getEndOffset());
    }

    protected RangeMarker createRangeMarker(PsiElement elt) {
        PsiFile psiFile = elt.getContainingFile();
        PsiDocumentManager instance2 = PsiDocumentManager.getInstance(elt.getProject());
        Document document = instance2.getDocument(psiFile);
        return document.createRangeMarker(elt.getTextRange());
    }

    @Nullable
    protected PsiElement getStatementAtCaret(Editor editor2, PsiFile psiFile) {
        int offset2;
        int caret = editor2.getCaretModel().getOffset();
        Document doc = editor2.getDocument();
        CharSequence chars = doc.getCharsSequence();
        int n = offset2 = caret == 0 ? 0 : CharArrayUtil.shiftBackward(chars, caret - 1, " \t");
        if (offset2 < 0) {
            offset2 = 0;
        }
        if (doc.getLineNumber(offset2) < doc.getLineNumber(caret)) {
            offset2 = CharArrayUtil.shiftForward(chars, caret, " \t");
        }
        return psiFile.findElementAt(offset2);
    }

    protected static boolean isUncommited(@NotNull Project project2) {
        if (project2 == null) {
            SmartEnterProcessor.$$$reportNull$$$0(2);
        }
        return PsiDocumentManager.getInstance(project2).hasUncommitedDocuments();
    }

    public void commit(@NotNull Editor editor2) {
        if (editor2 == null) {
            SmartEnterProcessor.$$$reportNull$$$0(3);
        }
        SmartEnterProcessor.commitDocument(editor2);
    }

    public static void commitDocument(@NotNull Editor editor2) {
        if (editor2 == null) {
            SmartEnterProcessor.$$$reportNull$$$0(4);
        }
        Project project2 = editor2.getProject();
        PsiDocumentManager.getInstance(project2).commitDocument(editor2.getDocument());
        PsiDocumentManager.getInstance(project2).doPostponedOperationsAndUnblockDocument(editor2.getDocument());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/smartEnter/SmartEnterProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processAfterCompletion";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isUncommited";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "commit";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "commitDocument";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

