/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.completion.SkipAutopopupInStrings;
import com.intellij.codeInsight.editorActions.wordSelection.AbstractWordSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralValue;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.IntStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class InjectedFileReferenceSelectioner
extends AbstractWordSelectioner {
    @Override
    public boolean canSelect(@NotNull PsiElement e) {
        if (e == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(0);
        }
        return PsiTreeUtil.getParentOfType(e, PsiLanguageInjectionHost.class) != null;
    }

    @Override
    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor2) {
        BitSet compositeIndexes;
        BitSet charEscapeLocations;
        PsiLanguageInjectionHost host;
        if (e == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(3);
        }
        if ((host = PsiTreeUtil.getParentOfType(e, PsiLanguageInjectionHost.class)) == null) {
            return Collections.emptyList();
        }
        TextRange realRange = ElementManipulators.getValueTextRange(host).shiftRight(host.getTextRange().getStartOffset());
        if (!realRange.contains(cursorOffset)) {
            return Collections.emptyList();
        }
        PsiElement valueElement = InjectedFileReferenceSelectioner.findValueElement(host, realRange);
        TextRange elementRange = e.getTextRange();
        if (!valueElement.equals(e) && ContainerUtil.find(valueElement.getChildren(), el -> elementRange.contains(el.getTextRange())) == null) {
            return Collections.emptyList();
        }
        List<TextRange> segments = InjectedFileReferenceSelectioner.buildSegments(editorText, cursorOffset, realRange = InjectedFileReferenceSelectioner.limitToCurrentLineAndStripWhiteSpace(editorText, cursorOffset, realRange), charEscapeLocations = InjectedFileReferenceSelectioner.isWithinLiteral(e, host) ? InjectedFileReferenceSelectioner.findCharEscapeLocations(editor2, editorText, host.getTextRange(), realRange.getStartOffset()) : new BitSet(0), compositeIndexes = InjectedFileReferenceSelectioner.createCompositeIndexesSet(valueElement, realRange.getStartOffset()));
        if (!segments.isEmpty()) {
            int endOffsetAlignment = segments.get(segments.size() - 1).getEndOffset();
            ListIterator<TextRange> it = segments.listIterator();
            while (it.hasNext()) {
                TextRange r = it.next();
                if (r.getEndOffset() > cursorOffset) continue;
                it.set(TextRange.create(r.getStartOffset(), endOffsetAlignment));
            }
            segments.add(realRange);
        }
        return segments;
    }

    @NotNull
    private static PsiElement findValueElement(@NotNull PsiElement host, @NotNull TextRange valueRange) {
        if (host == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(4);
        }
        if (valueRange == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(5);
        }
        PsiElement psiElement = ObjectUtils.notNull(PsiTreeUtil.findFirstParent(host.getContainingFile().findElementAt(valueRange.getStartOffset()), false, parent2 -> parent2 == host || parent2.getTextRange().contains(valueRange)), host);
        if (psiElement == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    @NotNull
    private static List<TextRange> buildSegments(@NotNull CharSequence editorText, int cursorOffset, @NotNull TextRange range, @NotNull BitSet charEscapeLocations, @NotNull BitSet compositeIndexes) {
        if (editorText == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(7);
        }
        if (range == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(8);
        }
        if (charEscapeLocations == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(9);
        }
        if (compositeIndexes == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(10);
        }
        if (range.getLength() == 0) {
            List<TextRange> list2 = Collections.emptyList();
            if (list2 == null) {
                InjectedFileReferenceSelectioner.$$$reportNull$$$0(11);
            }
            return list2;
        }
        int hostTextOffset = range.getStartOffset();
        int hostTextEndOffset = range.getEndOffset();
        ArrayList<TextRange> segments = new ArrayList<TextRange>();
        int rangeStart = hostTextOffset;
        boolean segmentsFinished = false;
        int hardSegmentCount = 0;
        for (int i2 = hostTextOffset; i2 < hostTextEndOffset; ++i2) {
            if (compositeIndexes.get(i2 - hostTextOffset)) continue;
            char ch = editorText.charAt(i2);
            if (!segmentsFinished) {
                if (ch == '/' || ch == '\\' && !charEscapeLocations.get(i2 - hostTextOffset) || ch == ' ' && i2 <= cursorOffset) {
                    if (rangeStart < i2) {
                        if (editorText.charAt(i2 - 1) == ':') {
                            segments.add(new TextRange(rangeStart, i2 - 1));
                        } else {
                            segments.add(new TextRange(rangeStart, i2));
                        }
                        if (i2 > cursorOffset) {
                            segmentsFinished = true;
                        }
                    }
                    rangeStart = i2 + 1;
                    if (ch != ' ') {
                        ++hardSegmentCount;
                    }
                } else if (ch == '?') {
                    segments.add(new TextRange(rangeStart, i2));
                    if (i2 + 1 < hostTextEndOffset) {
                        segments.add(new TextRange(i2 + 1, hostTextEndOffset));
                    }
                    segments.add(new TextRange(rangeStart, hostTextEndOffset));
                    segmentsFinished = true;
                }
            }
            if ((ch != '>' || i2 <= hostTextOffset || editorText.charAt(i2 - 1) != '/') && (ch != '<' || i2 + 1 >= hostTextEndOffset || editorText.charAt(i2 + 1) != '/')) continue;
            List<TextRange> list3 = Collections.emptyList();
            if (list3 == null) {
                InjectedFileReferenceSelectioner.$$$reportNull$$$0(12);
            }
            return list3;
        }
        if (hardSegmentCount <= 0) {
            List<TextRange> list4 = Collections.emptyList();
            if (list4 == null) {
                InjectedFileReferenceSelectioner.$$$reportNull$$$0(13);
            }
            return list4;
        }
        if (!segmentsFinished && rangeStart < hostTextEndOffset) {
            segments.add(new TextRange(rangeStart, hostTextEndOffset));
        }
        ArrayList<TextRange> arrayList = segments;
        if (arrayList == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    private static BitSet createCompositeIndexesSet(@NotNull PsiElement valueElement, int indexesOffset) {
        if (valueElement == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(15);
        }
        BitSet bitSet = ((StreamEx)StreamEx.of((Object[])valueElement.getChildren()).filter(child -> !(child instanceof LeafPsiElement))).map(PsiElement::getTextRange).flatMapToInt(range -> IntStream.range(range.getStartOffset(), range.getEndOffset())).map(index2 -> index2 - indexesOffset).atLeast(0).toBitSet();
        if (bitSet == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(16);
        }
        return bitSet;
    }

    @NotNull
    private static TextRange limitToCurrentLineAndStripWhiteSpace(@NotNull CharSequence text2, int cursor, @NotNull TextRange range) {
        if (text2 == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(17);
        }
        if (range == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(18);
        }
        int subsequenceOffset = range.getStartOffset();
        CharSequenceSubSequence rangeText = new CharSequenceSubSequence(text2, subsequenceOffset, range.getEndOffset());
        int start = CharArrayUtil.shiftBackwardUntil(rangeText, cursor - subsequenceOffset, "\n\r") + 1;
        int end = CharArrayUtil.shiftForwardUntil(rangeText, cursor - subsequenceOffset, "\n\r");
        start = CharArrayUtil.shiftForward(rangeText, start, cursor - subsequenceOffset, " \t");
        end = CharArrayUtil.shiftBackward(rangeText, cursor - subsequenceOffset, end - 1, " \t") + 1;
        return new TextRange(subsequenceOffset + start, subsequenceOffset + end);
    }

    private static boolean isWithinLiteral(@NotNull PsiElement e, PsiElement host) {
        if (e == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(19);
        }
        return host instanceof PsiLiteralValue || SkipAutopopupInStrings.isInStringLiteral(e);
    }

    private static BitSet findCharEscapeLocations(@NotNull Editor editor2, @NotNull CharSequence text2, @NotNull TextRange range, int indexesOffset) {
        int pos;
        if (editor2 == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(20);
        }
        if (text2 == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(21);
        }
        if (range == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(22);
        }
        HighlighterIterator iterator2 = editor2.getHighlighter().createIterator(range.getStartOffset());
        int rangeEnd = range.getEndOffset();
        BitSet locations = new BitSet(range.getLength());
        while (!iterator2.atEnd() && (pos = iterator2.getStart()) < rangeEnd) {
            if (text2.charAt(pos) == '\\' && (pos + 1 >= rangeEnd || text2.charAt(pos + 1) != '\\') && pos >= indexesOffset) {
                locations.set(pos - indexesOffset);
            }
            iterator2.advance();
        }
        return locations;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 11, 12, 13, 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 3: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueRange";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/wordSelection/InjectedFileReferenceSelectioner";
                break;
            }
            case 8: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charEscapeLocations";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compositeIndexes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueElement";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/wordSelection/InjectedFileReferenceSelectioner";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findValueElement";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSegments";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompositeIndexesSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canSelect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findValueElement";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildSegments";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createCompositeIndexesSet";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "limitToCurrentLineAndStripWhiteSpace";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isWithinLiteral";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findCharEscapeLocations";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 11, 12, 13, 14, 16 -> new IllegalStateException(string2);
        };
    }
}

