/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class CollapseSelectionHandler
implements CodeInsightActionHandler {
    private static final String ourPlaceHolderText = "...";
    private static final Logger LOG = Logger.getInstance(CollapseSelectionHandler.class);

    @Override
    public void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (project2 == null) {
            CollapseSelectionHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            CollapseSelectionHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            CollapseSelectionHandler.$$$reportNull$$$0(2);
        }
        editor2.getFoldingModel().runBatchFoldingOperation(() -> {
            int end;
            EditorFoldingInfo info2 = EditorFoldingInfo.get(editor2);
            FoldingModelEx foldingModel = (FoldingModelEx)editor2.getFoldingModel();
            int start = editor2.getSelectionModel().getSelectionStart();
            if (start < (end = editor2.getSelectionModel().getSelectionEnd())) {
                FoldRegion region;
                Document doc = editor2.getDocument();
                if (doc.getCharsSequence().charAt(end - 1) == '\n') {
                    --end;
                }
                if ((region = FoldingUtil.findFoldRegion((Editor)editor2, (int)start, (int)end)) != null) {
                    if (info2.getPsiElement(region) == null) {
                        editor2.getFoldingModel().removeFoldRegion(region);
                        info2.removeRegion(region);
                    } else {
                        HintManager.getInstance().showInformationHint(editor2, CodeInsightBundle.message("collapse.selection.existing.autogenerated.region", new Object[0]));
                    }
                } else {
                    if (foldingModel.intersectsRegion(start, end)) {
                        if (Messages.showDialog((Project)project2, (String)CodeInsightBundle.message("collapse.selection.overlapping.warning.text", new Object[0]), (String)CodeInsightBundle.message("collapse.selection.overlapping.warning.title", new Object[0]), (String[])new String[]{CodeInsightBundle.message("collapse.selection.overlapping.warning.ok", new Object[0]), CodeInsightBundle.message("collapse.selection.overlapping.warning.cancel", new Object[0])}, (int)1, (Icon)Messages.getWarningIcon()) != 0) {
                            return;
                        }
                        for (FoldRegion r : foldingModel.getAllFoldRegions()) {
                            if ((r.getStartOffset() >= start || r.getEndOffset() <= start || r.getEndOffset() >= end) && (r.getStartOffset() <= start || r.getStartOffset() >= end || r.getEndOffset() <= end)) continue;
                            foldingModel.removeFoldRegion(r);
                        }
                    }
                    LOG.assertTrue((region = foldingModel.addFoldRegion(start, end, ourPlaceHolderText)) != null, "Fold region is not created for (" + start + "," + end + "). Folding model: " + foldingModel + foldingModel.getClass());
                    region.setExpanded(false);
                    int offset2 = Math.min(start + ourPlaceHolderText.length(), doc.getTextLength());
                    editor2.getCaretModel().moveToOffset(offset2);
                }
            } else {
                FoldRegion[] regions = FoldingUtil.getFoldRegionsAtOffset((Editor)editor2, (int)editor2.getCaretModel().getOffset());
                if (regions.length > 0) {
                    FoldRegion region = regions[0];
                    if (info2.getPsiElement(region) == null) {
                        editor2.getFoldingModel().removeFoldRegion(region);
                        info2.removeRegion(region);
                    } else {
                        region.setExpanded(!region.isExpanded());
                    }
                }
            }
        });
    }

    public static boolean isEnabled(@NotNull Editor editor2) {
        if (editor2 == null) {
            CollapseSelectionHandler.$$$reportNull$$$0(3);
        }
        return editor2.getSelectionModel().getSelectionStart() < editor2.getSelectionModel().getSelectionEnd() || FoldingUtil.getFoldRegionsAtOffset((Editor)editor2, (int)editor2.getCaretModel().getOffset()).length > 0;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/folding/impl/CollapseSelectionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

