/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.FoldingPolicy;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.folding.impl.UpdateFoldRegionsOperation;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringTokenizer;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class DocumentFoldingInfo
implements CodeFoldingState {
    private static final Logger LOG = Logger.getInstance(DocumentFoldingInfo.class);
    private static final Key<FoldingInfo> FOLDING_INFO_KEY = Key.create("FOLDING_INFO");
    @NotNull
    private final Project myProject;
    private final VirtualFile myFile;
    @NotNull
    private final List<Info> myInfos;
    @NotNull
    private final List<RangeMarker> myRangeMarkers;
    private static final String DEFAULT_PLACEHOLDER = "...";
    @NonNls
    private static final String ELEMENT_TAG = "element";
    @NonNls
    private static final String SIGNATURE_ATT = "signature";
    @NonNls
    private static final String EXPANDED_ATT = "expanded";
    @NonNls
    private static final String MARKER_TAG = "marker";
    @NonNls
    private static final String DATE_ATT = "date";
    @NonNls
    private static final String PLACEHOLDER_ATT = "ph";

    DocumentFoldingInfo(@NotNull Project project2, @NotNull Document document) {
        if (project2 == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(0);
        }
        if (document == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(1);
        }
        this.myInfos = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myRangeMarkers = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project2;
        this.myFile = FileDocumentManager.getInstance().getFile(document);
    }

    void loadFromEditor(@NotNull Editor editor2) {
        FoldRegion[] foldRegions;
        if (editor2 == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        LOG.assertTrue(!editor2.isDisposed());
        this.clear();
        for (FoldRegion region : foldRegions = editor2.getFoldingModel().getAllFoldRegions()) {
            boolean collapseByDefault;
            if (!region.isValid() || region.shouldNeverExpand()) continue;
            boolean expanded = region.isExpanded();
            String signature = (String)region.getUserData(UpdateFoldRegionsOperation.SIGNATURE);
            if (Strings.areSameInstance(signature, "no signature")) continue;
            Boolean storedCollapseByDefault = (Boolean)region.getUserData(UpdateFoldRegionsOperation.COLLAPSED_BY_DEFAULT);
            boolean bl = collapseByDefault = storedCollapseByDefault != null && storedCollapseByDefault != false && !FoldingUtil.caretInsideRange((Editor)editor2, (TextRange)region.getTextRange());
            if (collapseByDefault != expanded && signature != null) continue;
            if (signature != null) {
                this.myInfos.add(new Info(signature, expanded));
                continue;
            }
            RangeMarker marker = editor2.getDocument().createRangeMarker(region.getStartOffset(), region.getEndOffset());
            this.myRangeMarkers.add(marker);
            marker.putUserData(FOLDING_INFO_KEY, new FoldingInfo(region.getPlaceholderText(), expanded));
        }
    }

    public void setToEditor(@NotNull Editor editor2) {
        if (editor2 == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiManager psiManager = PsiManager.getInstance(this.myProject);
        if (psiManager.isDisposed()) {
            return;
        }
        if (!this.myFile.isValid()) {
            return;
        }
        PsiFile psiFile = psiManager.findFile(this.myFile);
        if (psiFile == null) {
            return;
        }
        Map<PsiElement, FoldingDescriptor> ranges2 = null;
        for (Info info2 : this.myInfos) {
            TextRange range;
            FoldRegion region;
            FoldingDescriptor descriptor2;
            PsiElement element = FoldingPolicy.restoreBySignature(psiFile, info2.signature);
            if (element == null || !element.isValid()) continue;
            if (ranges2 == null) {
                ranges2 = DocumentFoldingInfo.buildRanges(editor2, psiFile);
            }
            if ((descriptor2 = (FoldingDescriptor)ranges2.get(element)) == null || (region = FoldingUtil.findFoldRegion((Editor)editor2, (int)(range = descriptor2.getRange()).getStartOffset(), (int)range.getEndOffset())) == null) continue;
            region.setExpanded(info2.expanded);
        }
        for (RangeMarker marker : this.myRangeMarkers) {
            if (!marker.isValid() || marker.getStartOffset() == marker.getEndOffset()) continue;
            FoldRegion region = FoldingUtil.findFoldRegion((Editor)editor2, (int)marker.getStartOffset(), (int)marker.getEndOffset());
            FoldingInfo info3 = marker.getUserData(FOLDING_INFO_KEY);
            if (region == null) {
                if (info3 != null) {
                    region = editor2.getFoldingModel().addFoldRegion(marker.getStartOffset(), marker.getEndOffset(), info3.placeHolder);
                }
                if (region == null) {
                    return;
                }
            }
            boolean state = info3 != null && info3.expanded;
            region.setExpanded(state);
        }
    }

    @NotNull
    private static Map<PsiElement, FoldingDescriptor> buildRanges(@NotNull Editor editor2, @NotNull PsiFile psiFile) {
        if (editor2 == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(4);
        }
        if (psiFile == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(5);
        }
        FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(psiFile.getLanguage());
        FileASTNode node2 = psiFile.getNode();
        if (node2 == null) {
            Map<PsiElement, FoldingDescriptor> map2 = Collections.emptyMap();
            if (map2 == null) {
                DocumentFoldingInfo.$$$reportNull$$$0(6);
            }
            return map2;
        }
        FoldingDescriptor[] descriptors = LanguageFolding.buildFoldingDescriptors(foldingBuilder, psiFile, editor2.getDocument(), true);
        HashMap<PsiElement, FoldingDescriptor> ranges2 = new HashMap<PsiElement, FoldingDescriptor>();
        for (FoldingDescriptor descriptor2 : descriptors) {
            ASTNode ast = descriptor2.getElement();
            PsiElement psi = ast.getPsi();
            if (psi == null) continue;
            ranges2.put(psi, descriptor2);
        }
        HashMap<PsiElement, FoldingDescriptor> hashMap = ranges2;
        if (hashMap == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    void clear() {
        this.myInfos.clear();
        for (RangeMarker marker : this.myRangeMarkers) {
            marker.dispose();
        }
        this.myRangeMarkers.clear();
    }

    void writeExternal(@NotNull Element element) {
        if (element == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(8);
        }
        if (this.myInfos.isEmpty() && this.myRangeMarkers.isEmpty()) {
            return;
        }
        for (Info info2 : this.myInfos) {
            Element e = new Element(ELEMENT_TAG);
            e.setAttribute(SIGNATURE_ATT, info2.signature);
            if (info2.expanded) {
                e.setAttribute(EXPANDED_ATT, Boolean.toString(true));
            }
            element.addContent(e);
        }
        String date = null;
        for (RangeMarker marker : this.myRangeMarkers) {
            FoldingInfo fi = marker.getUserData(FOLDING_INFO_KEY);
            boolean state = fi != null && fi.expanded;
            Element e = new Element(MARKER_TAG);
            if (date == null) {
                date = this.getTimeStamp();
            }
            if (date.isEmpty()) continue;
            e.setAttribute(DATE_ATT, date);
            e.setAttribute(EXPANDED_ATT, Boolean.toString(state));
            String signature = marker.getStartOffset() + ":" + marker.getEndOffset();
            e.setAttribute(SIGNATURE_ATT, signature);
            String placeHolderText = fi == null ? DEFAULT_PLACEHOLDER : fi.placeHolder;
            e.setAttribute(PLACEHOLDER_ATT, XmlStringUtil.escapeIllegalXmlChars(placeHolderText));
            element.addContent(e);
        }
    }

    void readExternal(Element element) {
        ApplicationManager.getApplication().runReadAction(() -> {
            this.clear();
            if (!this.myFile.isValid()) {
                return;
            }
            Document document = FileDocumentManager.getInstance().getDocument(this.myFile);
            if (document == null) {
                return;
            }
            String date = null;
            for (Element e : element.getChildren()) {
                String signature = e.getAttributeValue(SIGNATURE_ATT);
                if (signature == null) continue;
                boolean expanded = Boolean.parseBoolean(e.getAttributeValue(EXPANDED_ATT));
                if (ELEMENT_TAG.equals(e.getName())) {
                    this.myInfos.add(new Info(signature, expanded));
                    continue;
                }
                if (MARKER_TAG.equals(e.getName())) {
                    if (date == null) {
                        date = this.getTimeStamp();
                    }
                    if (date.isEmpty() || !date.equals(e.getAttributeValue(DATE_ATT)) || FileDocumentManager.getInstance().isDocumentUnsaved(document)) continue;
                    StringTokenizer tokenizer = new StringTokenizer(signature, ":");
                    try {
                        int start = Integer.valueOf(tokenizer.nextToken());
                        int end = Integer.valueOf(tokenizer.nextToken());
                        if (start < 0 || end >= document.getTextLength() || start > end) continue;
                        RangeMarker marker = document.createRangeMarker(start, end);
                        this.myRangeMarkers.add(marker);
                        String placeholderAttributeValue = e.getAttributeValue(PLACEHOLDER_ATT);
                        String placeHolderText = placeholderAttributeValue == null ? DEFAULT_PLACEHOLDER : XmlStringUtil.unescapeIllegalXmlChars(placeholderAttributeValue);
                        FoldingInfo fi = new FoldingInfo(placeHolderText, expanded);
                        marker.putUserData(FOLDING_INFO_KEY, fi);
                    }
                    catch (NoSuchElementException exc) {
                        LOG.error(exc);
                    }
                    continue;
                }
                throw new IllegalStateException("unknown tag: " + e.getName());
            }
        });
    }

    private String getTimeStamp() {
        if (!this.myFile.isValid()) {
            return "";
        }
        return Long.toString(this.myFile.getTimeStamp());
    }

    public int hashCode() {
        int result2 = this.myProject.hashCode();
        result2 = 31 * result2 + (this.myFile != null ? this.myFile.hashCode() : 0);
        result2 = 31 * result2 + this.myInfos.hashCode();
        result2 = 31 * result2 + this.myRangeMarkers.hashCode();
        return result2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentFoldingInfo info2 = (DocumentFoldingInfo)o;
        if (this.myFile != null ? !this.myFile.equals(info2.myFile) : info2.myFile != null) {
            return false;
        }
        if (!this.myProject.equals(info2.myProject) || !this.myInfos.equals(info2.myInfos)) {
            return false;
        }
        if (this.myRangeMarkers.size() != info2.myRangeMarkers.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.myRangeMarkers.size(); ++i2) {
            FoldingInfo ofi;
            RangeMarker other;
            RangeMarker marker = this.myRangeMarkers.get(i2);
            if (marker == (other = info2.myRangeMarkers.get(i2)) || !marker.isValid() || !other.isValid()) continue;
            if (!TextRange.areSegmentsEqual(marker, other)) {
                return false;
            }
            FoldingInfo fi = marker.getUserData(FOLDING_INFO_KEY);
            if (Comparing.equal(fi, ofi = other.getUserData(FOLDING_INFO_KEY))) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/folding/impl/DocumentFoldingInfo";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_TAG;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/folding/impl/DocumentFoldingInfo";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadFromEditor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setToEditor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildRanges";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 7 -> new IllegalStateException(string2);
        };
    }

    private record Info(@NotNull String signature, boolean expanded) {
        @NotNull
        private final String signature;

        private Info(@NotNull String signature, boolean expanded) {
            if (signature == null) {
                Info.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public String signature() {
            String string2 = this.signature;
            if (string2 == null) {
                Info.$$$reportNull$$$0(1);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = DocumentFoldingInfo.SIGNATURE_ATT;
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/folding/impl/DocumentFoldingInfo$Info";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/folding/impl/DocumentFoldingInfo$Info";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = DocumentFoldingInfo.SIGNATURE_ATT;
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }

    private record FoldingInfo(@NotNull String placeHolder, boolean expanded) {
        @NotNull
        private final String placeHolder;

        private FoldingInfo(@NotNull String placeHolder, boolean expanded) {
            if (placeHolder == null) {
                FoldingInfo.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public String placeHolder() {
            String string2 = this.placeHolder;
            if (string2 == null) {
                FoldingInfo.$$$reportNull$$$0(1);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "placeHolder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/folding/impl/DocumentFoldingInfo$FoldingInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/folding/impl/DocumentFoldingInfo$FoldingInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "placeHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }
}

