/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.AbstractElementSignatureProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiNamesElementSignatureProvider
extends AbstractElementSignatureProvider {
    private static final String TYPE_MARKER = "n";
    private static final String TOP_LEVEL_CHILD_MARKER = "!!top";
    private static final String DOC_COMMENT_MARKER = "!!doc";
    private static final String CODE_BLOCK_MARKER = "!!block";

    @Override
    protected PsiElement restoreBySignatureTokens(@NotNull PsiFile file2, @NotNull PsiElement parent2, @NotNull String type, @NotNull StringTokenizer tokenizer, @Nullable StringBuilder processingInfoStorage) {
        if (file2 == null) {
            PsiNamesElementSignatureProvider.$$$reportNull$$$0(0);
        }
        if (parent2 == null) {
            PsiNamesElementSignatureProvider.$$$reportNull$$$0(1);
        }
        if (type == null) {
            PsiNamesElementSignatureProvider.$$$reportNull$$$0(2);
        }
        if (tokenizer == null) {
            PsiNamesElementSignatureProvider.$$$reportNull$$$0(3);
        }
        if (!TYPE_MARKER.equals(type)) {
            if (processingInfoStorage != null) {
                processingInfoStorage.append(String.format("Stopping '%s' provider because given signature doesn't have expected type - can work with '%s' but got '%s'%n", this.getClass().getName(), TYPE_MARKER, type));
            }
            return null;
        }
        String elementMarker = tokenizer.nextToken();
        if (TOP_LEVEL_CHILD_MARKER.equals(elementMarker)) {
            PsiElement result2 = null;
            for (PsiElement child = file2.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child instanceof PsiWhiteSpace) continue;
                if (result2 == null) {
                    result2 = child;
                    continue;
                }
                if (processingInfoStorage != null) {
                    processingInfoStorage.append(String.format("Stopping '%s' provider because it has top level marker but more than one non white-space child: %s%n", this.getClass().getName(), Arrays.toString(file2.getChildren())));
                }
                return null;
            }
            if (processingInfoStorage != null) {
                processingInfoStorage.append(String.format("Finished processing of '%s' provider because all of its top-level children have been processed: %s%n", this.getClass().getName(), Arrays.toString(file2.getChildren())));
            }
            return result2;
        }
        if (DOC_COMMENT_MARKER.equals(elementMarker)) {
            PsiElement candidate = parent2.getFirstChild();
            return candidate instanceof PsiComment ? candidate : null;
        }
        if (CODE_BLOCK_MARKER.equals(elementMarker)) {
            int index2;
            block22: {
                index2 = 0;
                if (tokenizer.hasMoreTokens()) {
                    String indexStr = tokenizer.nextToken();
                    try {
                        index2 = Integer.parseInt(indexStr);
                    }
                    catch (NumberFormatException e) {
                        if (processingInfoStorage == null) break block22;
                        processingInfoStorage.append("Invalid block index: ").append(indexStr).append("\n");
                    }
                }
            }
            for (PsiElement child = parent2.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!PsiNamesElementSignatureProvider.isBlockElement(child) || --index2 >= 0) continue;
                return child;
            }
            return null;
        }
        if (!tokenizer.hasMoreTokens()) {
            if (processingInfoStorage != null) {
                processingInfoStorage.append(String.format("Stopping '%s' provider because it has no more data to process%n", this.getClass().getName()));
            }
            return null;
        }
        try {
            int index3 = Integer.parseInt(tokenizer.nextToken());
            if (processingInfoStorage != null) {
                processingInfoStorage.append(String.format("Looking for the child with a name '%s' # %d at the element '%s'%n", elementMarker, index3, parent2));
            }
            return PsiNamesElementSignatureProvider.restoreElementInternal(parent2, PsiNamesElementSignatureProvider.unescape(elementMarker), index3, PsiNamedElement.class);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public String getSignature(@NotNull PsiElement element) {
        if (element == null) {
            PsiNamesElementSignatureProvider.$$$reportNull$$$0(4);
        }
        StringBuilder buffer = null;
        for (PsiElement current = element; current != null && !(current instanceof PsiFile); current = current.getParent()) {
            int length = buffer == null ? 0 : buffer.length();
            StringBuilder b = PsiNamesElementSignatureProvider.getSignature(current, buffer);
            if (b == null && buffer != null && current.getParent() instanceof PsiFile && PsiNamesElementSignatureProvider.canResolveTopLevelChild(current)) {
                buffer.append(TYPE_MARKER).append("#").append(TOP_LEVEL_CHILD_MARKER).append(";");
                break;
            }
            buffer = b;
            if (buffer == null || length >= buffer.length()) {
                return null;
            }
            buffer.append(";");
        }
        if (buffer == null) {
            return null;
        }
        buffer.setLength(buffer.length() - 1);
        return buffer.toString();
    }

    private static boolean canResolveTopLevelChild(@NotNull PsiElement element) {
        PsiElement parent2;
        if (element == null) {
            PsiNamesElementSignatureProvider.$$$reportNull$$$0(5);
        }
        if ((parent2 = element.getParent()) == null) {
            return false;
        }
        for (PsiElement child = parent2.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof PsiWhiteSpace || child == element) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static StringBuilder getSignature(@NotNull PsiElement element, @Nullable StringBuilder buffer) {
        PsiElement parent2;
        if (element == null) {
            PsiNamesElementSignatureProvider.$$$reportNull$$$0(6);
        }
        if (element instanceof PsiNamedElement) {
            PsiNamedElement named = (PsiNamedElement)element;
            String name = named.getName();
            if (StringUtil.isEmpty(name)) {
                return null;
            }
            PsiElement parent3 = element.getParent();
            if (parent3 == null) {
                return null;
            }
            int index2 = PsiNamesElementSignatureProvider.getChildIndex(named, parent3, name, PsiNamedElement.class);
            if (index2 < 0) {
                return null;
            }
            StringBuilder bufferToUse = buffer;
            if (bufferToUse == null) {
                bufferToUse = new StringBuilder();
            }
            bufferToUse.append(TYPE_MARKER).append("#").append(PsiNamesElementSignatureProvider.escape(name)).append("#").append(index2);
            return bufferToUse;
        }
        if (element instanceof PsiComment) {
            parent2 = element.getParent();
            boolean nestedComment = false;
            if (parent2 instanceof PsiComment && parent2.getTextRange().equals(element.getTextRange())) {
                parent2 = parent2.getParent();
                nestedComment = true;
            }
            if (parent2 instanceof PsiNamedElement && (nestedComment || parent2.getFirstChild() == element)) {
                StringBuilder bufferToUse = buffer;
                if (bufferToUse == null) {
                    bufferToUse = new StringBuilder();
                }
                bufferToUse.append(TYPE_MARKER).append("#").append(DOC_COMMENT_MARKER);
                return bufferToUse;
            }
        }
        if ((parent2 = element.getParent()) instanceof PsiNamedElement && !(parent2 instanceof PsiFile) && PsiNamesElementSignatureProvider.isBlockElement(element)) {
            int index3 = PsiNamesElementSignatureProvider.getBlockElementIndex(element);
            StringBuilder bufferToUse = buffer;
            if (bufferToUse == null) {
                bufferToUse = new StringBuilder();
            }
            bufferToUse.append(TYPE_MARKER).append("#").append(CODE_BLOCK_MARKER);
            if (index3 > 0) {
                bufferToUse.append("#").append(index3);
            }
            return bufferToUse;
        }
        return null;
    }

    private static boolean isBlockElement(@NotNull PsiElement element) {
        if (element == null) {
            PsiNamesElementSignatureProvider.$$$reportNull$$$0(7);
        }
        PsiElement firstChild = element.getFirstChild();
        PsiElement lastChild = element.getLastChild();
        return firstChild != null && "{".equals(firstChild.getText()) && lastChild != null && "}".equals(lastChild.getText());
    }

    private static int getBlockElementIndex(@NotNull PsiElement element) {
        if (element == null) {
            PsiNamesElementSignatureProvider.$$$reportNull$$$0(8);
        }
        int i2 = 0;
        for (PsiElement sibling : element.getParent().getChildren()) {
            if (element.equals(sibling)) {
                return i2;
            }
            if (!PsiNamesElementSignatureProvider.isBlockElement(sibling)) continue;
            ++i2;
        }
        throw new RuntimeException("Malformed PSI");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenizer";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/folding/impl/PsiNamesElementSignatureProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreBySignatureTokens";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getSignature";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "canResolveTopLevelChild";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isBlockElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getBlockElementIndex";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

