/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.generation.PatternDescriptor;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.MultiMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateByPatternDialog
extends DialogWrapper {
    private final Project myProject;
    private JPanel myPanel;
    private Splitter mySplitter;
    private final Tree myTree;
    private final Editor myEditor;
    private final MultiMap<String, PatternDescriptor> myMap;

    public GenerateByPatternDialog(Project project2, PatternDescriptor[] descriptors) {
        super(project2);
        this.myProject = project2;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(CodeInsightBundle.message("button.generate.by.pattern", objectArray));
        this.setOKButtonText(CodeInsightBundle.message("button.generate", new Object[0]));
        this.myMap = new MultiMap();
        for (PatternDescriptor descriptor2 : descriptors) {
            this.myMap.putValue(descriptor2.getParentId(), descriptor2);
        }
        DefaultMutableTreeNode root = this.createNode(null);
        this.myTree = new SimpleTree(){};
        this.myTree.setRootVisible(false);
        this.myTree.setCellRenderer((TreeCellRenderer)new DefaultTreeCellRenderer(){

            @Override
            @NotNull
            public Component getTreeCellRendererComponent(@NotNull JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    2.$$$reportNull$$$0(0);
                }
                Component component2 = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                Object object = ((DefaultMutableTreeNode)value).getUserObject();
                if (object instanceof PatternDescriptor) {
                    this.setText(((PatternDescriptor)object).getName());
                    this.setIcon(((PatternDescriptor)object).getIcon());
                }
                Component component3 = component2;
                if (component3 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return component3;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tree";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInsight/generation/GenerateByPatternDialog$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInsight/generation/GenerateByPatternDialog$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTreeCellRendererComponent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getTreeCellRendererComponent";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 1 -> new IllegalStateException(string2);
                };
            }
        });
        this.myTree.setModel((TreeModel)new DefaultTreeModel(root));
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(@NotNull TreeSelectionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                GenerateByPatternDialog.this.update();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/generation/GenerateByPatternDialog$3", "valueChanged"));
            }
        });
        this.myEditor = TemplateEditorUtil.createEditor(true, "");
        this.mySplitter.setFirstComponent(ScrollPaneFactory.createScrollPane((Component)this.myTree));
        JPanel details2 = new JPanel(new BorderLayout());
        details2.add((Component)this.myEditor.getComponent(), "Center");
        this.mySplitter.setSecondComponent(details2);
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.mySplitter.setShowDividerControls(true);
        this.myTree.setSelectionRow(0);
        this.init();
    }

    private void update() {
        DefaultMutableTreeNode node2 = this.getSelectedNode();
        this.getOKAction().setEnabled(node2 != null && node2.isLeaf());
        PatternDescriptor descriptor2 = this.getSelectedDescriptor();
        if (descriptor2 != null) {
            this.updateDetails(descriptor2);
        }
    }

    private DefaultMutableTreeNode getSelectedNode() {
        TreePath path2 = this.myTree.getSelectionModel().getSelectionPath();
        return path2 == null ? null : (DefaultMutableTreeNode)path2.getLastPathComponent();
    }

    PatternDescriptor getSelectedDescriptor() {
        Object object;
        DefaultMutableTreeNode selectedNode = this.getSelectedNode();
        if (selectedNode != null && (object = selectedNode.getUserObject()) instanceof PatternDescriptor) {
            return (PatternDescriptor)object;
        }
        return null;
    }

    private void updateDetails(PatternDescriptor descriptor2) {
        WriteCommandAction.writeCommandAction(this.myProject).run(() -> {
            Template template = descriptor2.getTemplate();
            if (template instanceof TemplateImpl) {
                String text2 = template.getString();
                this.myEditor.getDocument().replaceString(0, this.myEditor.getDocument().getTextLength(), text2);
                TemplateEditorUtil.setHighlighter(this.myEditor, ((TemplateImpl)template).getTemplateContext());
            } else {
                this.myEditor.getDocument().replaceString(0, this.myEditor.getDocument().getTextLength(), "");
            }
        });
    }

    private DefaultMutableTreeNode createNode(@Nullable PatternDescriptor descriptor2) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(descriptor2){

            @Override
            @NotNull
            public String toString() {
                Object object = this.getUserObject();
                String string2 = object == null ? "" : ((PatternDescriptor)object).getName();
                if (string2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                return string2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateByPatternDialog$4", "toString"));
            }
        };
        String id = descriptor2 == null ? "root" : descriptor2.getId();
        Collection<PatternDescriptor> collection = this.myMap.get(id);
        for (PatternDescriptor childDescriptor : collection) {
            root.add(this.createNode(childDescriptor));
        }
        return root;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    protected String getDimensionServiceKey() {
        return "generate.patterns.dialog";
    }

    protected void dispose() {
        super.dispose();
        EditorFactory.getInstance().releaseEditor(this.myEditor);
    }

    private void createUIComponents() {
        this.mySplitter = new Splitter(false, 0.3f);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Splitter splitter = this.mySplitter;
        jPanel.add((Component)splitter, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, new Dimension(400, 300), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

