/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithRangeAdjuster;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.LiveTemplatesConfigurable;
import com.intellij.codeInsight.template.impl.SurroundWithLogger;
import com.intellij.codeInsight.template.impl.SurroundWithTemplateHandler;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.idea.ActionsBundle;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageSurrounders;
import com.intellij.lang.folding.CustomFoldingSurroundDescriptor;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SurroundWithHandler
implements CodeInsightActionHandler {
    public static final TextRange CARET_IS_OK = new TextRange(0, 0);

    @Override
    public void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (project2 == null) {
            SurroundWithHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            SurroundWithHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            SurroundWithHandler.$$$reportNull$$$0(2);
        }
        SurroundWithHandler.invoke(project2, editor2, file2, null);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    public static void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2, Surrounder surrounder) {
        if (project2 == null) {
            SurroundWithHandler.$$$reportNull$$$0(3);
        }
        if (editor2 == null) {
            SurroundWithHandler.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            SurroundWithHandler.$$$reportNull$$$0(5);
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)editor2)) {
            return;
        }
        if (file2 instanceof PsiCompiledElement) {
            HintManager.getInstance().showErrorHint(editor2, LangBundle.message("hint.text.can.t.modify.decompiled.code", new Object[0]));
            return;
        }
        List<AnAction> applicable = SurroundWithHandler.buildSurroundActions(project2, editor2, file2, surrounder);
        if (applicable != null) {
            SurroundWithHandler.showPopup(editor2, applicable);
        } else if (!ApplicationManager.getApplication().isUnitTestMode()) {
            HintManager.getInstance().showErrorHint(editor2, LangBundle.message("hint.text.couldn.t.find.surround", new Object[0]));
        }
    }

    @Nullable
    public static List<AnAction> buildSurroundActions(Project project2, Editor editor2, PsiFile file2, @Nullable Surrounder surrounder) {
        SelectionModel selectionModel = editor2.getSelectionModel();
        boolean hasSelection = selectionModel.hasSelection();
        if (!hasSelection) {
            SurroundWithHandler.selectLogicalLineContents(editor2);
        }
        int[] startOffsets = editor2.getCaretModel().getAllCarets().stream().mapToInt(Caret::getSelectionStart).toArray();
        int[] endOffsets = editor2.getCaretModel().getAllCarets().stream().mapToInt(Caret::getSelectionEnd).toArray();
        Language baseLanguage = file2.getViewProvider().getBaseLanguage();
        Language previousLanguage = null;
        for (int i2 = 0; i2 < startOffsets.length; ++i2) {
            PsiElement element1 = file2.findElementAt(startOffsets[i2]);
            PsiElement element2 = file2.findElementAt(endOffsets[i2] - 1);
            if (element1 == null || element2 == null) {
                return null;
            }
            Object textRange = new TextRange(startOffsets[i2], endOffsets[i2]);
            for (SurroundWithRangeAdjuster surroundWithRangeAdjuster : SurroundWithRangeAdjuster.EP_NAME.getExtensionList()) {
                textRange = surroundWithRangeAdjuster.adjustSurroundWithRange(file2, (TextRange)textRange, hasSelection);
                if (textRange != null) continue;
                return null;
            }
            startOffsets[i2] = ((TextRange)textRange).getStartOffset();
            endOffsets[i2] = ((TextRange)textRange).getEndOffset();
            element1 = file2.findElementAt(startOffsets[0]);
            assert (element1 != null);
            Language language = element1.getParent().getLanguage();
            if (previousLanguage != null && !language.equals(previousLanguage)) {
                return null;
            }
            previousLanguage = language;
        }
        assert (previousLanguage != null);
        ArrayList<Object> surroundDescriptors = new ArrayList(LanguageSurrounders.INSTANCE.allForLanguage(previousLanguage));
        if (previousLanguage != baseLanguage) {
            surroundDescriptors.addAll(LanguageSurrounders.INSTANCE.allForLanguage(baseLanguage));
        }
        surroundDescriptors.add(CustomFoldingSurroundDescriptor.INSTANCE);
        int exclusiveCount = 0;
        ArrayList<SurroundDescriptor> exclusiveSurroundDescriptors = new ArrayList<SurroundDescriptor>();
        for (SurroundDescriptor surroundDescriptor : surroundDescriptors) {
            if (!surroundDescriptor.isExclusive()) continue;
            ++exclusiveCount;
            exclusiveSurroundDescriptors.add(surroundDescriptor);
        }
        if (exclusiveCount > 0) {
            surroundDescriptors = exclusiveSurroundDescriptors;
        }
        if (surrounder != null) {
            SurroundWithHandler.invokeSurrounderInTests(project2, editor2, file2, surrounder, startOffsets, endOffsets, surroundDescriptors);
            return null;
        }
        LinkedHashMap<Surrounder, PsiElement[]> surrounders = new LinkedHashMap<Surrounder, PsiElement[]>();
        for (SurroundDescriptor surroundDescriptor : surroundDescriptors) {
            PsiElement[] elements = SurroundWithHandler.getElementsToSurround(surroundDescriptor, file2, startOffsets, endOffsets);
            if (elements.length <= 0) continue;
            for (PsiElement element : elements) {
                assert (element != null) : "descriptor " + surroundDescriptor + " returned null element";
                assert (element.isValid()) : surroundDescriptor;
            }
            for (Surrounder s : surroundDescriptor.getSurrounders()) {
                surrounders.put(s, elements);
            }
        }
        return SurroundWithHandler.doBuildSurroundActions(project2, editor2, file2, surrounders);
    }

    private static PsiElement[] getElementsToSurround(SurroundDescriptor descriptor2, PsiFile file2, int[] startOffsets, int[] endOffsets) {
        ArrayList<PsiElement> elementList = new ArrayList<PsiElement>();
        for (int i2 = 0; i2 < startOffsets.length; ++i2) {
            elementList.addAll(List.of(descriptor2.getElementsToSurround(file2, startOffsets[i2], endOffsets[i2])));
        }
        return (PsiElement[])elementList.toArray(PsiElement[]::new);
    }

    private static void selectLogicalLineContents(Editor editor2) {
        Document document = editor2.getDocument();
        CharSequence text2 = document.getImmutableCharSequence();
        for (Caret caret : editor2.getCaretModel().getAllCarets()) {
            int caretOffset = caret.getOffset();
            caret.setSelection(CharArrayUtil.shiftForward(text2, DocumentUtil.getLineStartOffset(caretOffset, document), " \t"), CharArrayUtil.shiftBackward(text2, DocumentUtil.getLineEndOffset(caretOffset, document) - 1, " \t") + 1);
        }
    }

    public static void selectLogicalLineContentsAtCaret(Editor editor2) {
        int caretOffset = editor2.getCaretModel().getOffset();
        Document document = editor2.getDocument();
        CharSequence text2 = document.getImmutableCharSequence();
        editor2.getSelectionModel().setSelection(CharArrayUtil.shiftForward(text2, DocumentUtil.getLineStartOffset(caretOffset, document), " \t"), CharArrayUtil.shiftBackward(text2, DocumentUtil.getLineEndOffset(caretOffset, document) - 1, " \t") + 1);
    }

    private static void invokeSurrounderInTests(Project project2, Editor editor2, PsiFile file2, Surrounder surrounder, int[] startOffsets, int[] endOffsets, List<? extends SurroundDescriptor> surroundDescriptors) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        for (SurroundDescriptor surroundDescriptor : surroundDescriptors) {
            PsiElement[] elements = SurroundWithHandler.getElementsToSurround(surroundDescriptor, file2, startOffsets, endOffsets);
            if (elements.length <= 0) continue;
            for (Surrounder descriptorSurrounder : surroundDescriptor.getSurrounders()) {
                if (!surrounder.getClass().equals(descriptorSurrounder.getClass())) continue;
                SurroundWithHandler.doSurround(project2, editor2, surrounder, elements);
                return;
            }
        }
    }

    private static void showPopup(Editor editor2, List<AnAction> applicable) {
        DataContext context2 = DataManager.getInstance().getDataContext((Component)editor2.getContentComponent());
        JBPopupFactory.ActionSelectionAid mnemonics = JBPopupFactory.ActionSelectionAid.MNEMONICS;
        DefaultActionGroup group2 = new DefaultActionGroup(applicable.toArray(AnAction.EMPTY_ARRAY));
        JBPopupFactory.getInstance().createActionGroupPopup(CodeInsightBundle.message("surround.with.chooser.title", new Object[0]), (ActionGroup)group2, context2, mnemonics, true).showInBestPositionFor(editor2);
    }

    static void doSurround(Project project2, Editor editor2, Surrounder surrounder, PsiElement[] elements) {
        WriteAction.run(() -> PsiDocumentManager.getInstance(project2).commitDocument(editor2.getDocument()));
        int col = editor2.getCaretModel().getLogicalPosition().column;
        int line = editor2.getCaretModel().getLogicalPosition().line;
        if (!editor2.getCaretModel().supportsMultipleCarets()) {
            LogicalPosition pos = new LogicalPosition(0, 0);
            editor2.getCaretModel().moveToLogicalPosition(pos);
        }
        if (surrounder.startInWriteAction()) {
            WriteCommandAction.runWriteCommandAction(project2, CodeInsightBundle.message("surround.with.chooser.title", new Object[0]), null, () -> {
                TextRange range = surrounder.surroundElements(project2, editor2, elements);
                SurroundWithHandler.updateRange(project2, editor2, range, line, col);
            }, new PsiFile[0]);
        } else {
            CommandProcessor.getInstance().executeCommand(project2, () -> {
                TextRange range = ReadAction.compute(() -> surrounder.surroundElements(project2, editor2, elements));
                SurroundWithHandler.updateRange(project2, editor2, range, line, col);
            }, CodeInsightBundle.message("surround.with.chooser.title", new Object[0]), null);
        }
    }

    private static void updateRange(Project project2, Editor editor2, TextRange range, int line, int col) {
        if (range != CARET_IS_OK) {
            if (TemplateManager.getInstance(project2).getActiveTemplate(editor2) == null && InplaceRefactoring.getActiveInplaceRenamer(editor2) == null) {
                LogicalPosition pos1 = new LogicalPosition(line, col);
                editor2.getCaretModel().moveToLogicalPosition(pos1);
            }
            if (range != null) {
                int offset2 = range.getStartOffset();
                editor2.getCaretModel().removeSecondaryCarets();
                editor2.getCaretModel().moveToOffset(offset2);
                editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                editor2.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
            }
        }
    }

    @Nullable
    private static List<AnAction> doBuildSurroundActions(Project project2, Editor editor2, PsiFile file2, Map<Surrounder, PsiElement[]> surrounders) {
        ArrayList<AnAction> applicable = new ArrayList<AnAction>();
        HashSet<Character> usedMnemonicsSet = new HashSet<Character>();
        int index2 = 0;
        for (Map.Entry<Surrounder, PsiElement[]> entry : surrounders.entrySet()) {
            PsiElement[] elements;
            Surrounder surrounder = entry.getKey();
            if (!surrounder.isApplicable(elements = entry.getValue())) continue;
            char mnemonic = index2 < 9 ? (char)((char)(48 + index2 + 1)) : (index2 == 9 ? (char)'0' : (char)(65 + index2 - 10));
            ++index2;
            usedMnemonicsSet.add(Character.valueOf(Character.toUpperCase(mnemonic)));
            applicable.add(new InvokeSurrounderAction(surrounder, project2, editor2, elements, mnemonic));
        }
        List<AnAction> templateGroup = SurroundWithTemplateHandler.createActionGroup(editor2, file2, usedMnemonicsSet);
        if (!templateGroup.isEmpty()) {
            applicable.add((AnAction)new Separator(IdeBundle.messagePointer((String)"action.Anonymous.text.live.templates", (Object[])new Object[0])));
            applicable.addAll(templateGroup);
            applicable.add((AnAction)Separator.getInstance());
            applicable.add(new ConfigureTemplatesAction());
        }
        return applicable.isEmpty() ? null : applicable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/generation/surroundWith/SurroundWithHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class InvokeSurrounderAction
    extends AnAction {
        private final Surrounder mySurrounder;
        private final Project myProject;
        private final Editor myEditor;
        private final PsiElement[] myElements;

        InvokeSurrounderAction(Surrounder surrounder, Project project2, Editor editor2, PsiElement[] elements, char mnemonic) {
            super("\u001b" + String.valueOf(mnemonic) + ". " + surrounder.getTemplateDescription());
            this.mySurrounder = surrounder;
            this.myProject = project2;
            this.myEditor = editor2;
            this.myElements = elements;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                InvokeSurrounderAction.$$$reportNull$$$0(0);
            }
            if (!FileDocumentManager.getInstance().requestWriting(this.myEditor.getDocument(), this.myProject)) {
                return;
            }
            Language language = Language.ANY;
            if (this.myElements != null && this.myElements.length != 0) {
                language = this.myElements[0].getLanguage();
            }
            SurroundWithHandler.doSurround(this.myProject, this.myEditor, this.mySurrounder, this.myElements);
            SurroundWithLogger.logSurrounder(this.mySurrounder, language, this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/generation/surroundWith/SurroundWithHandler$InvokeSurrounderAction", "actionPerformed"));
        }
    }

    private static final class ConfigureTemplatesAction
    extends AnAction {
        private ConfigureTemplatesAction() {
            super(ActionsBundle.messagePointer((String)"action.ConfigureTemplatesAction.text", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ConfigureTemplatesAction.$$$reportNull$$$0(0);
            }
            ShowSettingsUtil.getInstance().showSettingsDialog((Project)e.getData(CommonDataKeys.PROJECT), LiveTemplatesConfigurable.displayName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/generation/surroundWith/SurroundWithHandler$ConfigureTemplatesAction", "actionPerformed"));
        }
    }
}

