/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.highlighting.BackgroundHighlighter;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.TriConsumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.UIUtil;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class BackgroundHighlightingUtil {
    static <T> void lookForInjectedFileInOtherThread(@NotNull Project project2, @NotNull Editor editor2, @NotNull BiFunction<? super PsiFile, ? super Editor, ? extends T> backgroundProcessor, @NotNull TriConsumer<? super PsiFile, ? super Editor, ? super T> edtProcessor) {
        if (project2 == null) {
            BackgroundHighlightingUtil.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            BackgroundHighlightingUtil.$$$reportNull$$$0(1);
        }
        if (backgroundProcessor == null) {
            BackgroundHighlightingUtil.$$$reportNull$$$0(2);
        }
        if (edtProcessor == null) {
            BackgroundHighlightingUtil.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!BackgroundHighlightingUtil.isValidEditor(editor2)) {
            return;
        }
        int offsetBefore = editor2.getCaretModel().getOffset();
        ReadAction.nonBlocking(() -> {
            PsiFile psiFile = PsiUtilBase.getPsiFileInEditor(editor2, project2);
            if (psiFile == null) {
                return null;
            }
            if (psiFile instanceof PsiCompiledFile) {
                psiFile = ((PsiCompiledFile)psiFile).getDecompiledPsiFile();
            }
            if (psiFile instanceof PsiBinaryFile && BinaryFileTypeDecompilers.getInstance().forFileType(psiFile.getFileType()) == null) {
                return null;
            }
            PsiFile newFile = BackgroundHighlightingUtil.getInjectedFileIfAny(offsetBefore, psiFile);
            Editor newEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor2, newFile);
            Object result2 = backgroundProcessor.apply(newFile, newEditor);
            return Trinity.create(newFile, newEditor, result2);
        }).withDocumentsCommitted(project2).expireWhen(() -> !BackgroundHighlightingUtil.isValidEditor(editor2)).coalesceBy(BackgroundHighlightingUtil.class, editor2).finishOnUiThread(ModalityState.stateForComponent(editor2.getComponent()), t -> {
            if (t == null) {
                return;
            }
            PsiFile foundFile = (PsiFile)t.getFirst();
            if (foundFile == null) {
                return;
            }
            if (foundFile.isValid() && offsetBefore == editor2.getCaretModel().getOffset()) {
                Editor newEditor = (Editor)t.getSecond();
                Object result2 = t.getThird();
                edtProcessor.accept(foundFile, (Editor)newEditor, (Object)result2);
            } else {
                BackgroundHighlightingUtil.lookForInjectedFileInOtherThread(project2, editor2, backgroundProcessor, edtProcessor);
            }
        }).submit(AppExecutorUtil.getAppExecutorService());
    }

    static boolean isValidEditor(@NotNull Editor editor2) {
        Project editorProject;
        if (editor2 == null) {
            BackgroundHighlightingUtil.$$$reportNull$$$0(4);
        }
        return (editorProject = editor2.getProject()) != null && !editorProject.isDisposed() && !editor2.isDisposed() && UIUtil.isShowing(editor2.getContentComponent());
    }

    static boolean needMatching(@NotNull Editor newEditor, @NotNull CodeInsightSettings codeInsightSettings) {
        if (newEditor == null) {
            BackgroundHighlightingUtil.$$$reportNull$$$0(5);
        }
        if (codeInsightSettings == null) {
            BackgroundHighlightingUtil.$$$reportNull$$$0(6);
        }
        if (!codeInsightSettings.HIGHLIGHT_BRACES) {
            return false;
        }
        if (newEditor.getSelectionModel().hasSelection()) {
            return false;
        }
        if (newEditor.getSoftWrapModel().isInsideOrBeforeSoftWrap(newEditor.getCaretModel().getVisualPosition())) {
            return false;
        }
        TemplateState state = TemplateManagerImpl.getTemplateState(newEditor);
        return state == null || state.isFinished();
    }

    @NotNull
    static PsiFile getInjectedFileIfAny(int offset2, @NotNull PsiFile psiFile) {
        PsiFile injected;
        PsiElement injectedElement;
        if (psiFile == null) {
            BackgroundHighlightingUtil.$$$reportNull$$$0(7);
        }
        if ((injectedElement = InjectedLanguageManager.getInstance(psiFile.getProject()).findInjectedElementAt(psiFile, offset2)) != null && (injected = injectedElement.getContainingFile()) != null) {
            PsiFile psiFile2 = injected;
            if (psiFile2 == null) {
                BackgroundHighlightingUtil.$$$reportNull$$$0(8);
            }
            return psiFile2;
        }
        PsiFile psiFile3 = psiFile;
        if (psiFile3 == null) {
            BackgroundHighlightingUtil.$$$reportNull$$$0(9);
        }
        return psiFile3;
    }

    @TestOnly
    public static void enableListenersInTest(@NotNull Project project2, @NotNull Disposable disposable) {
        if (project2 == null) {
            BackgroundHighlightingUtil.$$$reportNull$$$0(10);
        }
        if (disposable == null) {
            BackgroundHighlightingUtil.$$$reportNull$$$0(11);
        }
        BackgroundHighlighter.enableListenersInTest(project2, disposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backgroundProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edtProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newEditor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeInsightSettings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/BackgroundHighlightingUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/BackgroundHighlightingUtil";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedFileIfAny";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "lookForInjectedFileInOtherThread";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isValidEditor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "needMatching";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedFileIfAny";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "enableListenersInTest";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 8, 9 -> new IllegalStateException(string2);
        };
    }
}

