/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.highlighting.HighlightedReference;
import com.intellij.codeInsight.highlighting.PsiHighlightedReference;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.model.psi.PsiSymbolReferenceService;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class HyperlinkAnnotator
implements Annotator {
    private static final Key<@Nls String> messageKey = Key.create("hyperlink.message");

    @Override
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            HyperlinkAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            HyperlinkAnnotator.$$$reportNull$$$0(1);
        }
        if (holder.isBatchMode()) {
            return;
        }
        for (PsiHighlightedReference reference2 : PsiSymbolReferenceService.getService().getReferences(element, PsiHighlightedReference.class)) {
            TextRange range = reference2.getAbsoluteRange();
            String message = reference2.highlightMessage();
            AnnotationBuilder annotationBuilder = message == null ? holder.newSilentAnnotation(reference2.highlightSeverity()) : holder.newAnnotation(reference2.highlightSeverity(), message);
            reference2.highlightReference(annotationBuilder.range(range)).create();
        }
        if (WebReference.isWebReferenceWorthy(element)) {
            for (PsiReference reference3 : element.getReferences()) {
                TextRange rangeInElement;
                TextRange range;
                if (reference3 instanceof WebReference) {
                    String message = holder.getCurrentAnnotationSession().getUserData(messageKey);
                    if (message == null) {
                        message = HyperlinkAnnotator.getMessage();
                        holder.getCurrentAnnotationSession().putUserData(messageKey, message);
                    }
                    range = reference3.getRangeInElement().shiftRight(element.getTextRange().getStartOffset());
                    holder.newAnnotation(HighlightSeverity.INFORMATION, message).range(range).textAttributes(CodeInsightColors.INACTIVE_HYPERLINK_ATTRIBUTES).create();
                    continue;
                }
                if (!(reference3 instanceof HighlightedReference) || reference3.isSoft() && !((HighlightedReference)reference3).isHighlightedWhenSoft() || (rangeInElement = reference3.getRangeInElement()).isEmpty()) continue;
                range = rangeInElement.shiftRight(element.getTextRange().getStartOffset());
                holder.newSilentAnnotation(HighlightInfoType.HIGHLIGHTED_REFERENCE_SEVERITY).range(range).textAttributes(DefaultLanguageHighlighterColors.HIGHLIGHTED_REFERENCE).create();
            }
        }
    }

    @Nls
    @NotNull
    @ApiStatus.Internal
    public static String getMessage() {
        Shortcut keyboardShortcut;
        Object message = IdeBundle.message((String)"open.url.in.browser.tooltip", (Object[])new Object[0]);
        Shortcut[] shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts("GotoDeclaration");
        Object shortcutText = "";
        Shortcut mouseShortcut = ContainerUtil.find(shortcuts, shortcut -> !shortcut.isKeyboard());
        if (mouseShortcut != null) {
            shortcutText = (String)shortcutText + KeymapUtil.getShortcutText((Shortcut)mouseShortcut);
            shortcutText = ((String)shortcutText).replace("Button1 ", "");
        }
        if ((keyboardShortcut = ContainerUtil.find(shortcuts, shortcut -> shortcut.isKeyboard())) != null) {
            if (!((String)shortcutText).isEmpty()) {
                shortcutText = (String)shortcutText + ", ";
            }
            shortcutText = (String)shortcutText + KeymapUtil.getShortcutText((Shortcut)keyboardShortcut);
        }
        if (!((String)shortcutText).isEmpty()) {
            message = (String)message + " (" + (String)shortcutText + ")";
        }
        String string2 = message;
        if (string2 == null) {
            HyperlinkAnnotator.$$$reportNull$$$0(2);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/HyperlinkAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/HyperlinkAnnotator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }
}

