/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;

public final class ElementLocationUtil {
    private ElementLocationUtil() {
    }

    @Deprecated(forRemoval=true)
    public static void customizeElementLabel(PsiElement element, JLabel label2) {
        Ref ref = new Ref();
        label2.setText(ElementLocationUtil.renderElementLocation(element, ref));
        label2.setIcon((Icon)ref.get());
    }

    @NlsSafe
    public static String renderElementLocation(PsiElement element, Ref<? super Icon> icon2) {
        if (element != null) {
            VirtualFile vfile;
            PsiFile file2 = element.getContainingFile();
            VirtualFile virtualFile2 = vfile = file2 == null ? null : file2.getVirtualFile();
            if (vfile == null) {
                icon2.set(null);
                return "";
            }
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance(element.getProject()).getFileIndex();
            Module module2 = fileIndex.getModuleForFile(vfile);
            if (module2 != null) {
                if (ModuleType.isInternal((Module)module2)) {
                    icon2.set(null);
                    return "";
                }
                icon2.set(ModuleType.get((Module)module2).getIcon());
                return module2.getName();
            }
            List<OrderEntry> entries2 = fileIndex.getOrderEntriesForFile(vfile);
            OrderEntry entry = null;
            for (OrderEntry order : entries2) {
                if (!(order instanceof LibraryOrderEntry) && !(order instanceof JdkOrderEntry)) continue;
                entry = order;
                break;
            }
            if (entry != null) {
                icon2.set(AllIcons.Nodes.PpLibFolder);
                return entry.getPresentableName();
            }
        }
        icon2.set(null);
        return "";
    }
}

