/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.ParameterInfoComponent;
import com.intellij.codeInsight.hint.ParameterInfoControllerBase;
import com.intellij.codeInsight.hint.ParameterInfoControllerData;
import com.intellij.codeInsight.hint.ParameterInfoListener;
import com.intellij.codeInsight.hint.ParameterInfoTaskRunnerUtil;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.LookupManagerListener;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.IdeTooltip;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public final class ParameterInfoController
extends ParameterInfoControllerBase {
    private LightweightHint myHint;
    private final ParameterInfoComponent myComponent;
    private boolean myKeepOnHintHidden;
    private final MyBestLocationPointProvider myProvider;

    @Override
    protected boolean canBeDisposed() {
        return !this.myHint.isVisible() && !this.myKeepOnHintHidden && !ApplicationManager.getApplication().isHeadlessEnvironment() || this.myEditor instanceof EditorWindow && !((EditorWindow)this.myEditor).isValid();
    }

    @Override
    public boolean isHintShown(boolean anyType) {
        return this.myHint.isVisible() && (!this.mySingleParameterInfo || anyType);
    }

    public ParameterInfoController(@NotNull Project project2, @NotNull Editor editor2, int lbraceOffset, Object[] descriptors, Object highlighted, PsiElement parameterOwner, @NotNull ParameterInfoHandler handler2, boolean showHint2, boolean requestFocus) {
        if (project2 == null) {
            ParameterInfoController.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            ParameterInfoController.$$$reportNull$$$0(1);
        }
        if (handler2 == null) {
            ParameterInfoController.$$$reportNull$$$0(2);
        }
        super(project2, editor2, lbraceOffset, descriptors, highlighted, parameterOwner, handler2, showHint2);
        this.myProvider = new MyBestLocationPointProvider(editor2);
        this.myComponent = new ParameterInfoComponent(this.myParameterInfoControllerData, editor2, requestFocus, true);
        this.myHint = this.createHint();
        this.myKeepOnHintHidden = !showHint2;
        this.myHint.setSelectingHint(true);
        this.myParameterInfoControllerData.setParameterOwner(parameterOwner);
        this.myParameterInfoControllerData.setHighlighted(highlighted);
        this.registerSelf();
        this.setupListeners();
        LookupListener lookupListener = new LookupListener(){
            LookupImpl activeLookup = null;
            final MergingUpdateQueue queue;
            {
                this.queue = new MergingUpdateQueue("Update parameter info position", 200, true, (JComponent)ParameterInfoController.this.myComponent);
            }

            @Override
            public void lookupShown(@NotNull LookupEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.activeLookup = (LookupImpl)event.getLookup();
            }

            @Override
            public void lookupCanceled(@NotNull LookupEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.activeLookup = null;
            }

            @Override
            public void uiRefreshed() {
                this.queue.queue(new Update("PI update"){

                    public void run() {
                        if (activeLookup != null) {
                            ParameterInfoController.this.updateComponent();
                        }
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/codeInsight/hint/ParameterInfoController$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lookupShown";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lookupCanceled";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        LookupManagerListener lookupManagerListener = (oldLookup, newLookup) -> {
            if (newLookup != null && ClientId.isCurrentlyUnderLocalId()) {
                newLookup.addLookupListener(lookupListener);
            }
        };
        project2.getMessageBus().connect(this).subscribe(LookupManagerListener.TOPIC, lookupManagerListener);
        if (showHint2) {
            this.showHint(requestFocus, this.mySingleParameterInfo);
        } else {
            this.updateComponent();
        }
    }

    @Override
    public void setDescriptors(Object[] descriptors) {
        super.setDescriptors(descriptors);
        this.myComponent.fireDescriptorsWereSet();
    }

    @Override
    @NotNull
    protected ParameterInfoControllerData createParameterInfoControllerData(@NotNull ParameterInfoHandler<PsiElement, Object> handler2) {
        if (handler2 == null) {
            ParameterInfoController.$$$reportNull$$$0(3);
        }
        return new ParameterInfoControllerData(handler2){

            @Override
            public boolean isDescriptorEnabled(int descriptorIndex) {
                return ParameterInfoController.this.myComponent.isEnabled(descriptorIndex);
            }

            @Override
            public void setDescriptorEnabled(int descriptorIndex, boolean enabled) {
                ParameterInfoController.this.myComponent.setEnabled(descriptorIndex, enabled);
            }
        };
    }

    private LightweightHint createHint() {
        WrapperPanel wrapper2 = new WrapperPanel();
        wrapper2.add(this.myComponent);
        return new LightweightHint((JComponent)wrapper2);
    }

    @Override
    public void showHint(boolean requestFocus, boolean singleParameterInfo) {
        if (this.myHint.isVisible()) {
            JComponent myHintComponent = this.myHint.getComponent();
            myHintComponent.removeAll();
            this.hideHint();
            this.myHint = this.createHint();
        }
        this.mySingleParameterInfo = singleParameterInfo && this.myKeepOnHintHidden;
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        Pair<Point, Short> pos = this.myProvider.getBestPointPosition(this.myHint, this.myParameterInfoControllerData.getParameterOwner(), caretOffset, null, (short)1);
        HintHint hintHint = HintManagerImpl.createHintHint((Editor)this.myEditor, (Point)pos.getFirst(), (LightweightHint)this.myHint, (short)pos.getSecond());
        hintHint.setExplicitClose(true);
        hintHint.setRequestFocus(requestFocus);
        hintHint.setShowImmediately(true);
        hintHint.setBorderColor(ParameterInfoComponent.BORDER_COLOR);
        hintHint.setBorderInsets((Insets)JBUI.insets(4, 1, 4, 1));
        hintHint.setComponentBorder((Border)JBUI.Borders.empty());
        int flags = 129;
        if (!singleParameterInfo && this.myKeepOnHintHidden) {
            flags |= 8;
        }
        Editor editorToShow = InjectedLanguageEditorUtil.getTopLevelEditor(this.myEditor);
        this.myComponent.update(this.mySingleParameterInfo);
        HintManagerImpl.getInstanceImpl().showEditorHint(this.myHint, editorToShow, pos.getFirst(), flags, 0, false, hintHint);
        this.updateComponent();
    }

    @Override
    public void updateComponent() {
        if (this.canBeDisposed()) {
            Disposer.dispose(this);
            return;
        }
        PsiFile file2 = PsiUtilBase.getPsiFileInEditor(this.myEditor, this.myProject);
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        int offset2 = this.getCurrentOffset();
        ParameterInfoControllerBase.UpdateParameterInfoContextBase context2 = new ParameterInfoControllerBase.UpdateParameterInfoContextBase(this, offset2, file2);
        this.executeFindElementForUpdatingParameterInfo(context2, elementForUpdating -> {
            this.myParameterInfoControllerData.getHandler().processFoundElementForUpdatingParameterInfo((PsiElement)elementForUpdating, context2);
            if (elementForUpdating != null) {
                this.executeUpdateParameterInfo((PsiElement)elementForUpdating, context2, () -> {
                    boolean knownParameter;
                    boolean bl = knownParameter = (this.myParameterInfoControllerData.getDescriptors().length == 1 || this.myParameterInfoControllerData.getHighlighted() != null) && this.myParameterInfoControllerData.getCurrentParameterIndex() != -1;
                    if (this.mySingleParameterInfo && !knownParameter && this.myHint.isVisible()) {
                        this.hideHint();
                    }
                    if (this.myKeepOnHintHidden && knownParameter && !this.myHint.isVisible()) {
                        AutoPopupController.getInstance(this.myProject).autoPopupParameterInfo(this.myEditor, null);
                    }
                    if (!this.myDisposed && (this.myHint.isVisible() && !this.myEditor.isDisposed() && (this.myEditor.getComponent().getRootPane() != null || ApplicationManager.getApplication().isUnitTestMode()) || ApplicationManager.getApplication().isHeadlessEnvironment())) {
                        ParameterInfoControllerBase.Model result2 = this.myComponent.update(this.mySingleParameterInfo);
                        result2.project = this.myProject;
                        result2.range = this.myParameterInfoControllerData.getParameterOwner().getTextRange();
                        result2.editor = this.myEditor;
                        for (ParameterInfoListener listener2 : ParameterInfoListener.EP_NAME.getExtensionList()) {
                            listener2.hintUpdated(result2);
                        }
                        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                            return;
                        }
                        IdeTooltip tooltip = this.myHint.getCurrentIdeTooltip();
                        short position = tooltip != null ? ParameterInfoController.toShort(tooltip.getPreferredPosition()) : (short)1;
                        Pair<Point, Short> pos = this.myProvider.getBestPointPosition(this.myHint, (PsiElement)elementForUpdating, caretOffset, this.myEditor.getCaretModel().getVisualPosition(), position);
                        HintManagerImpl.adjustEditorHintPosition((LightweightHint)this.myHint, (Editor)this.myEditor, (Point)pos.getFirst(), (short)pos.getSecond());
                    }
                });
            } else {
                this.hideHint();
                if (!this.myKeepOnHintHidden) {
                    Disposer.dispose(this);
                }
            }
        });
    }

    private void executeUpdateParameterInfo(PsiElement elementForUpdating, ParameterInfoControllerBase.UpdateParameterInfoContextBase context2, Runnable continuation) {
        PsiElement parameterOwner = context2.getParameterOwner();
        if (parameterOwner != null && !parameterOwner.equals(elementForUpdating)) {
            context2.removeHint();
            return;
        }
        ParameterInfoTaskRunnerUtil.runTask(this.myProject, ReadAction.nonBlocking(() -> {
            DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> this.myParameterInfoControllerData.getHandler().updateParameterInfo(elementForUpdating, context2));
            return elementForUpdating;
        }).withDocumentsCommitted(this.myProject).expireWhen(() -> !this.myKeepOnHintHidden && !this.myHint.isVisible() && !ApplicationManager.getApplication().isHeadlessEnvironment() || this.getCurrentOffset() != context2.getOffset() || !elementForUpdating.isValid()).expireWith(this), element -> {
            if (element != null && continuation != null) {
                context2.applyUIChanges();
                continuation.run();
            }
        }, null, this.myEditor);
    }

    @HintManager.PositionFlags
    private static short toShort(Balloon.Position position) {
        return switch (position) {
            case Balloon.Position.above -> 1;
            case Balloon.Position.atLeft -> 3;
            case Balloon.Position.atRight -> 4;
            default -> 2;
        };
    }

    @Override
    protected void moveToParameterAtOffset(int offset2) {
        PsiFile file2 = PsiDocumentManager.getInstance(this.myProject).getPsiFile(this.myEditor.getDocument());
        Object argsList = ParameterInfoController.findArgumentList(file2, offset2, -1);
        if (argsList == null && !CodeInsightSettings.getInstance().SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION) {
            return;
        }
        if (!this.myHint.isVisible()) {
            AutoPopupController.getInstance(this.myProject).autoPopupParameterInfo(this.myEditor, null);
        }
        offset2 = this.adjustOffsetToInlay(offset2);
        this.myEditor.getCaretModel().moveToOffset(offset2);
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        this.myEditor.getSelectionModel().removeSelection();
        if (argsList != null) {
            this.executeUpdateParameterInfo((PsiElement)argsList, new ParameterInfoControllerBase.UpdateParameterInfoContextBase(this, offset2, file2), null);
        }
    }

    private int adjustOffsetToInlay(int offset2) {
        CharSequence text2 = this.myEditor.getDocument().getImmutableCharSequence();
        int hostWhitespaceStart = CharArrayUtil.shiftBackward(text2, offset2, " \t") + 1;
        int hostWhitespaceEnd = CharArrayUtil.shiftForward(text2, offset2, " \t");
        Editor hostEditor = this.myEditor;
        if (this.myEditor instanceof EditorWindow) {
            hostEditor = ((EditorWindow)this.myEditor).getDelegate();
            hostWhitespaceStart = ((EditorWindow)this.myEditor).getDocument().injectedToHost(hostWhitespaceStart);
            hostWhitespaceEnd = ((EditorWindow)this.myEditor).getDocument().injectedToHost(hostWhitespaceEnd);
        }
        List<Inlay<?>> inlays = ParameterHintsPresentationManager.getInstance().getParameterHintsInRange(hostEditor, hostWhitespaceStart, hostWhitespaceEnd);
        for (Inlay<?> inlay : inlays) {
            int inlayOffset = inlay.getOffset();
            if (this.myEditor instanceof EditorWindow) {
                if (((EditorWindow)this.myEditor).getDocument().getHostRange(inlayOffset) == null) continue;
                inlayOffset = ((EditorWindow)this.myEditor).getDocument().hostToInjected(inlayOffset);
            }
            return inlayOffset;
        }
        return offset2;
    }

    @Override
    public void setPreservedOnHintHidden(boolean value) {
        this.myKeepOnHintHidden = value;
    }

    @Override
    public boolean isPreservedOnHintHidden() {
        return this.myKeepOnHintHidden;
    }

    static Pair<Point, Short> chooseBestHintPosition(Editor editor2, VisualPosition pos, LightweightHint hint, LookupImpl activeLookup, short preferredPosition, boolean showLookupHint) {
        boolean p2Ok;
        boolean p1Ok;
        Point p2;
        Point p1;
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return new Pair<Point, Short>(new Point(), (short)6);
        }
        HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
        Dimension hintSize = hint.getComponent().getPreferredSize();
        JComponent editorComponent = editor2.getComponent();
        JLayeredPane layeredPane2 = editorComponent.getRootPane().getLayeredPane();
        if (showLookupHint) {
            p1 = hintManager.getHintPosition(hint, editor2, (short)2);
            p2 = hintManager.getHintPosition(hint, editor2, (short)1);
        } else {
            p1 = HintManagerImpl.getHintPosition((LightweightHint)hint, (Editor)editor2, (VisualPosition)pos, (short)2);
            p2 = HintManagerImpl.getHintPosition((LightweightHint)hint, (Editor)editor2, (VisualPosition)pos, (short)1);
        }
        boolean isRealPopup = hint.isRealPopup();
        if (!showLookupHint && activeLookup != null && activeLookup.isShown()) {
            Rectangle lookupBounds = activeLookup.getBounds();
            p1Ok = p1.y + hintSize.height + 50 < layeredPane2.getHeight() && !ParameterInfoController.isHintIntersectWithLookup(p1, hintSize, lookupBounds, isRealPopup, (short)2);
            boolean bl = p2Ok = p2.y - hintSize.height - 70 >= 0 && !ParameterInfoController.isHintIntersectWithLookup(p2, hintSize, lookupBounds, isRealPopup, (short)1);
            if (activeLookup.isPositionedAboveCaret()) {
                if (!p1Ok) {
                    Point abovePoint = new Point(lookupBounds.x, lookupBounds.y - hintSize.height - 10);
                    SwingUtilities.convertPointToScreen(abovePoint, layeredPane2);
                    abovePoint.move(lookupBounds.x, lookupBounds.y - hintSize.height - 10);
                    hint.setForceShowAsPopup(true);
                    return new Pair<Point, Short>(abovePoint, (short)6);
                }
            } else if (!p2Ok) {
                Point underPoint = new Point(lookupBounds.x, lookupBounds.y + lookupBounds.height + 10);
                SwingUtilities.convertPointToScreen(underPoint, layeredPane2);
                Rectangle screenRectangle = new Rectangle(underPoint, hintSize);
                if (ParameterInfoController.isFitTheScreen(screenRectangle)) {
                    underPoint.move(lookupBounds.x, lookupBounds.y + lookupBounds.height + 10);
                    hint.setForceShowAsPopup(true);
                    return new Pair<Point, Short>(underPoint, (short)6);
                }
                hint.setForceShowAsPopup(true);
                Point abovePoint = new Point(p2.x - hintSize.width / 2, p2.y - hintSize.height);
                return new Pair<Point, Short>(abovePoint, (short)1);
            }
        } else {
            p1Ok = p1.y + hintSize.height < layeredPane2.getHeight();
            boolean bl = p2Ok = p2.y >= 0;
        }
        if (isRealPopup) {
            hint.setForceShowAsPopup(false);
        }
        if (!showLookupHint && preferredPosition != 6) {
            if (preferredPosition == 1) {
                if (p2Ok) {
                    return new Pair<Point, Short>(p2, (short)1);
                }
            } else if (preferredPosition == 2 && p1Ok) {
                return new Pair<Point, Short>(p1, (short)2);
            }
        }
        if (p1Ok) {
            return new Pair<Point, Short>(p1, (short)2);
        }
        if (p2Ok) {
            return new Pair<Point, Short>(p2, (short)1);
        }
        int aboveSpace = p2.y;
        int underSpace = layeredPane2.getHeight() - p1.y;
        return aboveSpace > underSpace ? new Pair<Point, Short>(new Point(p2.x, 0), (short)2) : new Pair<Point, Short>(p1, (short)1);
    }

    private static boolean isFitTheScreen(Rectangle aRectangle) {
        int screenX = aRectangle.x + aRectangle.width / 2;
        int screenY = aRectangle.y + aRectangle.height / 2;
        Rectangle screen = ScreenUtil.getScreenRectangle(screenX, screenY);
        return screen.contains(aRectangle);
    }

    private static boolean isHintIntersectWithLookup(Point hintPoint, Dimension hintSize, Rectangle lookupBounds, boolean isRealPopup, short hintPosition) {
        Point leftTopPoint = isRealPopup ? hintPoint : (hintPosition == 1 ? new Point(hintPoint.x - hintSize.width / 2, hintPoint.y - hintSize.height) : new Point(hintPoint.x - hintSize.width / 2, hintPoint.y));
        return lookupBounds.intersects(new Rectangle(leftTopPoint, hintSize));
    }

    @Override
    protected void hideHint() {
        this.myHint.hide();
        for (ParameterInfoListener listener2 : ParameterInfoListener.EP_NAME.getExtensionList()) {
            listener2.hintHidden(this.myProject);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/hint/ParameterInfoController";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createParameterInfoControllerData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyBestLocationPointProvider {
        private final Editor myEditor;
        private int previousOffset = -1;
        private Rectangle previousLookupBounds;
        private Dimension previousHintSize;
        private Point previousBestPoint;
        private Short previousBestPosition;

        MyBestLocationPointProvider(Editor editor2) {
            this.myEditor = editor2;
        }

        @NotNull
        private Pair<Point, Short> getBestPointPosition(LightweightHint hint, PsiElement list2, int offset2, VisualPosition pos, short preferredPosition) {
            boolean hintSizeChanged;
            TextRange range;
            TextRange rangeWithoutParens;
            if (list2 != null && !(rangeWithoutParens = TextRange.from((range = list2.getTextRange()).getStartOffset() + 1, Math.max(range.getLength() - 2, 0))).contains(offset2)) {
                offset2 = offset2 < rangeWithoutParens.getStartOffset() ? rangeWithoutParens.getStartOffset() : rangeWithoutParens.getEndOffset();
                pos = null;
            }
            LookupImpl activeLookup = (LookupImpl)LookupManager.getActiveLookup(this.myEditor);
            Rectangle lookupBounds = !ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManager.getApplication().isHeadlessEnvironment() && activeLookup != null && activeLookup.isShown() ? activeLookup.getBounds() : null;
            Dimension hintSize = hint.getSize();
            boolean lookupPositionChanged = lookupBounds != null && !lookupBounds.equals(this.previousLookupBounds);
            boolean bl = hintSizeChanged = !hintSize.equals(this.previousHintSize);
            if (this.previousOffset == offset2 && !lookupPositionChanged && !hintSizeChanged) {
                Pair<Point, Short> pair = Pair.create(this.previousBestPoint, this.previousBestPosition);
                if (pair == null) {
                    MyBestLocationPointProvider.$$$reportNull$$$0(0);
                }
                return pair;
            }
            Editor editor2 = this.myEditor;
            if (pos == null) {
                pos = EditorUtil.inlayAwareOffsetToVisualPosition((Editor)this.myEditor, (int)offset2);
                editor2 = this.myEditor instanceof EditorWindow ? ((EditorWindow)this.myEditor).getDelegate() : editor2;
            }
            Pair<Point, Short> position = ParameterInfoController.chooseBestHintPosition(editor2, pos, hint, activeLookup, preferredPosition, false);
            this.previousBestPoint = position.getFirst();
            this.previousBestPosition = position.getSecond();
            this.previousOffset = offset2;
            this.previousLookupBounds = lookupBounds;
            this.previousHintSize = hintSize;
            Pair<Point, Short> pair = position;
            if (pair == null) {
                MyBestLocationPointProvider.$$$reportNull$$$0(1);
            }
            return pair;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/ParameterInfoController$MyBestLocationPointProvider", "getBestPointPosition"));
        }
    }

    static class WrapperPanel
    extends JPanel {
        WrapperPanel() {
            super(new BorderLayout());
            this.setBorder(JBUI.Borders.empty());
        }

        @Override
        public Color getForeground() {
            return this.getComponentCount() == 0 ? super.getForeground() : this.getComponent(0).getForeground();
        }

        @Override
        public Color getBackground() {
            return this.getComponentCount() == 0 ? super.getBackground() : this.getComponent(0).getBackground();
        }

        @Override
        public Font getFont() {
            return this.getComponentCount() == 0 ? super.getFont() : this.getComponent(0).getFont();
        }

        @Override
        public String toString() {
            return this.getComponentCount() == 0 ? "<empty>" : this.getComponent(0).toString();
        }
    }
}

