/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.ParameterInfoControllerBase;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ParameterInfoControllerProvider {
    public static final ExtensionPointName<ParameterInfoControllerProvider> EP_NAME = new ExtensionPointName("com.intellij.codeInsight.parameterInfo.controller.provider");
    private static final Logger LOG = Logger.getInstance(ParameterInfoControllerProvider.class);
    private static Set<Editor> editorsWithControllers = null;

    @Nullable
    public final ParameterInfoControllerBase create(@NotNull Project project2, @NotNull Editor editor2, int lbraceOffset, Object[] descriptors, Object highlighted, PsiElement parameterOwner, @NotNull ParameterInfoHandler<? extends PsiElement, ?> handler2, boolean showHint2, boolean requestFocus) {
        ParameterInfoControllerBase infoControllerBase;
        if (project2 == null) {
            ParameterInfoControllerProvider.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            ParameterInfoControllerProvider.$$$reportNull$$$0(1);
        }
        if (handler2 == null) {
            ParameterInfoControllerProvider.$$$reportNull$$$0(2);
        }
        if ((infoControllerBase = this.doCreate(project2, editor2, lbraceOffset, descriptors, highlighted, parameterOwner, handler2, showHint2, requestFocus)) != null) {
            ParameterInfoControllerProvider.rememberEditor(editor2);
        }
        return infoControllerBase;
    }

    public static void rememberEditor(@NotNull Editor editor2) {
        if (editor2 == null) {
            ParameterInfoControllerProvider.$$$reportNull$$$0(3);
        }
        if (editorsWithControllers == null) {
            LOG.debug("create map of weak references to remember all editors with custom parameter info controllers and attach EP-listener");
            editorsWithControllers = ContainerUtil.createWeakSet();
            EP_NAME.addExtensionPointListener(new ExtensionPointListener<ParameterInfoControllerProvider>(){

                @Override
                public void extensionRemoved(@NotNull ParameterInfoControllerProvider extension2, @NotNull PluginDescriptor pluginDescriptor) {
                    if (extension2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (pluginDescriptor == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    ParameterInfoControllerProvider.removeControllersFromAllEditors();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "extension";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "pluginDescriptor";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/codeInsight/hint/ParameterInfoControllerProvider$1";
                    objectArray[2] = "extensionRemoved";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, null);
        }
        if (!editorsWithControllers.contains(editor2)) {
            LOG.debug("remember editor " + editor2);
            editorsWithControllers.add(editor2);
        }
    }

    public static void removeControllersFromAllEditors() {
        LOG.debug("remove all parameter info controllers from all editors because an extension was removed");
        for (Editor editor2 : editorsWithControllers) {
            if (editor2 == null) continue;
            for (ParameterInfoControllerBase controller : ParameterInfoControllerBase.getAllControllers(editor2)) {
                Disposer.dispose(controller);
            }
        }
    }

    @Nullable
    protected abstract ParameterInfoControllerBase doCreate(@NotNull Project var1, @NotNull Editor var2, int var3, Object[] var4, Object var5, PsiElement var6, @NotNull ParameterInfoHandler<? extends PsiElement, ?> var7, boolean var8, boolean var9);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/hint/ParameterInfoControllerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "rememberEditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

