/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.hint.ImplementationViewSession;
import com.intellij.codeInsight.hint.ImplementationViewSessionFactory;
import com.intellij.codeInsight.hint.PsiImplementationViewSession;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J@\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/codeInsight/hint/PsiImplementationSessionViewFactory;", "Lcom/intellij/codeInsight/hint/ImplementationViewSessionFactory;", "()V", "createSession", "Lcom/intellij/codeInsight/hint/ImplementationViewSession;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "project", "Lcom/intellij/openapi/project/Project;", "isSearchDeep", "", "alwaysIncludeSelf", "createSessionForLookupElement", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "lookupItemObject", "", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nImplementationViewSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImplementationViewSession.kt\ncom/intellij/codeInsight/hint/PsiImplementationSessionViewFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1#2:94\n*E\n"})
public final class PsiImplementationSessionViewFactory
implements ImplementationViewSessionFactory {
    @Override
    @Nullable
    public ImplementationViewSession createSession(@NotNull DataContext dataContext2, @NotNull Project project2, boolean isSearchDeep, boolean alwaysIncludeSelf) {
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return PsiImplementationViewSession.create(dataContext2, project2, isSearchDeep, alwaysIncludeSelf);
    }

    @Override
    @Nullable
    public ImplementationViewSession createSessionForLookupElement(@NotNull Project project2, @Nullable Editor editor2, @Nullable VirtualFile file2, @Nullable Object lookupItemObject, boolean isSearchDeep, boolean alwaysIncludeSelf) {
        PsiElement psiElement;
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        VirtualFile virtualFile2 = file2;
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl = false;
            v1 = PsiManager.getInstance(project2).findFile(it);
        } else {
            v1 = psiFile = null;
        }
        if ((psiElement = lookupItemObject instanceof PsiElement ? (PsiElement)lookupItemObject : null) == null) {
            psiElement = DocumentationManager.getInstance(project2).getElementFromLookup(editor2, psiFile);
        }
        PsiElement element = psiElement;
        PsiElement[] impls = new PsiElement[]{};
        String text2 = "";
        if (element != null) {
            PsiFile containingFile = element.getContainingFile();
            if (containingFile == null || !containingFile.getViewProvider().isPhysical()) {
                return null;
            }
            PsiElement[] psiElementArray = PsiImplementationViewSession.getSelfAndImplementations(editor2, element, PsiImplementationViewSession.createImplementationsSearcher(isSearchDeep));
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getSelfAndImplementation\u2026nsSearcher(isSearchDeep))");
            impls = psiElementArray;
            String string2 = SymbolPresentationUtil.getSymbolPresentableText(element);
            if (string2 == null) {
                PsiNamedElement psiNamedElement = element instanceof PsiNamedElement ? (PsiNamedElement)element : null;
                string2 = psiNamedElement != null ? psiNamedElement.getName() : null;
                if (string2 == null) {
                    String string3 = element.getText();
                    string2 = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"element.text");
                }
            }
            text2 = string2;
        }
        return new PsiImplementationViewSession(project2, element, impls, text2, editor2, file2, isSearchDeep, alwaysIncludeSelf);
    }
}

