/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.ElementLocationUtil;
import com.intellij.codeInsight.hint.ImplementationViewComponent;
import com.intellij.codeInsight.hint.ImplementationViewElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0014H\u0016R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\bR\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\bR\u0014\u0010\u001e\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\bR\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0012R\u0016\u0010%\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\b\u00a8\u0006*"}, d2={"Lcom/intellij/codeInsight/hint/PsiImplementationViewElement;", "Lcom/intellij/codeInsight/hint/ImplementationViewElement;", "psiElement", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)V", "containerPresentation", "", "getContainerPresentation", "()Ljava/lang/String;", "containingFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getContainingFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "containingMemberOrSelf", "getContainingMemberOrSelf", "()Lcom/intellij/codeInsight/hint/ImplementationViewElement;", "elementForShowUsages", "getElementForShowUsages", "()Lcom/intellij/psi/PsiElement;", "isNamed", "", "()Z", "locationIcon", "Ljavax/swing/Icon;", "getLocationIcon", "()Ljavax/swing/Icon;", "locationText", "getLocationText", "name", "getName", "presentableText", "getPresentableText", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getPsiElement", "text", "getText", "navigate", "", "focusEditor", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nImplementationViewElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImplementationViewElement.kt\ncom/intellij/codeInsight/hint/PsiImplementationViewElement\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n1#2:119\n*E\n"})
public final class PsiImplementationViewElement
extends ImplementationViewElement {
    @NotNull
    private final PsiElement psiElement;

    public PsiImplementationViewElement(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        this.psiElement = psiElement;
    }

    @NotNull
    public final PsiElement getPsiElement() {
        return this.psiElement;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project2 = this.psiElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"psiElement.project");
        return project2;
    }

    @Override
    public boolean isNamed() {
        return this.psiElement instanceof PsiNamedElement;
    }

    @Override
    @Nullable
    public String getName() {
        PsiElement psiElement = this.psiElement;
        PsiNamedElement psiNamedElement = psiElement instanceof PsiNamedElement ? (PsiNamedElement)psiElement : null;
        return psiNamedElement != null ? psiNamedElement.getName() : null;
    }

    @Override
    @Nullable
    public VirtualFile getContainingFile() {
        PsiFile psiFile = this.psiElement.getContainingFile();
        return psiFile != null && (psiFile = psiFile.getOriginalFile()) != null ? psiFile.getVirtualFile() : null;
    }

    @Override
    @Nullable
    public String getText() {
        return ImplementationViewComponent.getNewText(this.psiElement);
    }

    @Override
    @NotNull
    public String getPresentableText() {
        PsiElement psiElement = this.psiElement;
        NavigationItem navigationItem = psiElement instanceof NavigationItem ? (NavigationItem)((Object)psiElement) : null;
        ItemPresentation presentation2 = navigationItem != null ? navigationItem.getPresentation() : null;
        VirtualFile virtualFile2 = this.getContainingFile();
        if (virtualFile2 == null) {
            return "";
        }
        VirtualFile vFile = virtualFile2;
        String string2 = vFile.getPresentableName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"vFile.presentableName");
        String presentableName = string2;
        if (presentation2 == null) {
            return presentableName;
        }
        String elementPresentation = presentation2.getPresentableText();
        if (elementPresentation == null) {
            return presentableName;
        }
        return elementPresentation;
    }

    @Override
    @Nullable
    public String getContainerPresentation() {
        PsiElement psiElement = this.psiElement;
        Object object = psiElement instanceof NavigationItem ? (NavigationItem)((Object)psiElement) : null;
        if (object == null || (object = object.getPresentation()) == null) {
            return null;
        }
        Object presentation2 = object;
        return presentation2.getLocationString();
    }

    @Override
    @Nullable
    public String getLocationText() {
        return ElementLocationUtil.renderElementLocation(this.psiElement, new Ref());
    }

    @Override
    @Nullable
    public Icon getLocationIcon() {
        Ref ref;
        Ref it = ref = new Ref();
        boolean bl = false;
        ElementLocationUtil.renderElementLocation(this.psiElement, it);
        return (Icon)ref.get();
    }

    @Override
    @NotNull
    public ImplementationViewElement getContainingMemberOrSelf() {
        PsiElement parent2 = PsiTreeUtil.getStubOrPsiParent(this.psiElement);
        if (parent2 == null || parent2 instanceof PsiFile && Intrinsics.areEqual((Object)((PsiFile)parent2).getVirtualFile(), (Object)this.getContainingFile())) {
            return this;
        }
        return new PsiImplementationViewElement(parent2);
    }

    @Override
    public void navigate(boolean focusEditor) {
        PsiElement navigationElement = this.psiElement.getNavigationElement();
        PsiFile psiFile = navigationElement.getContainingFile();
        if (psiFile == null || (psiFile = psiFile.getOriginalFile()) == null) {
            return;
        }
        PsiFile file2 = psiFile;
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile virtualFile3 = virtualFile2;
        Project project2 = this.psiElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"psiElement.project");
        Project project3 = project2;
        FileEditorManagerEx fileEditorManager = FileEditorManagerEx.Companion.getInstanceEx(project3);
        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project3, virtualFile3, navigationElement.getTextOffset());
        fileEditorManager.openTextEditor(descriptor2, focusEditor);
    }

    @Override
    @Nullable
    public PsiElement getElementForShowUsages() {
        return !(this.psiElement instanceof PsiBinaryFile) ? this.psiElement : null;
    }
}

