/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.lang.ExpressionTypeProvider;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExpressionTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.ui.LightweightHint;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ShowExpressionTypeHandler
implements CodeInsightActionHandler {
    private final boolean myRequestFocus;

    public ShowExpressionTypeHandler(boolean requestFocus) {
        this.myRequestFocus = requestFocus;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void invoke(@NotNull Project project2, final @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (project2 == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Language language = PsiUtilCore.getLanguageAtOffset(file2, editor2.getCaretModel().getOffset());
        Set<ExpressionTypeProvider> handlers2 = ShowExpressionTypeHandler.getHandlers(project2, language, file2.getViewProvider().getBaseLanguage());
        if (handlers2.isEmpty()) {
            return;
        }
        final Map<PsiElement, ExpressionTypeProvider> map2 = ShowExpressionTypeHandler.getExpressions(file2, editor2, handlers2);
        Pass<PsiElement> callback = new Pass<PsiElement>(){

            @Override
            public void pass(@NotNull PsiElement expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                ExpressionTypeProvider provider2 = Objects.requireNonNull((ExpressionTypeProvider)map2.get(expression));
                TextRange range = expression.getTextRange();
                editor2.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
                ShowExpressionTypeHandler.this.displayHint(new DisplayedTypeInfo(expression, provider2, editor2), false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/hint/ShowExpressionTypeHandler$1", "pass"));
            }
        };
        if (map2.isEmpty()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                String errorHint = Objects.requireNonNull((ExpressionTypeProvider)ContainerUtil.getFirstItem(handlers2)).getErrorHint();
                Editor hostEditor = InjectedLanguageEditorUtil.getTopLevelEditor(editor2);
                HintManager.getInstance().showErrorHint(hostEditor, errorHint);
            });
        } else if (map2.size() == 1) {
            ExpressionTypeProvider provider2;
            Map.Entry<PsiElement, ExpressionTypeProvider> entry = map2.entrySet().iterator().next();
            PsiElement expression = entry.getKey();
            DisplayedTypeInfo typeInfo = new DisplayedTypeInfo(expression, provider2 = entry.getValue(), editor2);
            if (typeInfo.isRepeating() && provider2.hasAdvancedInformation()) {
                this.displayHint(typeInfo, true);
            } else {
                callback.pass(expression);
            }
        } else {
            IntroduceTargetChooser.showChooser(editor2, new ArrayList<PsiElement>(map2.keySet()), callback, PsiElement::getText);
        }
    }

    private void displayHint(@NotNull DisplayedTypeInfo typeInfo, boolean isAdvanced) {
        if (typeInfo == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(3);
        }
        Callable<@Nls String> getHintAction = () -> typeInfo.getHintText(isAdvanced);
        ReadAction.nonBlocking(getHintAction).finishOnUiThread(ModalityState.any(), hint -> {
            HintManager.getInstance().setRequestFocusForNextHint(this.myRequestFocus);
            typeInfo.showHint((String)hint);
        }).submit(AppExecutorUtil.getAppExecutorService());
    }

    @NotNull
    public Map<PsiElement, ExpressionTypeProvider> getExpressions(@NotNull PsiFile file2, @NotNull Editor editor2) {
        if (file2 == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(4);
        }
        if (editor2 == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(5);
        }
        Language language = PsiUtilCore.getLanguageAtOffset(file2, editor2.getCaretModel().getOffset());
        Set<ExpressionTypeProvider> handlers2 = ShowExpressionTypeHandler.getHandlers(file2.getProject(), language, file2.getViewProvider().getBaseLanguage());
        return ShowExpressionTypeHandler.getExpressions(file2, editor2, handlers2);
    }

    @NotNull
    private static Map<PsiElement, ExpressionTypeProvider> getExpressions(@NotNull PsiFile file2, @NotNull Editor editor2, @NotNull Set<? extends ExpressionTypeProvider> handlers2) {
        if (file2 == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(6);
        }
        if (editor2 == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(7);
        }
        if (handlers2 == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(8);
        }
        return ShowExpressionTypeHandler.getExpressions(file2, EditorUtil.getSelectionInAnyMode((Editor)editor2), editor2.getDocument(), handlers2);
    }

    @NotNull
    public static Map<PsiElement, ExpressionTypeProvider> getExpressions(@NotNull PsiFile file2, @NotNull TextRange range, @NotNull Document document, @NotNull Set<? extends ExpressionTypeProvider> handlers2) {
        if (file2 == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(9);
        }
        if (range == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(10);
        }
        if (document == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(11);
        }
        if (handlers2 == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(12);
        }
        if (handlers2.isEmpty()) {
            Map<PsiElement, ExpressionTypeProvider> map2 = Collections.emptyMap();
            if (map2 == null) {
                ShowExpressionTypeHandler.$$$reportNull$$$0(13);
            }
            return map2;
        }
        boolean exactRange = false;
        LinkedHashMap<PsiElement, ExpressionTypeProvider> map3 = new LinkedHashMap<PsiElement, ExpressionTypeProvider>();
        int offset2 = !range.isEmpty() ? range.getStartOffset() : TargetElementUtil.adjustOffset(file2, document, range.getStartOffset());
        for (int i2 = 0; i2 < 3 && map3.isEmpty() && offset2 >= i2; ++i2) {
            PsiElement elementAt2 = file2.findElementAt(offset2 - i2);
            if (elementAt2 == null) continue;
            for (ExpressionTypeProvider expressionTypeProvider : handlers2) {
                for (PsiElement element : expressionTypeProvider.getExpressionsAt(elementAt2)) {
                    TextRange r = element.getTextRange();
                    if (exactRange && !r.equals(range) || !r.contains(range)) continue;
                    if (!exactRange) {
                        exactRange = r.equals(range);
                    }
                    map3.put(element, expressionTypeProvider);
                }
            }
        }
        LinkedHashMap<PsiElement, ExpressionTypeProvider> linkedHashMap = map3;
        if (linkedHashMap == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(14);
        }
        return linkedHashMap;
    }

    @NotNull
    public static Set<ExpressionTypeProvider> getHandlers(Project project2, Language ... languages) {
        DumbService dumbService = DumbService.getInstance(project2);
        Set set2 = JBIterable.of(languages).flatten(language -> dumbService.filterByDumbAwareness(LanguageExpressionTypes.INSTANCE.allForLanguage((Language)language))).addAllTo(new LinkedHashSet());
        if (set2 == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(15);
        }
        return set2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeInfo";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlers";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/hint/ShowExpressionTypeHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/hint/ShowExpressionTypeHandler";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressions";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandlers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "displayHint";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getExpressions";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 13, 14, 15 -> new IllegalStateException(string2);
        };
    }

    static final class DisplayedTypeInfo {
        private static volatile DisplayedTypeInfo ourCurrentInstance;
        @NotNull
        final PsiElement myElement;
        @NotNull
        final ExpressionTypeProvider<PsiElement> myProvider;
        @NotNull
        final Editor myEditor;

        DisplayedTypeInfo(@NotNull PsiElement element, @NotNull ExpressionTypeProvider<PsiElement> provider2, @NotNull Editor editor2) {
            if (element == null) {
                DisplayedTypeInfo.$$$reportNull$$$0(0);
            }
            if (provider2 == null) {
                DisplayedTypeInfo.$$$reportNull$$$0(1);
            }
            if (editor2 == null) {
                DisplayedTypeInfo.$$$reportNull$$$0(2);
            }
            this.myElement = element;
            this.myProvider = provider2;
            this.myEditor = editor2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DisplayedTypeInfo info2 = (DisplayedTypeInfo)o;
            return Objects.equals(this.myElement, info2.myElement) && Objects.equals(this.myProvider, info2.myProvider) && Objects.equals(this.myEditor, info2.myEditor);
        }

        boolean isRepeating() {
            return this.equals(ourCurrentInstance);
        }

        @NlsContexts.HintText
        String getHintText(boolean isAdvanced) {
            if (isAdvanced) {
                return this.myProvider.getAdvancedInformationHint(this.myElement);
            }
            return this.myProvider.getInformationHint(this.myElement);
        }

        void showHint(@NlsContexts.HintText String informationHint) {
            JComponent label2 = HintUtil.createInformationLabel((String)informationHint);
            DisplayedTypeInfo.setInstance(this);
            AccessibleContextUtil.setName((Component)label2, CodeInsightBundle.message("accessible.name.expression.type.hint", new Object[0]));
            HintManagerImpl hintManager = (HintManagerImpl)HintManager.getInstance();
            LightweightHint hint = new LightweightHint(label2);
            hint.addHintListener(e -> ApplicationManager.getApplication().invokeLater(() -> DisplayedTypeInfo.setInstance(null)));
            Editor editorToShow = InjectedLanguageEditorUtil.getTopLevelEditor(this.myEditor);
            Point p = hintManager.getHintPosition(hint, editorToShow, (short)1);
            int flags = 42;
            hintManager.showEditorHint(hint, editorToShow, p, flags, 0, false);
        }

        private static void setInstance(DisplayedTypeInfo typeInfo) {
            ourCurrentInstance = typeInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "provider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/hint/ShowExpressionTypeHandler$DisplayedTypeInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

