/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.ParameterInfoControllerBase;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowParameterInfoContext
implements CreateParameterInfoContext {
    private final Editor myEditor;
    private final PsiFile myFile;
    private final Project myProject;
    private final int myOffset;
    private final int myParameterListStart;
    private final boolean mySingleParameterInfo;
    private PsiElement myHighlightedElement;
    private Object[] myItems;
    private boolean myRequestFocus;

    public ShowParameterInfoContext(Editor editor2, Project project2, PsiFile file2, int offset2, int parameterListStart) {
        this(editor2, project2, file2, offset2, parameterListStart, false);
    }

    public ShowParameterInfoContext(Editor editor2, Project project2, PsiFile file2, int offset2, int parameterListStart, boolean requestFocus) {
        this(editor2, project2, file2, offset2, parameterListStart, requestFocus, false);
    }

    public ShowParameterInfoContext(Editor editor2, Project project2, PsiFile file2, int offset2, int parameterListStart, boolean requestFocus, boolean singleParameterInfo) {
        this.myEditor = editor2;
        this.myProject = project2;
        this.myFile = file2;
        this.myParameterListStart = parameterListStart;
        this.myOffset = offset2;
        this.myRequestFocus = requestFocus;
        this.mySingleParameterInfo = singleParameterInfo;
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    @Override
    public PsiFile getFile() {
        return this.myFile;
    }

    @Override
    public int getOffset() {
        return this.myOffset;
    }

    @Override
    public int getParameterListStart() {
        return this.myParameterListStart;
    }

    @Override
    @NotNull
    public Editor getEditor() {
        Editor editor2 = this.myEditor;
        if (editor2 == null) {
            ShowParameterInfoContext.$$$reportNull$$$0(0);
        }
        return editor2;
    }

    @Override
    public PsiElement getHighlightedElement() {
        return this.myHighlightedElement;
    }

    @Override
    public void setHighlightedElement(PsiElement element) {
        this.myHighlightedElement = element;
    }

    @Override
    public void setItemsToShow(Object[] items2) {
        this.myItems = items2;
    }

    @Override
    public Object[] getItemsToShow() {
        return this.myItems;
    }

    @Override
    public void showHint(PsiElement element, int offset2, ParameterInfoHandler handler2) {
        Object[] itemsToShow = this.getItemsToShow();
        if (itemsToShow == null || itemsToShow.length == 0) {
            return;
        }
        ShowParameterInfoContext.showParameterHint(element, this.getEditor(), itemsToShow, this.getProject(), itemsToShow.length > 1 ? this.getHighlightedElement() : null, offset2, handler2, this.myRequestFocus, this.mySingleParameterInfo);
    }

    private static void showParameterHint(PsiElement element, Editor editor2, Object[] descriptors, Project project2, @Nullable PsiElement highlighted, int elementStart, ParameterInfoHandler<?, ?> handler2, boolean requestFocus, boolean singleParameterInfo) {
        if (editor2.isDisposed() || !editor2.getComponent().isVisible()) {
            return;
        }
        PsiDocumentManager.getInstance(project2).performLaterWhenAllCommitted(() -> {
            if (editor2.isDisposed() || !element.isValid() || !ApplicationManager.getApplication().isUnitTestMode() && !UIUtil.isShowing(editor2.getContentComponent())) {
                return;
            }
            Document document = editor2.getDocument();
            if (document.getTextLength() < elementStart) {
                return;
            }
            ParameterInfoControllerBase controller = ParameterInfoControllerBase.findControllerAtOffset(editor2, elementStart);
            if (controller == null) {
                ParameterInfoControllerBase.createParameterInfoController(project2, editor2, elementStart, descriptors, highlighted, element, handler2, true, requestFocus);
            } else {
                controller.setDescriptors(descriptors);
                controller.showHint(requestFocus, singleParameterInfo);
            }
        });
    }

    public void setRequestFocus(boolean requestFocus) {
        this.myRequestFocus = requestFocus;
    }

    public boolean isRequestFocus() {
        return this.myRequestFocus;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/ShowParameterInfoContext", "getEditor"));
    }
}

