/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hint.ParameterInfoTaskRunnerUtil;
import com.intellij.codeInsight.hint.ShowParameterInfoContext;
import com.intellij.lang.Language;
import com.intellij.lang.parameterInfo.LanguageParameterInfo;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.indexing.DumbModeAccessType;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowParameterInfoHandler
implements CodeInsightActionHandler {
    private static final ParameterInfoHandler[] EMPTY_HANDLERS = new ParameterInfoHandler[0];
    private final boolean myRequestFocus;

    public ShowParameterInfoHandler() {
        this(false);
    }

    public ShowParameterInfoHandler(boolean requestFocus) {
        this.myRequestFocus = requestFocus;
    }

    @Override
    public void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (project2 == null) {
            ShowParameterInfoHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            ShowParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            ShowParameterInfoHandler.$$$reportNull$$$0(2);
        }
        ShowParameterInfoHandler.invoke(project2, editor2, file2, -1, null, this.myRequestFocus);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    public static void invoke(Project project2, Editor editor2, PsiFile file2, int lbraceOffset, PsiElement highlightedElement, boolean requestFocus) {
        ShowParameterInfoHandler.invoke(project2, editor2, file2, lbraceOffset, highlightedElement, requestFocus, false, CodeInsightBundle.message("parameter.info.progress.title", new Object[0]));
    }

    @ApiStatus.Internal
    public static void invoke(Project project2, Editor editor2, PsiFile file2, int lbraceOffset, PsiElement highlightedElement, boolean requestFocus, boolean singleParameterHint, @Nullable @NlsContexts.ProgressTitle String progressTitle2) {
        int initialOffset = editor2.getCaretModel().getOffset();
        ParameterInfoTaskRunnerUtil.runTask(project2, ReadAction.nonBlocking(() -> {
            int offset2 = editor2.getCaretModel().getOffset();
            int fileLength = file2.getTextLength();
            if (fileLength == 0) {
                return null;
            }
            int offsetForLangDetection = offset2 > 0 && offset2 == fileLength ? offset2 - 1 : offset2;
            Language language = PsiUtilCore.getLanguageAtOffset(file2, offsetForLangDetection);
            ShowParameterInfoContext context2 = new ShowParameterInfoContext(editor2, project2, file2, offset2, lbraceOffset, requestFocus, singleParameterHint);
            context2.setHighlightedElement(highlightedElement);
            context2.setRequestFocus(requestFocus);
            ParameterInfoHandler[] handlers2 = ShowParameterInfoHandler.getHandlers(project2, language, file2.getViewProvider().getBaseLanguage());
            return (Runnable)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> {
                for (ParameterInfoHandler handler2 : handlers2) {
                    PsiElement element = (PsiElement)handler2.findElementForParameterInfo(context2);
                    if (element == null) continue;
                    return () -> DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> {
                        if (element.isValid()) {
                            handler2.showParameterInfo(element, context2);
                        }
                    });
                }
                return null;
            });
        }).withDocumentsCommitted(project2).expireWhen(() -> editor2.getCaretModel().getOffset() != initialOffset).coalesceBy(ShowParameterInfoHandler.class, editor2), continuation -> {
            if (continuation != null) {
                continuation.run();
            }
        }, progressTitle2, editor2);
    }

    public static ParameterInfoHandler @NotNull [] getHandlers(Project project2, Language ... languages) {
        if (languages == null) {
            ShowParameterInfoHandler.$$$reportNull$$$0(3);
        }
        LinkedHashSet handlers2 = new LinkedHashSet();
        DumbService dumbService = DumbService.getInstance(project2);
        for (Language language : languages) {
            handlers2.addAll(dumbService.filterByDumbAwareness(LanguageParameterInfo.INSTANCE.allForLanguage(language)));
        }
        ParameterInfoHandler[] parameterInfoHandlerArray = handlers2.isEmpty() ? EMPTY_HANDLERS : handlers2.toArray(new ParameterInfoHandler[0]);
        if (parameterInfoHandlerArray == null) {
            ShowParameterInfoHandler.$$$reportNull$$$0(4);
        }
        return parameterInfoHandlerArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languages";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/hint/ShowParameterInfoHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/hint/ShowParameterInfoHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandlers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getHandlers";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4 -> new IllegalStateException(string2);
        };
    }
}

