/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint.actions;

import com.intellij.codeInsight.hint.ImplementationViewComponent;
import com.intellij.codeInsight.hint.ImplementationViewElement;
import com.intellij.codeInsight.hint.ImplementationViewSession;
import com.intellij.codeInsight.hint.ImplementationViewSessionFactory;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.navigation.BackgroundUpdaterTaskBase;
import com.intellij.codeInsight.navigation.ImplementationSearcher;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.searcheverywhere.PSIPresentationBgRendererWrapper;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GenericListComponentUpdater;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupPositionManager;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageView;
import java.awt.Component;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class ShowRelatedElementsActionBase
extends DumbAwareAction
implements PopupAction {
    private Reference<JBPopup> myPopupRef;
    private Reference<ImplementationsUpdaterTask> myTaskRef;

    public ShowRelatedElementsActionBase() {
        this.setEnabledInModalContext(true);
        this.setInjectedContext(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowRelatedElementsActionBase.$$$reportNull$$$0(0);
        }
        this.performForContext(e.getDataContext(), true);
    }

    @TestOnly
    public void performForContext(DataContext dataContext2) {
        this.performForContext(dataContext2, true);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowRelatedElementsActionBase.$$$reportNull$$$0(1);
        }
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        e.getPresentation().setEnabled(project2 != null);
    }

    public void performForContext(@NotNull DataContext dataContext2, boolean invokedByShortcut) {
        Project project2;
        if (dataContext2 == null) {
            ShowRelatedElementsActionBase.$$$reportNull$$$0(2);
        }
        if ((project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2)) == null) {
            return;
        }
        PsiDocumentManager.getInstance(project2).commitAllDocuments();
        boolean isInvokedFromEditor = CommonDataKeys.EDITOR.getData(dataContext2) != null;
        try {
            for (ImplementationViewSessionFactory factory2 : this.getSessionFactories()) {
                ImplementationViewSession session = factory2.createSession(dataContext2, project2, this.isSearchDeep(), this.isIncludeAlwaysSelf());
                if (session == null) continue;
                ShowRelatedElementsActionBase.ensureValid(session, dataContext2);
                this.showImplementations(session, isInvokedFromEditor, invokedByShortcut);
            }
        }
        catch (IndexNotReadyException e) {
            DumbService.getInstance(project2).showDumbModeNotification(this.getIndexNotReadyMessage());
        }
    }

    @NotNull
    protected abstract List<ImplementationViewSessionFactory> getSessionFactories();

    @NotNull
    @NlsContexts.PopupContent
    protected abstract String getIndexNotReadyMessage();

    private void updateElementImplementations(Object lookupItemObject, ImplementationViewSession session) {
        ImplementationViewSessionFactory currentFactory;
        ImplementationViewSession newSession;
        if (lookupItemObject instanceof PSIPresentationBgRendererWrapper.PsiItemWithPresentation) {
            lookupItemObject = ((PSIPresentationBgRendererWrapper.PsiItemWithPresentation)lookupItemObject).getItem();
        }
        if ((newSession = this.createNewSession(currentFactory = session.getFactory(), session, lookupItemObject)) == null) {
            for (ImplementationViewSessionFactory factory2 : this.getSessionFactories()) {
                if (currentFactory != factory2 && (newSession = this.createNewSession(factory2, session, lookupItemObject)) != null) break;
            }
        }
        if (newSession != null) {
            ShowRelatedElementsActionBase.ensureValid(newSession, lookupItemObject);
            Disposer.dispose(session);
            this.showImplementations(newSession, false, false);
        }
    }

    private ImplementationViewSession createNewSession(ImplementationViewSessionFactory factory2, ImplementationViewSession session, Object lookupItemObject) {
        ShowRelatedElementsActionBase.ensureValid(session, lookupItemObject);
        return factory2.createSessionForLookupElement(session.getProject(), session.getEditor(), session.getFile(), lookupItemObject, this.isSearchDeep(), this.isIncludeAlwaysSelf());
    }

    protected void showImplementations(final @NotNull ImplementationViewSession session, boolean invokedFromEditor, boolean invokedByShortcut) {
        ImplementationViewComponent component3;
        VirtualFile secondContainingFile;
        VirtualFile containingFile;
        List<ImplementationViewElement> impls;
        if (session == null) {
            ShowRelatedElementsActionBase.$$$reportNull$$$0(3);
        }
        if ((impls = session.getImplementationElements()).size() == 0) {
            return;
        }
        Project project2 = session.getProject();
        this.triggerFeatureUsed(project2);
        VirtualFile virtualFile2 = session.getFile();
        int index2 = 0;
        if (invokedFromEditor && virtualFile2 != null && impls.size() > 1 && virtualFile2.equals(containingFile = impls.get(0).getContainingFile()) && (secondContainingFile = impls.get(1).getContainingFile()) != null && !secondContainingFile.equals(containingFile)) {
            index2 = 1;
        }
        Ref usageView = new Ref();
        String title = this.getPopupTitle(session);
        JBPopup popup2 = SoftReference.dereference(this.myPopupRef);
        if (popup2 != null && popup2.isVisible() && popup2 instanceof AbstractPopup && (component3 = (ImplementationViewComponent)((AbstractPopup)popup2).getComponent()) != null) {
            component3.update(impls, index2);
            this.updateInBackground(session, component3, (AbstractPopup)popup2, usageView);
            if (invokedByShortcut) {
                ((AbstractPopup)popup2).focusPreferredComponent();
            }
            return;
        }
        Consumer<ImplementationViewComponent> processor = this.couldPinPopup() ? component2 -> {
            usageView.set(component2.showInUsageView());
            this.myTaskRef = null;
        } : null;
        ImplementationViewComponent component4 = new ImplementationViewComponent(impls, index2, processor);
        if (component4.hasElementsToShow()) {
            PopupUpdateProcessor updateProcessor = new PopupUpdateProcessor(project2){

                public void updatePopup(Object lookupItemObject) {
                    ShowRelatedElementsActionBase.this.updateElementImplementations(lookupItemObject, session);
                }
            };
            ComponentPopupBuilder popupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)component4, component4.getPreferredFocusableComponent()).setProject(project2).addListener((JBPopupListener)updateProcessor).addUserData((Object)updateProcessor).setDimensionServiceKey(project2, "javadoc.popup", false).setResizable(true).setMovable(true).setRequestFocus(invokedFromEditor && LookupManager.getActiveLookup(session.getEditor()) == null).setCancelCallback(() -> {
                ImplementationsUpdaterTask task2 = SoftReference.dereference(this.myTaskRef);
                if (task2 != null) {
                    task2.cancelTask();
                }
                Disposer.dispose(session);
                return Boolean.TRUE;
            });
            WindowMoveListener listener2 = new WindowMoveListener();
            listener2.installTo((Component)component4);
            Disposer.register(session, () -> listener2.uninstallFrom((Component)component4));
            popup2 = popupBuilder.createPopup();
            this.updateInBackground(session, component4, (AbstractPopup)popup2, usageView);
            PopupPositionManager.positionPopupInBestPosition(popup2, session.getEditor(), DataManager.getInstance().getDataContext());
            component4.setHint(popup2, title);
            this.myPopupRef = new WeakReference<JBPopup>(popup2);
        }
    }

    protected void triggerFeatureUsed(@NotNull Project project2) {
        if (project2 == null) {
            ShowRelatedElementsActionBase.$$$reportNull$$$0(4);
        }
    }

    @NotNull
    @NlsContexts.PopupTitle
    protected abstract String getPopupTitle(@NotNull ImplementationViewSession var1);

    protected abstract boolean couldPinPopup();

    private void updateInBackground(@NotNull ImplementationViewSession session, @NotNull ImplementationViewComponent component2, @NotNull AbstractPopup popup2, @NotNull Ref<? extends UsageView> usageView) {
        ImplementationsUpdaterTask updaterTask;
        if (session == null) {
            ShowRelatedElementsActionBase.$$$reportNull$$$0(5);
        }
        if (component2 == null) {
            ShowRelatedElementsActionBase.$$$reportNull$$$0(6);
        }
        if (popup2 == null) {
            ShowRelatedElementsActionBase.$$$reportNull$$$0(7);
        }
        if (usageView == null) {
            ShowRelatedElementsActionBase.$$$reportNull$$$0(8);
        }
        if ((updaterTask = SoftReference.dereference(this.myTaskRef)) != null) {
            updaterTask.cancelTask();
        }
        if (!session.needUpdateInBackground()) {
            return;
        }
        ImplementationsUpdaterTask task2 = new ImplementationsUpdaterTask(session, component2);
        task2.init((JBPopup)popup2, new ImplementationViewComponentUpdater(component2, session.elementRequiresIncludeSelf() ? 1 : 0), usageView);
        this.myTaskRef = new WeakReference<ImplementationsUpdaterTask>(task2);
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task2, (ProgressIndicator)new BackgroundableProcessIndicator((Task.Backgroundable)task2));
    }

    protected boolean isIncludeAlwaysSelf() {
        return true;
    }

    protected boolean isSearchDeep() {
        return false;
    }

    private static void ensureValid(@NotNull ImplementationViewSession session, @Nullable Object context2) {
        if (session == null) {
            ShowRelatedElementsActionBase.$$$reportNull$$$0(9);
        }
        PsiFile contextFile = null;
        if (context2 instanceof DataContext) {
            DataContext dataContext2 = (DataContext)context2;
            contextFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext2);
        }
        if (context2 instanceof PsiElement) {
            PsiElement psiElement = (PsiElement)context2;
            contextFile = psiElement.getContainingFile();
        }
        VirtualFile contextVirtualFile = contextFile != null ? contextFile.getVirtualFile() : null;
        VirtualFile sessionVirtualFile = session.getFile();
        if (contextVirtualFile != null && contextVirtualFile.equals(sessionVirtualFile)) {
            PsiUtilCore.ensureValid(contextFile);
        } else if (sessionVirtualFile != null && !sessionVirtualFile.isValid()) {
            throw new InvalidVirtualFileAccessException(sessionVirtualFile);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/hint/actions/ShowRelatedElementsActionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "performForContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showImplementations";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerFeatureUsed";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "updateInBackground";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureValid";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ImplementationsUpdaterTask
    extends BackgroundUpdaterTaskBase<ImplementationViewElement> {
        private final ImplementationViewSession mySession;
        private final ImplementationViewComponent myComponent;
        private List<ImplementationViewElement> myElements;

        private ImplementationsUpdaterTask(ImplementationViewSession session, ImplementationViewComponent component2) {
            super(session.getProject(), ImplementationSearcher.getSearchingForImplementations(), null);
            this.mySession = session;
            this.myComponent = component2;
        }

        @Override
        public String getCaption(int size) {
            return null;
        }

        @Override
        protected Usage createUsage(ImplementationViewElement element) {
            return element.getUsage();
        }

        @Override
        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                ImplementationsUpdaterTask.$$$reportNull$$$0(0);
            }
            super.run(indicator);
            this.myElements = this.mySession.searchImplementationsInBackground(indicator, this::updateComponent);
        }

        @Override
        public int getCurrentSize() {
            if (this.myElements != null) {
                return this.myElements.size();
            }
            return super.getCurrentSize();
        }

        @Override
        public void onSuccess() {
            if (!this.cancelTask()) {
                this.myComponent.update(this.myElements, this.myComponent.getIndex());
            }
            super.onSuccess();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInsight/hint/actions/ShowRelatedElementsActionBase$ImplementationsUpdaterTask", "run"));
        }
    }

    private static class ImplementationViewComponentUpdater
    implements GenericListComponentUpdater<ImplementationViewElement> {
        private final ImplementationViewComponent myComponent;
        private final int myIncludeSelfIdx;

        ImplementationViewComponentUpdater(ImplementationViewComponent component2, int includeSelfIdx) {
            this.myComponent = component2;
            this.myIncludeSelfIdx = includeSelfIdx;
        }

        public void paintBusy(boolean paintBusy) {
        }

        public void replaceModel(@NotNull List<? extends ImplementationViewElement> data2) {
            if (data2 == null) {
                ImplementationViewComponentUpdater.$$$reportNull$$$0(0);
            }
            ImplementationViewElement[] elements = this.myComponent.getElements();
            int startIdx = elements.length - this.myIncludeSelfIdx;
            ArrayList<? extends ImplementationViewElement> result2 = new ArrayList<ImplementationViewElement>();
            Collections.addAll(result2, elements);
            result2.addAll(data2.subList(startIdx, data2.size()));
            this.myComponent.update(result2, this.myComponent.getIndex());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/codeInsight/hint/actions/ShowRelatedElementsActionBase$ImplementationViewComponentUpdater", "replaceModel"));
        }
    }
}

