/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.hints.CollectorWithSettings;
import com.intellij.codeInsight.hints.HintsBuffer;
import com.intellij.codeInsight.hints.InlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsPass;
import com.intellij.codeInsight.hints.InlayHintsSinkImpl;
import com.intellij.codeInsight.hints.InlayHintsUtilsKt;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.TextAttributesEffectsBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u0019J\u001e\u0010 \u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u001dJ\u001e\u0010\"\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u001dJ\u001e\u0010#\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u001dR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006$"}, d2={"Lcom/intellij/codeInsight/hints/CollectorWithSettings;", "T", "", "collector", "Lcom/intellij/codeInsight/hints/InlayHintsCollector;", "key", "Lcom/intellij/codeInsight/hints/SettingsKey;", "language", "Lcom/intellij/lang/Language;", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSinkImpl;", "(Lcom/intellij/codeInsight/hints/InlayHintsCollector;Lcom/intellij/codeInsight/hints/SettingsKey;Lcom/intellij/lang/Language;Lcom/intellij/codeInsight/hints/InlayHintsSinkImpl;)V", "getCollector", "()Lcom/intellij/codeInsight/hints/InlayHintsCollector;", "getKey", "()Lcom/intellij/codeInsight/hints/SettingsKey;", "getLanguage", "()Lcom/intellij/lang/Language;", "getSink", "()Lcom/intellij/codeInsight/hints/InlayHintsSinkImpl;", "applyToEditor", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "hintsBuffer", "Lcom/intellij/codeInsight/hints/HintsBuffer;", "collectHints", "", "element", "Lcom/intellij/psi/PsiElement;", "collectTraversing", "enabled", "collectTraversingAndApply", "collectTraversingAndApplyOnEdt", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nInlayHintsUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlayHintsUtils.kt\ncom/intellij/codeInsight/hints/CollectorWithSettings\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,309:1\n1855#2,2:310\n*S KotlinDebug\n*F\n+ 1 InlayHintsUtils.kt\ncom/intellij/codeInsight/hints/CollectorWithSettings\n*L\n120#1:310,2\n*E\n"})
public final class CollectorWithSettings<T> {
    @NotNull
    private final InlayHintsCollector collector;
    @NotNull
    private final SettingsKey<T> key;
    @NotNull
    private final Language language;
    @NotNull
    private final InlayHintsSinkImpl sink;

    public CollectorWithSettings(@NotNull InlayHintsCollector collector2, @NotNull SettingsKey<T> key, @NotNull Language language, @NotNull InlayHintsSinkImpl sink) {
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        this.collector = collector2;
        this.key = key;
        this.language = language;
        this.sink = sink;
    }

    @NotNull
    public final InlayHintsCollector getCollector() {
        return this.collector;
    }

    @NotNull
    public final SettingsKey<T> getKey() {
        return this.key;
    }

    @NotNull
    public final Language getLanguage() {
        return this.language;
    }

    @NotNull
    public final InlayHintsSinkImpl getSink() {
        return this.sink;
    }

    public final boolean collectHints(@NotNull PsiElement element, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return this.collector.collect(element, editor2, this.sink);
    }

    public final void collectTraversingAndApply(@NotNull Editor editor2, @NotNull PsiFile file2, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        HintsBuffer hintsBuffer = this.collectTraversing(editor2, file2, enabled);
        this.applyToEditor(file2, editor2, hintsBuffer);
    }

    public final void collectTraversingAndApplyOnEdt(@NotNull Editor editor2, @NotNull PsiFile file2, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        HintsBuffer hintsBuffer = this.collectTraversing(editor2, file2, true);
        if (!enabled) {
            TextAttributesEffectsBuilder builder2 = InlayHintsUtilsKt.strikeOutBuilder(editor2);
            InlayHintsUtilsKt.addStrikeout(hintsBuffer.getInlineHints(), builder2, collectTraversingAndApplyOnEdt.1.INSTANCE);
            InlayHintsUtilsKt.addStrikeout(hintsBuffer.getBlockAboveHints$intellij_platform_lang_impl(), builder2, collectTraversingAndApplyOnEdt.2.INSTANCE);
            InlayHintsUtilsKt.addStrikeout(hintsBuffer.getBlockBelowHints$intellij_platform_lang_impl(), builder2, collectTraversingAndApplyOnEdt.3.INSTANCE);
        }
        ActionsKt.invokeLater$default(null, (Function0)new Function0<Unit>(this, file2, editor2, hintsBuffer){
            final /* synthetic */ CollectorWithSettings<T> this$0;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ HintsBuffer $hintsBuffer;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                this.$editor = $editor;
                this.$hintsBuffer = $hintsBuffer;
                super(0);
            }

            public final void invoke() {
                this.this$0.applyToEditor(this.$file, this.$editor, this.$hintsBuffer);
            }
        }, 1, null);
    }

    @NotNull
    public final HintsBuffer collectTraversing(@NotNull Editor editor2, @NotNull PsiFile file2, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (enabled) {
            SyntaxTraverser<PsiElement> syntaxTraverser = SyntaxTraverser.psiTraverser(file2);
            Intrinsics.checkNotNullExpressionValue(syntaxTraverser, (String)"psiTraverser(file)");
            SyntaxTraverser<PsiElement> traverser = syntaxTraverser;
            Iterable $this$forEach$iv = traverser;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                this.collectHints(it, editor2);
            }
        }
        return this.sink.complete$intellij_platform_lang_impl();
    }

    public final void applyToEditor(@NotNull PsiFile file2, @NotNull Editor editor2, @NotNull HintsBuffer hintsBuffer) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)hintsBuffer, (String)"hintsBuffer");
        InlayHintsPass.Companion.applyCollected$intellij_platform_lang_impl$default(InlayHintsPass.Companion, hintsBuffer, file2, editor2, false, 8, null);
    }
}

