/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.HintUtilsKt;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.PopupActionsKt;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016J!\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016R\u0012\u0010\u0004\u001a\u00020\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/codeInsight/hints/EnableCustomHintsOption;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "()V", "lastOptionName", "", "getDisabledOptionInfoAtCaretOffset", "Lcom/intellij/codeInsight/hints/HintInfo$OptionInfo;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "isAvailable", "", "startInWriteAction", "intellij.platform.lang.impl"})
public final class EnableCustomHintsOption
implements IntentionAction,
HighPriorityAction {
    @IntentionName
    @NotNull
    private String lastOptionName = "";

    @Override
    @NotNull
    public String getText() {
        String string2 = CodeInsightBundle.message("inlay.hints.enable.option.shortening_rule", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"inlay.hints.ena\u2026.option.shortening_rule\")");
        String optionPrefix = StringsKt.replace$default((String)string2, (char)'|', (char)' ', (boolean)false, (int)4, null);
        if (!StringsKt.isBlank((CharSequence)optionPrefix) && StringsKt.startsWith$default((String)this.lastOptionName, (String)optionPrefix, (boolean)false, (int)2, null)) {
            return this.lastOptionName;
        }
        Object[] objectArray = new Object[]{this.lastOptionName};
        String string3 = CodeInsightBundle.message("inlay.hints.enable.option", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"inlay.hints.ena\u2026.option\", lastOptionName)");
        return string3;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string2 = CodeInsightBundle.message("inlay.hints.intention.family.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"inlay.hints.intention.family.name\")");
        return string2;
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Language language = file2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"file.language");
        Language language2 = language;
        if (!HintUtilsKt.isParameterHintsEnabledForLanguage(language2)) {
            return false;
        }
        if (!(editor2 instanceof EditorImpl)) {
            return false;
        }
        if ((InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(file2.getLanguage()) == null) {
            return false;
        }
        HintInfo.OptionInfo optionInfo = this.getDisabledOptionInfoAtCaretOffset(editor2, file2);
        if (optionInfo == null) {
            return false;
        }
        HintInfo.OptionInfo option = optionInfo;
        this.lastOptionName = option.getOptionName();
        return true;
    }

    private final HintInfo.OptionInfo getDisabledOptionInfoAtCaretOffset(Editor editor2, PsiFile file2) {
        int offset2 = editor2.getCaretModel().getOffset();
        PsiElement psiElement = file2.findElementAt(offset2);
        if (psiElement == null) {
            return null;
        }
        PsiElement element = psiElement;
        InlayParameterHintsProvider inlayParameterHintsProvider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(file2.getLanguage());
        if (inlayParameterHintsProvider == null) {
            return null;
        }
        InlayParameterHintsProvider provider2 = inlayParameterHintsProvider;
        PsiElement target2 = PsiTreeUtil.findFirstParent(element, arg_0 -> EnableCustomHintsOption.getDisabledOptionInfoAtCaretOffset$lambda$0((Function1)new Function1<PsiElement, Boolean>(provider2, file2){
            final /* synthetic */ InlayParameterHintsProvider $provider;
            final /* synthetic */ PsiFile $file;
            {
                this.$provider = $provider;
                this.$file = $file;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(PsiElement it) {
                boolean bl;
                if (!(it instanceof PsiFile)) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!PopupActionsKt.access$hasDisabledOptionHintInfo(this.$provider, it, this.$file)) {
                        bl = false;
                        return bl;
                    }
                }
                bl = true;
                return bl;
            }
        }, arg_0));
        if (target2 == null || target2 instanceof PsiFile) {
            return null;
        }
        HintInfo hintInfo = provider2.getHintInfo(target2, file2);
        return hintInfo instanceof HintInfo.OptionInfo ? (HintInfo.OptionInfo)hintInfo : null;
    }

    @Override
    public void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        HintInfo.OptionInfo optionInfo = this.getDisabledOptionInfoAtCaretOffset(editor2, file2);
        if (optionInfo == null) {
            return;
        }
        HintInfo.OptionInfo option = optionInfo;
        option.enable();
        PopupActionsKt.access$refreshAllOpenEditors();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    private static final boolean getDisabledOptionInfoAtCaretOffset$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

