/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hints.ExcludeListPanelKt;
import com.intellij.codeInsight.hints.HintUtilsKt;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.ParameterHintsPassFactory;
import com.intellij.codeInsight.hints.settings.Diff;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettings;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\u0011\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/codeInsight/hints/ExcludeListDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "language", "Lcom/intellij/lang/Language;", "patternToAdd", "", "(Lcom/intellij/lang/Language;Ljava/lang/String;)V", "getLanguage", "()Lcom/intellij/lang/Language;", "myEditor", "Lcom/intellij/ui/EditorTextField;", "getMyEditor", "()Lcom/intellij/ui/EditorTextField;", "setMyEditor", "(Lcom/intellij/ui/EditorTextField;)V", "myPatternsAreValid", "", "baseLanguageComment", "Lorg/jetbrains/annotations/Nls;", "provider", "Lcom/intellij/codeInsight/hints/InlayParameterHintsProvider;", "createCenterPanel", "Ljavax/swing/JComponent;", "createExcludePanel", "Ljavax/swing/JPanel;", "doOKAction", "", "setLanguageExcludelistToDefault", "storeExcludeListDiff", "text", "updateOkEnabled", "editorTextField", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nExcludeListPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExcludeListPanel.kt\ncom/intellij/codeInsight/hints/ExcludeListDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,166:1\n1#2:167\n766#3:168\n857#3:169\n858#3:193\n107#4:170\n79#4,22:171\n*S KotlinDebug\n*F\n+ 1 ExcludeListPanel.kt\ncom/intellij/codeInsight/hints/ExcludeListDialog\n*L\n119#1:168\n119#1:169\n119#1:193\n119#1:170\n119#1:171,22\n*E\n"})
public final class ExcludeListDialog
extends DialogWrapper {
    @NotNull
    private final Language language;
    @Nullable
    private final String patternToAdd;
    public EditorTextField myEditor;
    private boolean myPatternsAreValid;

    public ExcludeListDialog(@NotNull Language language, @Nullable String patternToAdd) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        super(null);
        this.language = language;
        this.patternToAdd = patternToAdd;
        this.myPatternsAreValid = true;
        this.setTitle(CodeInsightBundle.message("settings.inlay.parameter.hints.exclude.list", new Object[0]));
        this.init();
    }

    public /* synthetic */ ExcludeListDialog(Language language, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(language, string2);
    }

    @NotNull
    public final Language getLanguage() {
        return this.language;
    }

    @NotNull
    public final EditorTextField getMyEditor() {
        EditorTextField editorTextField2 = this.myEditor;
        if (editorTextField2 != null) {
            return editorTextField2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"myEditor");
        return null;
    }

    public final void setMyEditor(@NotNull EditorTextField editorTextField2) {
        Intrinsics.checkNotNullParameter((Object)editorTextField2, (String)"<set-?>");
        this.myEditor = editorTextField2;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.createExcludePanel(this.language);
    }

    private final JPanel createExcludePanel(Language language) {
        InlayParameterHintsProvider provider2 = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (!provider2.isBlackListSupported()) {
            return null;
        }
        String blackList = ExcludeListPanelKt.access$getLanguageExcludeList(language);
        String finalText = this.patternToAdd != null ? blackList + "\n" + this.patternToAdd : blackList;
        EditorTextField editorTextField2 = ExcludeListPanelKt.access$createExcludeListEditorField(finalText);
        editorTextField2.setAlignmentX(0.0f);
        editorTextField2.addDocumentListener(new DocumentListener(this, editorTextField2){
            final /* synthetic */ ExcludeListDialog this$0;
            final /* synthetic */ EditorTextField $editorTextField;
            {
                this.this$0 = $receiver;
                this.$editorTextField = $editorTextField;
            }

            public void documentChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ExcludeListDialog.access$updateOkEnabled(this.this$0, this.$editorTextField);
            }
        });
        this.updateOkEnabled(editorTextField2);
        this.setMyEditor(editorTextField2);
        return (JPanel)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this, provider2, language, editorTextField2){
            final /* synthetic */ ExcludeListDialog this$0;
            final /* synthetic */ InlayParameterHintsProvider $provider;
            final /* synthetic */ Language $language;
            final /* synthetic */ EditorTextField $editorTextField;
            {
                this.this$0 = $receiver;
                this.$provider = $provider;
                this.$language = $language;
                this.$editorTextField = $editorTextField;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0, this.$language){
                    final /* synthetic */ ExcludeListDialog this$0;
                    final /* synthetic */ Language $language;
                    {
                        this.this$0 = $receiver;
                        this.$language = $language;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string2 = LangBundle.message("action.link.reset", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"action.link.reset\")");
                        $this$row.link(string2, (Function1)new Function1<ActionEvent, Unit>(this.this$0, this.$language){
                            final /* synthetic */ ExcludeListDialog this$0;
                            final /* synthetic */ Language $language;
                            {
                                this.this$0 = $receiver;
                                this.$language = $language;
                                super(1);
                            }

                            public final void invoke(@NotNull ActionEvent it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                ExcludeListDialog.access$setLanguageExcludelistToDefault(this.this$0, this.$language);
                            }
                        }).align((Align)AlignX.RIGHT.INSTANCE);
                    }
                }), (int)1, null);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$editorTextField){
                    final /* synthetic */ EditorTextField $editorTextField;
                    {
                        this.$editorTextField = $editorTextField;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)this.$editorTextField).align((Align)AlignX.FILL.INSTANCE);
                    }
                }), (int)1, null).bottomGap(BottomGap.SMALL);
                InlayParameterHintsProvider inlayParameterHintsProvider = this.$provider;
                Intrinsics.checkNotNullExpressionValue((Object)inlayParameterHintsProvider, (String)"provider");
                String string2 = ExcludeListDialog.access$baseLanguageComment(this.this$0, inlayParameterHintsProvider);
                if (string2 != null) {
                    String it = string2;
                    boolean bl = false;
                    Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(it){
                        final /* synthetic */ String $it;
                        {
                            this.$it = $it;
                            super(1);
                        }

                        public final void invoke(@NotNull Row $this$row) {
                            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                            Row.comment$default((Row)$this$row, (String)this.$it, (int)0, null, (int)6, null);
                        }
                    }), (int)1, null);
                }
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$language){
                    final /* synthetic */ Language $language;
                    {
                        this.$language = $language;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        Row.comment$default((Row)$this$row, (String)ExcludeListPanelKt.access$getExcludeListExplanationHTML(this.$language), (int)0, null, (int)6, null);
                    }
                }), (int)1, null);
            }
        }));
    }

    private final String baseLanguageComment(InlayParameterHintsProvider provider2) {
        String string2;
        Language language = provider2.getBlackListDependencyLanguage();
        if (language != null) {
            Language it = language;
            boolean bl = false;
            Object[] objectArray = new Object[]{it.getDisplayName()};
            string2 = CodeInsightBundle.message("inlay.hints.base.exclude.list.description", objectArray);
        } else {
            string2 = null;
        }
        return string2;
    }

    private final void setLanguageExcludelistToDefault(Language language) {
        InlayParameterHintsProvider provider2;
        InlayParameterHintsProvider inlayParameterHintsProvider = provider2 = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        Intrinsics.checkNotNull((Object)inlayParameterHintsProvider);
        Set<String> set2 = inlayParameterHintsProvider.getDefaultBlackList();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"provider!!.defaultBlackList");
        Set<String> defaultExcludeList = set2;
        this.getMyEditor().setText(StringUtil.join((Collection<String>)defaultExcludeList, "\n"));
    }

    private final void updateOkEnabled(EditorTextField editorTextField2) {
        String string2 = editorTextField2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"editorTextField.text");
        String text2 = string2;
        List<Integer> invalidLines = HintUtilsKt.getExcludeListInvalidLineNumbers(text2);
        this.myPatternsAreValid = invalidLines.isEmpty();
        this.getOKAction().setEnabled(this.myPatternsAreValid);
        Editor editor2 = editorTextField2.getEditor();
        if (editor2 != null) {
            ExcludeListPanelKt.access$highlightErrorLines(invalidLines, editor2);
        }
    }

    protected void doOKAction() {
        super.doOKAction();
        String string2 = this.getMyEditor().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"myEditor.text");
        String excludeList = string2;
        this.storeExcludeListDiff(this.language, excludeList);
    }

    /*
     * WARNING - void declaration
     */
    private final void storeExcludeListDiff(Language language, String text2) {
        void $this$filterTo$iv$iv;
        String[] stringArray = new String[]{"\n"};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)text2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String e = (String)element$iv$iv;
            boolean bl = false;
            String $this$trim$iv = e;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl2 = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            boolean bl4 = ((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() > 0;
            if (!bl4) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set updatedExcludeList = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        InlayParameterHintsProvider provider2 = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        Set<String> set2 = provider2.getDefaultBlackList();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"provider.defaultBlackList");
        Set<String> defaultExcludeList = set2;
        Diff diff = Diff.Builder.build(defaultExcludeList, updatedExcludeList);
        ParameterNameHintsSettings.Companion.getInstance().setExcludeListDiff(HintUtilsKt.getLanguageForSettingKey(language), diff);
        ParameterHintsPassFactory.forceHintsUpdateOnNextPass();
    }

    public static final /* synthetic */ void access$updateOkEnabled(ExcludeListDialog $this, EditorTextField editorTextField2) {
        $this.updateOkEnabled(editorTextField2);
    }

    public static final /* synthetic */ void access$setLanguageExcludelistToDefault(ExcludeListDialog $this, Language language) {
        $this.setLanguageExcludelistToDefault(language);
    }

    public static final /* synthetic */ String access$baseLanguageComment(ExcludeListDialog $this, InlayParameterHintsProvider provider2) {
        return $this.baseLanguageComment(provider2);
    }
}

