/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hints.HintUtilsKt;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.settings.Diff;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettings;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0003\u001a\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001e\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"createExcludeListEditorField", "Lcom/intellij/ui/EditorTextField;", "text", "", "getExcludeListExplanationHTML", "language", "Lcom/intellij/lang/Language;", "getLanguageExcludeList", "highlightErrorLines", "", "lines", "", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.platform.lang.impl"})
public final class ExcludeListPanelKt {
    private static final String getLanguageExcludeList(Language language) {
        InlayParameterHintsProvider inlayParameterHintsProvider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (inlayParameterHintsProvider == null) {
            return "";
        }
        InlayParameterHintsProvider hintsProvider = inlayParameterHintsProvider;
        Diff diff = ParameterNameHintsSettings.Companion.getInstance().getExcludeListDiff(HintUtilsKt.getLanguageForSettingKey(language));
        Set<String> set2 = hintsProvider.getDefaultBlackList();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"hintsProvider.defaultBlackList");
        Set<String> excludeList = diff.applyOn(set2);
        String string2 = StringUtil.join((Collection<String>)excludeList, "\n");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"join(excludeList, \"\\n\")");
        return string2;
    }

    private static final EditorTextField createExcludeListEditorField(String text2) {
        Document document = EditorFactory.getInstance().createDocument((CharSequence)text2);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getInstance().createDocument(text)");
        Document document2 = document;
        EditorTextField field = new EditorTextField(document2, null, (FileType)FileTypes.PLAIN_TEXT, false, false);
        field.setPreferredSize(new Dimension(400, 350));
        field.addSettingsProvider(arg_0 -> ExcludeListPanelKt.createExcludeListEditorField$lambda$0(text2, arg_0));
        return field;
    }

    private static final void highlightErrorLines(List<Integer> lines2, Editor editor2) {
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        int totalLines = document2.getLineCount();
        MarkupModel markupModel = editor2.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModel, (String)"editor.markupModel");
        MarkupModel model2 = markupModel;
        model2.removeAllHighlighters();
        lines2.stream().filter(arg_0 -> ExcludeListPanelKt.highlightErrorLines$lambda$1((Function1)new Function1<Integer, Boolean>(totalLines){
            final /* synthetic */ int $totalLines;
            {
                this.$totalLines = $totalLines;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Integer current) {
                Intrinsics.checkNotNullExpressionValue((Object)current, (String)"current");
                return current < this.$totalLines;
            }
        }, arg_0)).forEach(arg_0 -> ExcludeListPanelKt.highlightErrorLines$lambda$2((Function1)new Function1<Integer, Unit>(model2){
            final /* synthetic */ MarkupModel $model;
            {
                this.$model = $model;
                super(1);
            }

            public final void invoke(Integer line) {
                Integer n = line;
                Intrinsics.checkNotNull((Object)n);
                this.$model.addLineHighlighter(CodeInsightColors.ERRORS_ATTRIBUTES, n.intValue(), 5000);
            }
        }, arg_0));
    }

    @NlsContexts.DetailedDescription
    private static final String getExcludeListExplanationHTML(Language language) {
        InlayParameterHintsProvider inlayParameterHintsProvider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (inlayParameterHintsProvider == null) {
            String string2 = CodeInsightBundle.message("inlay.hints.exclude.list.pattern.explanation", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\n    \"inlay.hint\u2026ist.pattern.explanation\")");
            return string2;
        }
        InlayParameterHintsProvider hintsProvider = inlayParameterHintsProvider;
        String string3 = hintsProvider.getBlacklistExplanationHTML();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"hintsProvider.blacklistExplanationHTML");
        return string3;
    }

    private static final void createExcludeListEditorField$lambda$0(String $text, EditorEx editor2) {
        Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
        editor2.setVerticalScrollbarVisible(true);
        editor2.setHorizontalScrollbarVisible(true);
        editor2.getSettings().setAdditionalLinesCount(2);
        List<Integer> list2 = HintUtilsKt.getExcludeListInvalidLineNumbers($text);
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"editor");
        ExcludeListPanelKt.highlightErrorLines(list2, (Editor)editor2);
    }

    private static final boolean highlightErrorLines$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void highlightErrorLines$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$getLanguageExcludeList(Language language) {
        return ExcludeListPanelKt.getLanguageExcludeList(language);
    }

    public static final /* synthetic */ EditorTextField access$createExcludeListEditorField(String text2) {
        return ExcludeListPanelKt.createExcludeListEditorField(text2);
    }

    public static final /* synthetic */ String access$getExcludeListExplanationHTML(Language language) {
        return ExcludeListPanelKt.getExcludeListExplanationHTML(language);
    }

    public static final /* synthetic */ void access$highlightErrorLines(List lines2, Editor editor2) {
        ExcludeListPanelKt.highlightErrorLines(lines2, editor2);
    }
}

