/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.hints.HintUtilsKt;
import com.intellij.codeInsight.hints.InlayHintsSettings;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettings;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u001a\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b\u001a\u0018\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b0\n0\u0004\u001a\u000e\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002\u001a\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0002\u001a\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0002\u00a8\u0006\u0013"}, d2={"doGetHintProviderLanguages", "Lkotlin/sequences/Sequence;", "Lcom/intellij/lang/Language;", "getBaseLanguagesWithProviders", "", "getExcludeListInvalidLineNumbers", "", "text", "", "getHintProviders", "Lkotlin/Pair;", "Lcom/intellij/codeInsight/hints/InlayParameterHintsProvider;", "getLanguageForSettingKey", "language", "isParameterHintsEnabledForLanguage", "", "setShowParameterHintsForLanguage", "", "value", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nHintUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HintUtils.kt\ncom/intellij/codeInsight/hints/HintUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,72:1\n1549#2:73\n1620#2,3:74\n603#3:77\n*S KotlinDebug\n*F\n+ 1 HintUtils.kt\ncom/intellij/codeInsight/hints/HintUtilsKt\n*L\n28#1:73\n28#1:74,3\n60#1:77\n*E\n"})
public final class HintUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Pair<Language, InlayParameterHintsProvider>> getHintProviders() {
        void var3_3;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = SequencesKt.toList(HintUtilsKt.doGetHintProviderLanguages());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Language language = (Language)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it, InlayParameterHintsExtension.INSTANCE.forLanguage((Language)it)));
        }
        return CollectionsKt.toList((Iterable)((List)var3_3));
    }

    private static final Sequence<Language> doGetHintProviderLanguages() {
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)new ExtensionPointName("com.intellij.codeInsight.parameterNameHints").getExtensionList()), (Function1)doGetHintProviderLanguages.1.INSTANCE);
    }

    @NotNull
    public static final List<Integer> getExcludeListInvalidLineNumbers(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        List<String> list2 = StringUtil.split(text2, "\n", true, false);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"split(text, \"\\n\", true, false)");
        List<String> rules = list2;
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapIndexedNotNull((Sequence)CollectionsKt.asSequence((Iterable)rules), (Function2)getExcludeListInvalidLineNumbers.1.INSTANCE), (Function1)getExcludeListInvalidLineNumbers.2.INSTANCE), (Function1)getExcludeListInvalidLineNumbers.3.INSTANCE), (Function1)getExcludeListInvalidLineNumbers.4.INSTANCE), (Function1)getExcludeListInvalidLineNumbers.5.INSTANCE));
    }

    @NotNull
    public static final Language getLanguageForSettingKey(@NotNull Language language) {
        Language languageForSettings;
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        List<Language> supportedLanguages = HintUtilsKt.getBaseLanguagesWithProviders();
        for (languageForSettings = language; languageForSettings != null && !supportedLanguages.contains(languageForSettings); languageForSettings = languageForSettings.getBaseLanguage()) {
        }
        Language language2 = languageForSettings;
        if (language2 == null) {
            language2 = language;
        }
        return language2;
    }

    @NotNull
    public static final List<Language> getBaseLanguagesWithProviders() {
        Sequence<Language> $this$sortedBy$iv = HintUtilsKt.doGetHintProviderLanguages();
        boolean $i$f$sortedBy = false;
        return SequencesKt.toList((Sequence)SequencesKt.sortedWith($this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Language l = (Language)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)l.getDisplayName());
                l = (Language)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)l.getDisplayName())));
            }
        }));
    }

    public static final boolean isParameterHintsEnabledForLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        if (!InlayHintsSettings.Companion.instance().hintsShouldBeShown(language)) {
            return false;
        }
        return ParameterNameHintsSettings.Companion.getInstance().isEnabledForLanguage(HintUtilsKt.getLanguageForSettingKey(language));
    }

    public static final void setShowParameterHintsForLanguage(boolean value, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        ParameterNameHintsSettings.Companion.getInstance().setIsEnabledForLanguage(value, HintUtilsKt.getLanguageForSettingKey(language));
    }
}

