/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.hints.InlayDumpUtil;
import com.intellij.codeInsight.hints.LinearOrderInlayRenderer;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jn\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u001a\b\u0002\u0010\n\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b2\u001e\b\u0002\u0010\u000e\u001a\u0018\u0012\u0004\u0012\u00020\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0004\u0012\u00020\b0\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0007J\"\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\b0\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\bH\u0007J\u000e\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006 "}, d2={"Lcom/intellij/codeInsight/hints/InlayDumpUtil;", "", "()V", "inlayPattern", "Ljava/util/regex/Pattern;", "getInlayPattern", "()Ljava/util/regex/Pattern;", "dumpHintsInternal", "", "sourceText", "filter", "Lkotlin/Function1;", "Lcom/intellij/openapi/editor/Inlay;", "", "renderer", "Lkotlin/Function2;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "document", "Lcom/intellij/openapi/editor/Document;", "offsetShift", "", "extractEntries", "", "Lkotlin/Pair;", "text", "removeHints", "InlayData", "InlayType", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nInlayDumpUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlayDumpUtil.kt\ncom/intellij/codeInsight/hints/InlayDumpUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1620#2,3:127\n1620#2,3:130\n1620#2,3:133\n1002#2,2:136\n*S KotlinDebug\n*F\n+ 1 InlayDumpUtil.kt\ncom/intellij/codeInsight/hints/InlayDumpUtil\n*L\n37#1:127,3\n38#1:130,3\n39#1:133,3\n40#1:136,2\n*E\n"})
public final class InlayDumpUtil {
    @NotNull
    public static final InlayDumpUtil INSTANCE = new InlayDumpUtil();
    @NotNull
    private static final Pattern inlayPattern;

    private InlayDumpUtil() {
    }

    @NotNull
    public final Pattern getInlayPattern() {
        return inlayPattern;
    }

    @NotNull
    public final String removeHints(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        String string2 = inlayPattern.matcher(text2).replaceAll("");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"inlayPattern.matcher(text).replaceAll(\"\")");
        return string2;
    }

    @ApiStatus.Internal
    @NotNull
    public final String dumpHintsInternal(@NotNull String sourceText, @Nullable Function1<? super Inlay<?>, Boolean> filter2, @NotNull Function2<? super EditorCustomElementRenderer, ? super Inlay<?>, String> renderer, @NotNull PsiFile file2, @NotNull Editor editor2, @NotNull Document document, int offsetShift) {
        StringBuilder stringBuilder;
        Inlay it;
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)sourceText, (String)"sourceText");
        Intrinsics.checkNotNullParameter(renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        InlayModel inlayModel = editor2.getInlayModel();
        Intrinsics.checkNotNullExpressionValue((Object)inlayModel, (String)"editor.inlayModel");
        InlayModel model2 = inlayModel;
        TextRange range = file2.getTextRange();
        List list2 = model2.getInlineElementsInRange(range.getStartOffset(), range.getEndOffset());
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"model.getInlineElementsI\u2026tOffset, range.endOffset)");
        List inlineElements = list2;
        List list3 = model2.getAfterLineEndElementsInRange(range.getStartOffset(), range.getEndOffset());
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"model.getAfterLineEndEle\u2026tOffset, range.endOffset)");
        List afterLineElements = list3;
        List list4 = model2.getBlockElementsInRange(range.getStartOffset(), range.getEndOffset());
        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"model.getBlockElementsIn\u2026tOffset, range.endOffset)");
        List blockElements = list4;
        List inlays = new ArrayList();
        Iterable $this$mapTo$iv = inlineElements;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            Inlay inlay = (Inlay)item$iv;
            collection = inlays;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(new InlayData(it, InlayType.Inline));
        }
        $this$mapTo$iv = afterLineElements;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            it = (Inlay)item$iv;
            collection = inlays;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(new InlayData(it, InlayType.Inline));
        }
        $this$mapTo$iv = blockElements;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            it = (Inlay)item$iv;
            collection = inlays;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(new InlayData(it, InlayType.Block));
        }
        List $this$sortBy$iv = inlays;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(document){
                final /* synthetic */ Document $document$inlined;
                {
                    this.$document$inlined = document;
                }

                public final int compare(T a, T b) {
                    InlayData it = (InlayData)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.effectiveOffset(this.$document$inlined));
                    it = (InlayData)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.effectiveOffset(this.$document$inlined)));
                }
            });
        }
        StringBuilder $this$dumpHintsInternal_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int currentOffset = 0;
        for (InlayData inlay : inlays) {
            if (filter2 != null && !((Boolean)filter2.invoke(inlay.getInlay())).booleanValue()) continue;
            int nextOffset = inlay.effectiveOffset(document) + offsetShift;
            $this$dumpHintsInternal_u24lambda_u244.append(sourceText.subSequence(currentOffset, nextOffset));
            $this$dumpHintsInternal_u24lambda_u244.append(inlay.render(renderer));
            currentOffset = nextOffset;
        }
        String string2 = sourceText.substring(currentOffset, sourceText.length());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        $this$dumpHintsInternal_u24lambda_u244.append(string2);
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
        return string3;
    }

    public static /* synthetic */ String dumpHintsInternal$default(InlayDumpUtil inlayDumpUtil, String string2, Function1 function1, Function2 function2, PsiFile psiFile, Editor editor2, Document document, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            function1 = null;
        }
        if ((n2 & 4) != 0) {
            function2 = dumpHintsInternal.1.INSTANCE;
        }
        if ((n2 & 0x40) != 0) {
            n = 0;
        }
        return inlayDumpUtil.dumpHintsInternal(string2, function1, function2, psiFile, editor2, document, n);
    }

    @ApiStatus.Internal
    @NotNull
    public final List<Pair<Integer, String>> extractEntries(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Matcher matcher = inlayPattern.matcher(text2);
        ArrayList<Pair> offsetToContent = new ArrayList<Pair>();
        int previousOffsetWithoutInlays = 0;
        int previousOffsetWithInlays = 0;
        while (matcher.find()) {
            int startOffset = matcher.start();
            int endOffset = matcher.end();
            previousOffsetWithoutInlays += startOffset - previousOffsetWithInlays;
            previousOffsetWithInlays = endOffset;
            CharSequence content2 = text2.subSequence(startOffset, endOffset);
            if (StringsKt.startsWith$default((CharSequence)content2, (CharSequence)"<# block", (boolean)false, (int)2, null)) {
                throw new NotImplementedError("Block inlays are not yet supported");
            }
            String strippedContent = ((Object)content2.subSequence(3, content2.length() - 3)).toString();
            offsetToContent.add(TuplesKt.to((Object)previousOffsetWithoutInlays, (Object)strippedContent));
        }
        return offsetToContent;
    }

    static {
        Pattern pattern = Pattern.compile("<# block ([^#]*)#>(\r\n|\r|\n)|<#([^#]*)#>");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"<# block ([^#]*\u2026\\r\\n|\\r|\\n)|<#([^#]*)#>\")");
        inlayPattern = pattern;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J!\u0010\r\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u000fH\u00d6\u0001J$\u0010\u0016\u001a\u00020\u00172\u001c\u0010\u0018\u001a\u0018\u0012\u0004\u0012\u00020\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0012\u0004\u0012\u00020\u00170\u0019J\b\u0010\u001b\u001a\u00020\u0017H\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lcom/intellij/codeInsight/hints/InlayDumpUtil$InlayData;", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "type", "Lcom/intellij/codeInsight/hints/InlayDumpUtil$InlayType;", "(Lcom/intellij/openapi/editor/Inlay;Lcom/intellij/codeInsight/hints/InlayDumpUtil$InlayType;)V", "getInlay", "()Lcom/intellij/openapi/editor/Inlay;", "getType", "()Lcom/intellij/codeInsight/hints/InlayDumpUtil$InlayType;", "component1", "component2", "copy", "effectiveOffset", "", "document", "Lcom/intellij/openapi/editor/Document;", "equals", "", "other", "hashCode", "render", "", "r", "Lkotlin/Function2;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "toString", "intellij.platform.lang.impl"})
    public static final class InlayData {
        @NotNull
        private final Inlay<?> inlay;
        @NotNull
        private final InlayType type;

        public InlayData(@NotNull Inlay<?> inlay, @NotNull InlayType type) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.inlay = inlay;
            this.type = type;
        }

        @NotNull
        public final Inlay<?> getInlay() {
            return this.inlay;
        }

        @NotNull
        public final InlayType getType() {
            return this.type;
        }

        public final int effectiveOffset(@NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            return switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
                case 1 -> this.inlay.getOffset();
                case 2 -> {
                    int offset = this.inlay.getOffset();
                    int lineNumber = document.getLineNumber(offset);
                    yield document.getLineStartOffset(lineNumber);
                }
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @NotNull
        public final String render(@NotNull Function2<? super EditorCustomElementRenderer, ? super Inlay<?>, String> r) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter(r, (String)"r");
            StringBuilder $this$render_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$render_u24lambda_u240.append("<# ");
            if (this.type == InlayType.Block) {
                $this$render_u24lambda_u240.append("block ");
            }
            EditorCustomElementRenderer editorCustomElementRenderer = this.inlay.getRenderer();
            Intrinsics.checkNotNullExpressionValue((Object)editorCustomElementRenderer, (String)"inlay.renderer");
            $this$render_u24lambda_u240.append((String)r.invoke((Object)editorCustomElementRenderer, this.inlay));
            $this$render_u24lambda_u240.append(" #>");
            if (this.type == InlayType.Block) {
                $this$render_u24lambda_u240.append('\n');
            }
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
            return string2;
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder;
            EditorCustomElementRenderer renderer = this.inlay.getRenderer();
            if (!(renderer instanceof PresentationRenderer) && !(renderer instanceof LinearOrderInlayRenderer)) {
                throw new IllegalStateException("renderer not supported".toString());
            }
            StringBuilder $this$toString_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$toString_u24lambda_u241.append("<# ");
            if (this.type == InlayType.Block) {
                $this$toString_u24lambda_u241.append("block ");
            }
            $this$toString_u24lambda_u241.append(renderer.toString());
            $this$toString_u24lambda_u241.append(" #>");
            if (this.type == InlayType.Block) {
                $this$toString_u24lambda_u241.append('\n');
            }
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
            return string2;
        }

        @NotNull
        public final Inlay<?> component1() {
            return this.inlay;
        }

        @NotNull
        public final InlayType component2() {
            return this.type;
        }

        @NotNull
        public final InlayData copy(@NotNull Inlay<?> inlay, @NotNull InlayType type) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return new InlayData(inlay, type);
        }

        public static /* synthetic */ InlayData copy$default(InlayData inlayData, Inlay inlay, InlayType inlayType, int n, Object object) {
            if ((n & 1) != 0) {
                inlay = inlayData.inlay;
            }
            if ((n & 2) != 0) {
                inlayType = inlayData.type;
            }
            return inlayData.copy(inlay, inlayType);
        }

        public int hashCode() {
            int result2 = this.inlay.hashCode();
            result2 = result2 * 31 + this.type.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InlayData)) {
                return false;
            }
            InlayData inlayData = (InlayData)other;
            if (!Intrinsics.areEqual(this.inlay, inlayData.inlay)) {
                return false;
            }
            return this.type == inlayData.type;
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[InlayType.values().length];
                try {
                    nArray[InlayType.Inline.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[InlayType.Block.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/codeInsight/hints/InlayDumpUtil$InlayType;", "", "(Ljava/lang/String;I)V", "Inline", "Block", "intellij.platform.lang.impl"})
    public static final class InlayType
    extends Enum<InlayType> {
        public static final /* enum */ InlayType Inline = new InlayType();
        public static final /* enum */ InlayType Block = new InlayType();
        private static final /* synthetic */ InlayType[] $VALUES;

        public static InlayType[] values() {
            return (InlayType[])$VALUES.clone();
        }

        public static InlayType valueOf(String value) {
            return Enum.valueOf(InlayType.class, value);
        }

        static {
            $VALUES = inlayTypeArray = new InlayType[]{InlayType.Inline, InlayType.Block};
        }
    }
}

