/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.hints.BlockConstraints;
import com.intellij.codeInsight.hints.BlockInlayRenderer;
import com.intellij.codeInsight.hints.CollectorWithSettings;
import com.intellij.codeInsight.hints.ConstrainedPresentation;
import com.intellij.codeInsight.hints.HintsBuffer;
import com.intellij.codeInsight.hints.HorizontalConstraints;
import com.intellij.codeInsight.hints.InlayContentListener;
import com.intellij.codeInsight.hints.InlayHintsPass;
import com.intellij.codeInsight.hints.InlayHintsPassFactory;
import com.intellij.codeInsight.hints.InlayPresentationFactory;
import com.intellij.codeInsight.hints.InlineInlayRenderer;
import com.intellij.codeInsight.hints.PresentationContainerRenderer;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.concurrency.JobLauncher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.IntStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/codeInsight/hints/InlayHintsPass;", "Lcom/intellij/codeHighlighting/EditorBoundHighlightingPass;", "Lcom/intellij/openapi/project/DumbAware;", "rootElement", "Lcom/intellij/psi/PsiElement;", "enabledCollectors", "", "Lcom/intellij/codeInsight/hints/CollectorWithSettings;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/psi/PsiElement;Ljava/util/List;Lcom/intellij/openapi/editor/Editor;)V", "allHints", "Lcom/intellij/codeInsight/hints/HintsBuffer;", "doApplyInformationToEditor", "", "doCollectInformation", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Companion", "intellij.platform.lang.impl"})
public final class InlayHintsPass
extends EditorBoundHighlightingPass
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiElement rootElement;
    @NotNull
    private final List<CollectorWithSettings<? extends Object>> enabledCollectors;
    @NotNull
    private final Editor editor;
    @Nullable
    private HintsBuffer allHints;
    private static final int BULK_CHANGE_THRESHOLD = 1000;
    @NotNull
    private static final Key<Boolean> MANAGED_KEY;
    @NotNull
    private static final Key<Boolean> PLACEHOLDER_KEY;

    public InlayHintsPass(@NotNull PsiElement rootElement, @NotNull List<? extends CollectorWithSettings<? extends Object>> enabledCollectors, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)rootElement, (String)"rootElement");
        Intrinsics.checkNotNullParameter(enabledCollectors, (String)"enabledCollectors");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        super(editor2, rootElement.getContainingFile(), true);
        this.rootElement = rootElement;
        this.enabledCollectors = enabledCollectors;
        this.editor = editor2;
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        if (!HighlightingLevelManager.getInstance(this.myFile.getProject()).shouldHighlight(this.myFile)) {
            return;
        }
        if (this.enabledCollectors.isEmpty()) {
            return;
        }
        ConcurrentLinkedQueue buffers = new ConcurrentLinkedQueue();
        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(this.enabledCollectors, progress, true, false, arg_0 -> InlayHintsPass.doCollectInformation$lambda$0(this, buffers, arg_0));
        Iterator iterator2 = buffers.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"buffers.iterator()");
        Iterator iterator3 = iterator2;
        if (!iterator3.hasNext()) {
            return;
        }
        HintsBuffer allHintsAccumulator = (HintsBuffer)iterator3.next();
        Iterator iterator4 = iterator3;
        while (iterator4.hasNext()) {
            HintsBuffer hintsBuffer = (HintsBuffer)iterator4.next();
            Intrinsics.checkNotNullExpressionValue((Object)hintsBuffer, (String)"hintsBuffer");
            allHintsAccumulator.mergeIntoThis$intellij_platform_lang_impl(hintsBuffer);
        }
        this.allHints = allHintsAccumulator;
    }

    @Override
    public void doApplyInformationToEditor() {
        if (!(this.editor instanceof EditorImpl)) {
            return;
        }
        EditorScrollingPositionKeeper positionKeeper = new EditorScrollingPositionKeeper(this.editor);
        positionKeeper.savePosition();
        com.intellij.codeInsight.hints.InlayHintsPass$Companion.applyCollected$intellij_platform_lang_impl$default(Companion, this.allHints, this.rootElement, this.editor, false, 8, null);
        positionKeeper.restorePosition(false);
        if (this.rootElement == this.myFile) {
            Editor editor2 = this.myEditor;
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"myEditor");
            PsiFile psiFile = this.myFile;
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"myFile");
            InlayHintsPassFactory.Companion.putCurrentModificationStamp(editor2, psiFile);
        }
    }

    private static final boolean doCollectInformation$lambda$0(InlayHintsPass this$0, ConcurrentLinkedQueue $buffers, CollectorWithSettings collector2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$buffers, (String)"$buffers");
        SyntaxTraverser<PsiElement> syntaxTraverser = SyntaxTraverser.psiTraverser(this$0.rootElement);
        Intrinsics.checkNotNullExpressionValue(syntaxTraverser, (String)"psiTraverser(rootElement)");
        SyntaxTraverser<PsiElement> traverser = syntaxTraverser;
        for (PsiElement element : traverser.preOrderDfsTraversal()) {
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"element");
            Editor editor2 = this$0.myEditor;
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"myEditor");
            if (collector2.collectHints(element, editor2)) continue;
        }
        HintsBuffer hints = collector2.getSink().complete$intellij_platform_lang_impl();
        $buffers.add(hints);
        return true;
    }

    static {
        Key key = Key.create("managed.inlay");
        Intrinsics.checkNotNullExpressionValue(key, (String)"create<Boolean>(\"managed.inlay\")");
        MANAGED_KEY = key;
        Key key2 = Key.create("inlay.placeholder");
        Intrinsics.checkNotNullExpressionValue(key2, (String)"create<Boolean>(\"inlay.placeholder\")");
        PLACEHOLDER_KEY = key2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u001c\u0010\u0011\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00150\u00140\u00130\u00122\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u0018\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J1\u0010\u001b\u001a\u00020\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010\u0017\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b J\u001e\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&J$\u0010'\u001a\u00020\f2\u0012\u0010(\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030*0)2\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\\\u0010+\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0014\u0010,\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020-0)0\u00132\u0018\u0010.\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030*0)0\u00132\u0018\u0010/\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030*0)0\u0013H\u0002JD\u00100\u001a\u00020\f2\u0018\u00101\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030*0)022\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010%\u001a\u00020&2\u0006\u0010\r\u001a\u0002032\u0006\u0010\u001e\u001a\u00020\u001fH\u0002JJ\u00104\u001a\u00020\f\"\b\b\u0000\u00105*\u00020\u0001*\b\u0012\u0004\u0012\u0002H50*2\u0014\u00106\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0014022\u0006\u0010\r\u001a\u0002032\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u00107\u001a\u00020#*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030)02H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R!\u0010\u0005\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\n\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/codeInsight/hints/InlayHintsPass$Companion;", "", "()V", "BULK_CHANGE_THRESHOLD", "", "MANAGED_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "PLACEHOLDER_KEY", "addBlockHints", "", "factory", "Lcom/intellij/codeInsight/hints/presentation/PresentationFactory;", "inlayModel", "Lcom/intellij/openapi/editor/InlayModel;", "map", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "", "Lcom/intellij/codeInsight/hints/ConstrainedPresentation;", "Lcom/intellij/codeInsight/hints/BlockConstraints;", "showAbove", "isPlaceholder", "addInlineHints", "hints", "Lcom/intellij/codeInsight/hints/HintsBuffer;", "applyCollected", "element", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "applyCollected$intellij_platform_lang_impl", "estimateChangesCountForPlacement", "existingInlayOffsets", "Ljava/util/stream/IntStream;", "collected", "placement", "Lcom/intellij/openapi/editor/Inlay$Placement;", "postprocessInlay", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "Lcom/intellij/codeInsight/hints/PresentationContainerRenderer;", "shouldBeBulk", "existingInlineInlays", "Lcom/intellij/codeInsight/hints/InlineInlayRenderer;", "existingBlockAboveInlays", "existingBlockBelowInlays", "updateOrDispose", "existing", "", "Lcom/intellij/codeInsight/hints/InlayPresentationFactory;", "addOrUpdate", "Constraints", "new", "offsets", "intellij.platform.lang.impl"})
    @SourceDebugExtension(value={"SMAP\nInlayHintsPass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlayHintsPass.kt\ncom/intellij/codeInsight/hints/InlayHintsPass$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,231:1\n1747#2,3:232\n1726#2,3:235\n1#3:238\n*S KotlinDebug\n*F\n+ 1 InlayHintsPass.kt\ncom/intellij/codeInsight/hints/InlayHintsPass$Companion\n*L\n124#1:232,3\n125#1:235,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void applyCollected$intellij_platform_lang_impl(@Nullable HintsBuffer hints, @NotNull PsiElement element, @NotNull Editor editor2, boolean isPlaceholder) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            int startOffset = element.getTextOffset();
            int endOffset = element.getTextRange().getEndOffset();
            InlayModel inlayModel = editor2.getInlayModel();
            Intrinsics.checkNotNullExpressionValue((Object)inlayModel, (String)"editor.inlayModel");
            InlayModel inlayModel2 = inlayModel;
            List existingInlineInlays = inlayModel2.getInlineElementsInRange(startOffset, endOffset, InlineInlayRenderer.class);
            List list2 = inlayModel2.getAfterLineEndElementsInRange(startOffset, endOffset, InlineInlayRenderer.class);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"inlayModel.getAfterLineE\u2026nlayRenderer::class.java)");
            List existingAfterLineEndInlays = list2;
            List list3 = inlayModel2.getBlockElementsInRange(startOffset, endOffset, BlockInlayRenderer.class);
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"inlayModel.getBlockEleme\u2026nlayRenderer::class.java)");
            List existingBlockInlays = list3;
            List existingBlockAboveInlays = new ArrayList();
            List existingBlockBelowInlays = new ArrayList();
            for (Inlay inlay : existingBlockInlays) {
                (switch (WhenMappings.$EnumSwitchMapping$0[inlay.getPlacement().ordinal()]) {
                    case 1 -> existingBlockAboveInlays;
                    case 2 -> existingBlockBelowInlays;
                    default -> throw new IllegalStateException();
                }).add(inlay);
            }
            Intrinsics.checkNotNullExpressionValue((Object)existingInlineInlays, (String)"existingInlineInlays");
            boolean isBulk = this.shouldBeBulk(hints, existingInlineInlays, existingBlockAboveInlays, existingBlockBelowInlays);
            PresentationFactory factory2 = new PresentationFactory((Editor)((EditorImpl)editor2));
            inlayModel2.execute(isBulk, () -> Companion.applyCollected$lambda$0(existingInlineInlays, hints, factory2, editor2, existingAfterLineEndInlays, existingBlockAboveInlays, existingBlockBelowInlays, inlayModel2, isPlaceholder));
        }

        public static /* synthetic */ void applyCollected$intellij_platform_lang_impl$default(Companion companion, HintsBuffer hintsBuffer, PsiElement psiElement, Editor editor2, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            companion.applyCollected$intellij_platform_lang_impl(hintsBuffer, psiElement, editor2, bl);
        }

        private final void postprocessInlay(Inlay<? extends PresentationContainerRenderer<?>> inlay, boolean isPlaceholder) {
            ((PresentationContainerRenderer)inlay.getRenderer()).setListener(new InlayContentListener(inlay));
            inlay.putUserData(MANAGED_KEY, (Object)true);
            if (isPlaceholder) {
                inlay.putUserData(PLACEHOLDER_KEY, (Object)true);
            }
        }

        private final void addInlineHints(HintsBuffer hints, InlayModel inlayModel) {
            for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable(hints.getInlineHints())) {
                Inlay it;
                Inlay inlay;
                boolean isRelatedToPrecedingText;
                boolean toBePlacedAtTheEndOfLine;
                InlineInlayRenderer renderer;
                block10: {
                    boolean bl;
                    block9: {
                        Object v = entry.getValue();
                        Intrinsics.checkNotNullExpressionValue(v, (String)"entry.value");
                        renderer = new InlineInlayRenderer((Collection)v);
                        Object v2 = entry.getValue();
                        Intrinsics.checkNotNullExpressionValue(v2, (String)"entry.value");
                        Iterable $this$any$iv = (Iterable)v2;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                ConstrainedPresentation it2 = (ConstrainedPresentation)element$iv;
                                boolean bl2 = false;
                                HorizontalConstraints horizontalConstraints = (HorizontalConstraints)it2.getConstraints();
                                if (!(horizontalConstraints != null ? horizontalConstraints.getPlacedAtTheEndOfLine() : false)) continue;
                                bl = true;
                                break block9;
                            }
                            bl = false;
                        }
                    }
                    toBePlacedAtTheEndOfLine = bl;
                    Object v = entry.getValue();
                    Intrinsics.checkNotNullExpressionValue(v, (String)"entry.value");
                    Iterable $this$all$iv = (Iterable)v;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        v5 = true;
                    } else {
                        Object element$iv;
                        element$iv = $this$all$iv.iterator();
                        while (element$iv.hasNext()) {
                            Object element$iv2 = element$iv.next();
                            ConstrainedPresentation it3 = (ConstrainedPresentation)element$iv2;
                            boolean bl3 = false;
                            HorizontalConstraints horizontalConstraints = (HorizontalConstraints)it3.getConstraints();
                            if (horizontalConstraints != null ? horizontalConstraints.getRelatesToPrecedingText() : false) continue;
                            v5 = false;
                            break block10;
                        }
                        v5 = isRelatedToPrecedingText = true;
                    }
                }
                if (toBePlacedAtTheEndOfLine) {
                    inlay = inlayModel.addAfterLineEndElement(entry.getIntKey(), true, (EditorCustomElementRenderer)renderer);
                } else {
                    inlay = inlayModel.addInlineElement(entry.getIntKey(), isRelatedToPrecedingText, (EditorCustomElementRenderer)renderer);
                    if (inlay == null) break;
                }
                Inlay inlay2 = inlay;
                if (inlay2 == null) continue;
                boolean bl = false;
                Companion.postprocessInlay(it, false);
            }
        }

        private final void addBlockHints(PresentationFactory factory2, InlayModel inlayModel, Int2ObjectMap<List<ConstrainedPresentation<?, BlockConstraints>>> map2, boolean showAbove, boolean isPlaceholder) {
            for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable(map2)) {
                Inlay inlay;
                List presentations = (List)entry.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)presentations, (String)"presentations");
                BlockConstraints constraints = (BlockConstraints)((ConstrainedPresentation)CollectionsKt.first((List)presentations)).getConstraints();
                BlockConstraints blockConstraints = constraints;
                BlockConstraints blockConstraints2 = constraints;
                if (inlayModel.addBlockElement(entry.getIntKey(), blockConstraints != null ? blockConstraints.getRelatesToPrecedingText() : true, showAbove, blockConstraints2 != null ? blockConstraints2.getPriority() : 0, (EditorCustomElementRenderer)new BlockInlayRenderer(factory2, presentations)) == null) break;
                this.postprocessInlay(inlay, isPlaceholder);
                if (showAbove) continue;
                break;
            }
        }

        private final boolean shouldBeBulk(HintsBuffer hints, List<Inlay<? extends InlineInlayRenderer>> existingInlineInlays, List<Inlay<? extends PresentationContainerRenderer<?>>> existingBlockAboveInlays, List<Inlay<? extends PresentationContainerRenderer<?>>> existingBlockBelowInlays) {
            int totalChangesCount = hints != null ? this.estimateChangesCountForPlacement(this.offsets(existingInlineInlays), hints, Inlay.Placement.INLINE) + this.estimateChangesCountForPlacement(this.offsets(existingBlockAboveInlays), hints, Inlay.Placement.ABOVE_LINE) + this.estimateChangesCountForPlacement(this.offsets(existingBlockBelowInlays), hints, Inlay.Placement.BELOW_LINE) : existingInlineInlays.size() + existingBlockAboveInlays.size() + existingBlockBelowInlays.size();
            return totalChangesCount > 1000;
        }

        private final IntStream offsets(List<? extends Inlay<?>> $this$offsets) {
            IntStream intStream = $this$offsets.stream().mapToInt(arg_0 -> Companion.offsets$lambda$4(offsets.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)intStream, (String)"stream().mapToInt { it.offset }");
            return intStream;
        }

        private final void updateOrDispose(List<? extends Inlay<? extends PresentationContainerRenderer<?>>> existing, HintsBuffer hints, Inlay.Placement placement, InlayPresentationFactory factory2, Editor editor2) {
            for (Inlay<PresentationContainerRenderer<?>> inlay : existing) {
                List<ConstrainedPresentation<?, ?>> elements;
                boolean managed;
                Boolean bl = (Boolean)inlay.getUserData(MANAGED_KEY);
                if (bl == null || !(managed = bl.booleanValue())) continue;
                int offset2 = inlay.getOffset();
                HintsBuffer hintsBuffer = hints;
                List<ConstrainedPresentation<?, ?>> list2 = elements = hintsBuffer != null ? hintsBuffer.remove(offset2, placement) : null;
                if (elements == null) {
                    if (Intrinsics.areEqual((Object)inlay.getUserData(PLACEHOLDER_KEY), (Object)true)) continue;
                    Disposer.dispose((Disposable)inlay);
                    continue;
                }
                inlay.putUserData(PLACEHOLDER_KEY, null);
                this.addOrUpdate((PresentationContainerRenderer)inlay.getRenderer(), elements, factory2, placement, editor2);
            }
        }

        public final int estimateChangesCountForPlacement(@NotNull IntStream existingInlayOffsets, @NotNull HintsBuffer collected, @NotNull Inlay.Placement placement) {
            Intrinsics.checkNotNullParameter((Object)existingInlayOffsets, (String)"existingInlayOffsets");
            Intrinsics.checkNotNullParameter((Object)collected, (String)"collected");
            Intrinsics.checkNotNullParameter((Object)placement, (String)"placement");
            int count2 = 0;
            IntOpenHashSet offsetsWithExistingHints = new IntOpenHashSet();
            PrimitiveIterator.OfInt ofInt = existingInlayOffsets.iterator();
            while (ofInt.hasNext()) {
                Integer offset2 = ofInt.next();
                Intrinsics.checkNotNullExpressionValue((Object)offset2, (String)"offset");
                if (!collected.contains$intellij_platform_lang_impl(offset2, placement)) {
                    ++count2;
                    continue;
                }
                offsetsWithExistingHints.add((int)offset2);
            }
            int elementsToCreate = collected.countDisjointElements$intellij_platform_lang_impl(offsetsWithExistingHints, placement);
            return count2 += elementsToCreate;
        }

        private final <Constraints> void addOrUpdate(PresentationContainerRenderer<Constraints> $this$addOrUpdate, List<? extends ConstrainedPresentation<?, ?>> list2, InlayPresentationFactory factory2, Inlay.Placement placement, Editor editor2) {
            if (!$this$addOrUpdate.isAcceptablePlacement(placement)) {
                throw new IllegalArgumentException();
            }
            Intrinsics.checkNotNull(list2, (String)"null cannot be cast to non-null type kotlin.collections.List<com.intellij.codeInsight.hints.ConstrainedPresentation<*, Constraints of com.intellij.codeInsight.hints.InlayHintsPass.Companion.addOrUpdate>>");
            $this$addOrUpdate.addOrUpdate(list2, editor2, factory2);
        }

        private static final void applyCollected$lambda$0(List $existingInlineInlays, HintsBuffer $hints, PresentationFactory $factory, Editor $editor, List $existingAfterLineEndInlays, List $existingBlockAboveInlays, List $existingBlockBelowInlays, InlayModel $inlayModel, boolean $isPlaceholder) {
            Intrinsics.checkNotNullParameter((Object)$factory, (String)"$factory");
            Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
            Intrinsics.checkNotNullParameter((Object)$existingAfterLineEndInlays, (String)"$existingAfterLineEndInlays");
            Intrinsics.checkNotNullParameter((Object)$existingBlockAboveInlays, (String)"$existingBlockAboveInlays");
            Intrinsics.checkNotNullParameter((Object)$existingBlockBelowInlays, (String)"$existingBlockBelowInlays");
            Intrinsics.checkNotNullParameter((Object)$inlayModel, (String)"$inlayModel");
            Intrinsics.checkNotNullExpressionValue((Object)$existingInlineInlays, (String)"existingInlineInlays");
            Companion.updateOrDispose($existingInlineInlays, $hints, Inlay.Placement.INLINE, $factory, $editor);
            Companion.updateOrDispose($existingAfterLineEndInlays, $hints, Inlay.Placement.INLINE, $factory, $editor);
            Companion.updateOrDispose($existingBlockAboveInlays, $hints, Inlay.Placement.ABOVE_LINE, $factory, $editor);
            Companion.updateOrDispose($existingBlockBelowInlays, $hints, Inlay.Placement.BELOW_LINE, $factory, $editor);
            if ($hints != null) {
                Companion.addInlineHints($hints, $inlayModel);
                Companion.addBlockHints($factory, $inlayModel, (Int2ObjectMap)$hints.getBlockAboveHints$intellij_platform_lang_impl(), true, $isPlaceholder);
                Companion.addBlockHints($factory, $inlayModel, (Int2ObjectMap)$hints.getBlockBelowHints$intellij_platform_lang_impl(), false, $isPlaceholder);
            }
        }

        private static final int offsets$lambda$4(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return ((Number)$tmp0.invoke(p0)).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Inlay.Placement.values().length];
                try {
                    nArray[Inlay.Placement.ABOVE_LINE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Inlay.Placement.BELOW_LINE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

