/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarImpl;
import com.intellij.codeInsight.hints.CollectorWithSettings;
import com.intellij.codeInsight.hints.HintUtils;
import com.intellij.codeInsight.hints.HintsBuffer;
import com.intellij.codeInsight.hints.InlayGroup;
import com.intellij.codeInsight.hints.InlayHintsPass;
import com.intellij.codeInsight.hints.InlayHintsSettings;
import com.intellij.codeInsight.hints.InlayHintsUtilsKt;
import com.intellij.codeInsight.hints.ProviderWithSettings;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.diff.util.DiffUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/codeInsight/hints/InlayHintsPassFactory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactoryRegistrar;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "registerHighlightingPassFactory", "", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nInlayHintsPassFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlayHintsPassFactory.kt\ncom/intellij/codeInsight/hints/InlayHintsPassFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1#2:119\n1#2:130\n1603#3,9:120\n1855#3:129\n1856#3:131\n1612#3:132\n*S KotlinDebug\n*F\n+ 1 InlayHintsPassFactory.kt\ncom/intellij/codeInsight/hints/InlayHintsPassFactory\n*L\n35#1:130\n35#1:120,9\n35#1:129\n35#1:131\n35#1:132\n*E\n"})
public final class InlayHintsPassFactory
implements TextEditorHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar,
DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Long> PSI_MODIFICATION_STAMP;
    @NotNull
    private static final Key<Boolean> HINTS_DISABLED_FOR_EDITOR;
    @NotNull
    private static final Key<Set<SettingsKey<?>>> ALWAYS_ENABLED_HINTS_PROVIDERS;

    @Override
    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        int[] nArray = new int[]{4};
        int[] it = nArray;
        boolean bl = false;
        int[] ghl = (int[])(((TextEditorHighlightingPassRegistrarImpl)registrar).isSerializeCodeInsightPasses() ? nArray : null);
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, ghl, null, false, -1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (editor2.isOneLineMode()) {
            return null;
        }
        Long savedStamp = (Long)editor2.getUserData(PSI_MODIFICATION_STAMP);
        if (DiffUtil.isDiffEditor((Editor)editor2)) {
            return null;
        }
        long currentStamp = InlayHintsPassFactory.Companion.getCurrentModificationStamp(file2);
        if (savedStamp != null) {
            long l = currentStamp;
            if (savedStamp == l) {
                return null;
            }
        }
        Language language = file2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"file.language");
        Language language2 = language;
        Iterable $this$mapNotNull$iv = InlayHintsPassFactory.Companion.getProviders(file2, editor2);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            CollectorWithSettings it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ProviderWithSettings it = (ProviderWithSettings)element$iv$iv;
            boolean bl2 = false;
            if (InlayHintsUtilsKt.getCollectorWrapperFor(it, file2, editor2, language2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List collectors = (List)destination$iv$iv;
        return new InlayHintsPass(file2, collectors, editor2);
    }

    @JvmStatic
    @ApiStatus.Experimental
    public static final void setAlwaysEnabledHintsProviders(@NotNull Editor editor2, @Nullable Iterable<? extends SettingsKey<?>> keys2) {
        Companion.setAlwaysEnabledHintsProviders(editor2, keys2);
    }

    static {
        Key key = Key.create("inlay.psi.modification.stamp");
        Intrinsics.checkNotNullExpressionValue(key, (String)"create(\"inlay.psi.modification.stamp\")");
        PSI_MODIFICATION_STAMP = key;
        Key key2 = Key.create("inlay.hints.enabled.for.editor");
        Intrinsics.checkNotNullExpressionValue(key2, (String)"create(\"inlay.hints.enabled.for.editor\")");
        HINTS_DISABLED_FOR_EDITOR = key2;
        Key key3 = Key.create("inlay.hints.always.enabled.providers");
        Intrinsics.checkNotNullExpressionValue(key3, (String)"create(\"inlay.hints.always.enabled.providers\")");
        ALWAYS_ENABLED_HINTS_PROVIDERS = key3;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0006\u0010\u0018\u001a\u00020\u000fJ\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J&\u0010\u001a\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001c\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J\u0016\u0010!\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011J$\u0010\"\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010#\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0018\u00010$H\u0007R&\u0010\u0003\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002R\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0002R\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\r\u0010\u0002\u00a8\u0006%"}, d2={"Lcom/intellij/codeInsight/hints/InlayHintsPassFactory$Companion;", "", "()V", "ALWAYS_ENABLED_HINTS_PROVIDERS", "Lcom/intellij/openapi/util/Key;", "", "Lcom/intellij/codeInsight/hints/SettingsKey;", "getALWAYS_ENABLED_HINTS_PROVIDERS$annotations", "HINTS_DISABLED_FOR_EDITOR", "", "getHINTS_DISABLED_FOR_EDITOR$annotations", "PSI_MODIFICATION_STAMP", "", "getPSI_MODIFICATION_STAMP$annotations", "applyPlaceholders", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "hints", "Lcom/intellij/codeInsight/hints/HintsBuffer;", "clearModificationStamp", "collectPlaceholders", "forceHintsUpdateOnNextPass", "getCurrentModificationStamp", "getProviders", "", "Lcom/intellij/codeInsight/hints/ProviderWithSettings;", "element", "Lcom/intellij/psi/PsiElement;", "isProviderAlwaysEnabledForEditor", "providerKey", "putCurrentModificationStamp", "setAlwaysEnabledHintsProviders", "keys", "", "intellij.platform.lang.impl"})
    @SourceDebugExtension(value={"SMAP\nInlayHintsPassFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlayHintsPassFactory.kt\ncom/intellij/codeInsight/hints/InlayHintsPassFactory$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n13579#2,2:119\n766#3:121\n857#3,2:122\n1#4:124\n*S KotlinDebug\n*F\n+ 1 InlayHintsPassFactory.kt\ncom/intellij/codeInsight/hints/InlayHintsPassFactory$Companion\n*L\n45#1:119,2\n99#1:121\n99#1:122,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void forceHintsUpdateOnNextPass() {
            Editor[] editorArray = EditorFactory.getInstance().getAllEditors();
            Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getInstance().allEditors");
            Editor[] editorArray2 = editorArray;
            int n = editorArray2.length;
            for (int j = 0; j < n; ++j) {
                Editor editor2 = editorArray2[j];
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"editor");
                this.clearModificationStamp(editor2);
            }
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getInstance().openProjects");
            Object[] $this$forEach$iv = projectArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Project project2 = (Project)element$iv;
                boolean bl = false;
                DaemonCodeAnalyzer.getInstance(project2).restart();
            }
        }

        @JvmStatic
        private static /* synthetic */ void getPSI_MODIFICATION_STAMP$annotations() {
        }

        @JvmStatic
        private static /* synthetic */ void getHINTS_DISABLED_FOR_EDITOR$annotations() {
        }

        @JvmStatic
        private static /* synthetic */ void getALWAYS_ENABLED_HINTS_PROVIDERS$annotations() {
        }

        public final void putCurrentModificationStamp(@NotNull Editor editor2, @NotNull PsiFile file2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            editor2.putUserData(PSI_MODIFICATION_STAMP, (Object)this.getCurrentModificationStamp(file2));
        }

        public final void clearModificationStamp(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            editor2.putUserData(PSI_MODIFICATION_STAMP, null);
        }

        private final long getCurrentModificationStamp(PsiFile file2) {
            return file2.getManager().getModificationTracker().getModificationCount();
        }

        private final boolean isProviderAlwaysEnabledForEditor(Editor editor2, SettingsKey<?> providerKey) {
            Set alwaysEnabledProviderKeys = (Set)editor2.getUserData(ALWAYS_ENABLED_HINTS_PROVIDERS);
            if (alwaysEnabledProviderKeys == null) {
                return false;
            }
            return alwaysEnabledProviderKeys.contains(providerKey);
        }

        @JvmStatic
        @ApiStatus.Experimental
        public final void setAlwaysEnabledHintsProviders(@NotNull Editor editor2, @Nullable Iterable<? extends SettingsKey<?>> keys2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            if (keys2 == null) {
                editor2.putUserData(ALWAYS_ENABLED_HINTS_PROVIDERS, null);
                return;
            }
            Set keySet = CollectionsKt.toSet(keys2);
            editor2.putUserData(ALWAYS_ENABLED_HINTS_PROVIDERS, (Object)keySet);
            this.forceHintsUpdateOnNextPass();
        }

        /*
         * WARNING - void declaration
         */
        private final List<ProviderWithSettings<? extends Object>> getProviders(PsiElement element, Editor editor2) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            InlayHintsSettings settings = InlayHintsSettings.Companion.instance();
            Language language = element.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"element.language");
            Language language2 = language;
            Project project2 = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"element.project");
            Project project3 = project2;
            boolean isDumbMode = DumbService.isDumb(project3);
            Iterable iterable = HintUtils.INSTANCE.getHintProvidersForLanguage(language2);
            boolean $i$f$filter = false;
            void var9_9 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ProviderWithSettings it = (ProviderWithSettings)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !(isDumbMode && !DumbService.isDumbAware(it.getProvider()) || it.getProvider().getGroup() == InlayGroup.CODE_VISION_GROUP && Registry.is("editor.codeVision.new") || !settings.hintsShouldBeShown(it.getProvider().getKey(), language2) && !Companion.isProviderAlwaysEnabledForEditor(editor2, it.getProvider().getKey()));
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @ApiStatus.Internal
        @Nullable
        public final HintsBuffer collectPlaceholders(@NotNull PsiFile file2, @NotNull Editor editor2) {
            CollectorWithSettings collector2;
            CollectorWithSettings collectorWithSettings;
            block1: {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                for (ProviderWithSettings it : (Iterable)this.getProviders(file2, editor2)) {
                    boolean bl = false;
                    CollectorWithSettings collectorWithSettings2 = InlayHintsUtilsKt.getPlaceholdersCollectorFor(it, file2, editor2);
                    if (collectorWithSettings2 == null) continue;
                    collectorWithSettings = collectorWithSettings2;
                    break block1;
                }
                collectorWithSettings = null;
            }
            CollectorWithSettings collectorWithSettings3 = collector2 = collectorWithSettings;
            return collectorWithSettings3 != null ? collectorWithSettings3.collectTraversing(editor2, file2, true) : null;
        }

        @ApiStatus.Internal
        @RequiresEdt
        public final void applyPlaceholders(@NotNull PsiFile file2, @NotNull Editor editor2, @NotNull HintsBuffer hints) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)hints, (String)"hints");
            InlayHintsPass.Companion.applyCollected$intellij_platform_lang_impl(hints, file2, editor2, true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

