/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.hints.ConfigureInlayHintsProviderAction;
import com.intellij.codeInsight.hints.ConstrainedPresentation;
import com.intellij.codeInsight.hints.DisableInlayHintsProviderAction;
import com.intellij.codeInsight.hints.DisableInlayHintsProviderCaseAction;
import com.intellij.codeInsight.hints.InlayPresentationFactory;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.codeInsight.hints.presentation.InlayTextMetricsStorage;
import com.intellij.codeInsight.hints.presentation.RootInlayPresentation;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.JBIterable;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J^\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u001d\u0010\r\u001a\u0019\u0012\u0015\u0012\u00130\u000f\u00a2\u0006\u000e\b\u0010\u0012\n\b\u0011\u0012\u0006\b\n0\u00128\u00130\u000e2\u0006\u0010\u0014\u001a\u00020\u000f2\u001d\u0010\u0015\u001a\u0019\u0012\u0015\u0012\u00130\u000f\u00a2\u0006\u000e\b\u0010\u0012\n\b\u0011\u0012\u0006\b\n0\u00128\u00130\u000eJ7\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\t2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u001d\u0010\r\u001a\u0019\u0012\u0015\u0012\u00130\u000f\u00a2\u0006\u000e\b\u0010\u0012\n\b\u0011\u0012\u0006\b\n0\u00128\u00130\u000eJ\u0015\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u00b4\u0001\u0010!\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H#0\"j\b\u0012\u0004\u0012\u0002H#`$0\t\"\b\b\u0000\u0010#*\u00020\u00012 \u0010%\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H#0\"j\b\u0012\u0004\u0012\u0002H#`$0\t2 \u0010&\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H#0\"j\b\u0012\u0004\u0012\u0002H#`$0\t24\u0010'\u001a0\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H#0\"0(j\u001c\u0012\u0018\u0012\u0016\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H#0\"j\b\u0012\u0004\u0012\u0002H#`$`)2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+J8\u0010,\u001a\u00020 \"\b\b\u0000\u0010-*\u00020\u0001*\b\u0012\u0004\u0012\u0002H-0.2\n\u0010/\u001a\u0006\u0012\u0002\b\u00030.2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+H\u0002R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/codeInsight/hints/InlayHintsUtils;", "", "()V", "TEXT_METRICS_STORAGE", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/codeInsight/hints/presentation/InlayTextMetricsStorage;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getDefaultInlayHintsProviderCasePopupActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "providerKey", "Lcom/intellij/codeInsight/hints/SettingsKey;", "providerName", "Ljava/util/function/Supplier;", "", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Title", "caseId", "caseName", "getDefaultInlayHintsProviderPopupActions", "getTextMetricStorage", "editor", "Lcom/intellij/openapi/editor/Editor;", "getTextMetricStorage$intellij_platform_lang_impl", "getTextRangeWithoutLeadingCommentsAndWhitespaces", "Lcom/intellij/openapi/util/TextRange;", "element", "Lcom/intellij/psi/PsiElement;", "isFirstInLine", "", "produceUpdatedRootList", "Lcom/intellij/codeInsight/hints/ConstrainedPresentation;", "Constraint", "Lcom/intellij/codeInsight/hints/ConstrPresent;", "new", "old", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "factory", "Lcom/intellij/codeInsight/hints/InlayPresentationFactory;", "updateIfSame", "Content", "Lcom/intellij/codeInsight/hints/presentation/RootInlayPresentation;", "newPresentation", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nInlayHintsUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlayHintsUtils.kt\ncom/intellij/codeInsight/hints/InlayHintsUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,309:1\n288#2,2:310\n*S KotlinDebug\n*F\n+ 1 InlayHintsUtils.kt\ncom/intellij/codeInsight/hints/InlayHintsUtils\n*L\n278#1:310,2\n*E\n"})
public final class InlayHintsUtils {
    @NotNull
    public static final InlayHintsUtils INSTANCE = new InlayHintsUtils();
    @NotNull
    private static final Key<InlayTextMetricsStorage> TEXT_METRICS_STORAGE;

    private InlayHintsUtils() {
    }

    @NotNull
    public final List<AnAction> getDefaultInlayHintsProviderPopupActions(@NotNull SettingsKey<?> providerKey, @NotNull Supplier<String> providerName) {
        Intrinsics.checkNotNullParameter(providerKey, (String)"providerKey");
        Intrinsics.checkNotNullParameter(providerName, (String)"providerName");
        Object[] objectArray = new AnAction[]{new DisableInlayHintsProviderAction(providerKey, providerName, false), new ConfigureInlayHintsProviderAction(providerKey)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final List<AnAction> getDefaultInlayHintsProviderCasePopupActions(@NotNull SettingsKey<?> providerKey, @NotNull Supplier<String> providerName, @NotNull String caseId, @NotNull Supplier<String> caseName) {
        Intrinsics.checkNotNullParameter(providerKey, (String)"providerKey");
        Intrinsics.checkNotNullParameter(providerName, (String)"providerName");
        Intrinsics.checkNotNullParameter((Object)caseId, (String)"caseId");
        Intrinsics.checkNotNullParameter(caseName, (String)"caseName");
        Object[] objectArray = new AnAction[]{new DisableInlayHintsProviderCaseAction(providerKey, providerName, caseId, caseName), new DisableInlayHintsProviderAction(providerKey, providerName, true), new ConfigureInlayHintsProviderAction(providerKey)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final <Constraint> List<ConstrainedPresentation<?, Constraint>> produceUpdatedRootList(@NotNull List<? extends ConstrainedPresentation<?, Constraint>> list2, @NotNull List<? extends ConstrainedPresentation<?, Constraint>> old, @NotNull Comparator<ConstrainedPresentation<?, Constraint>> comparator, @NotNull Editor editor2, @NotNull InlayPresentationFactory factory2) {
        Intrinsics.checkNotNullParameter(list2, (String)"new");
        Intrinsics.checkNotNullParameter(old, (String)"old");
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
        List updatedPresentations = new SmartList();
        int oldSize = old.size();
        int newSize = list2.size();
        int oldIndex = 0;
        int newIndex = 0;
        while (true) {
            ConstrainedPresentation<?, Constraint> newEl = list2.get(newIndex);
            ConstrainedPresentation<?, Constraint> oldEl = old.get(oldIndex);
            int value = comparator.compare(newEl, oldEl);
            if (value > 0) {
                if (++oldIndex != oldSize) continue;
                break;
            }
            if (value < 0) {
                updatedPresentations.add(newEl);
                if (++newIndex != newSize) continue;
                break;
            }
            RootInlayPresentation<?> oldRoot = oldEl.getRoot();
            RootInlayPresentation<?> newRoot = newEl.getRoot();
            if (Intrinsics.areEqual(newRoot.getKey(), oldRoot.getKey())) {
                this.updateIfSame(oldRoot, newRoot, editor2, factory2);
                updatedPresentations.add(oldEl);
            } else {
                updatedPresentations.add(newEl);
            }
            if (++newIndex == newSize || ++oldIndex == oldSize) break;
        }
        for (int i2 = newIndex; i2 < newSize; ++i2) {
            updatedPresentations.add(list2.get(i2));
        }
        return updatedPresentations;
    }

    private final <Content> boolean updateIfSame(RootInlayPresentation<Content> $this$updateIfSame, RootInlayPresentation<?> newPresentation, Editor editor2, InlayPresentationFactory factory2) {
        if (!Intrinsics.areEqual($this$updateIfSame.getKey(), newPresentation.getKey())) {
            return false;
        }
        Object obj = newPresentation.getContent();
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type Content of com.intellij.codeInsight.hints.InlayHintsUtils.updateIfSame");
        return $this$updateIfSame.update(obj, editor2, factory2);
    }

    @NotNull
    public final TextRange getTextRangeWithoutLeadingCommentsAndWhitespaces(@NotNull PsiElement element) {
        PsiElement psiElement;
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            JBIterable<PsiElement> jBIterable = SyntaxTraverser.psiApi().children(element);
            Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"psiApi().children(element)");
            Iterable $this$firstOrNull$iv = jBIterable;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(!(it instanceof PsiComment) && !(it instanceof PsiWhiteSpace))) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        if ((psiElement = (PsiElement)v1) == null) {
            psiElement = element;
        }
        PsiElement start = psiElement;
        TextRange textRange = TextRange.create(UtilsKt.getStartOffset(start), UtilsKt.getEndOffset(element));
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(start.startOffset, element.endOffset)");
        return textRange;
    }

    @JvmStatic
    public static final boolean isFirstInLine(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf(element, true);
        if (prevLeaf == null) {
            return true;
        }
        while (prevLeaf instanceof PsiWhiteSpace) {
            if (((PsiWhiteSpace)prevLeaf).textContains('\n') || ((PsiWhiteSpace)prevLeaf).getTextRange().getStartOffset() == 0) {
                return true;
            }
            prevLeaf = PsiTreeUtil.prevLeaf(prevLeaf, true);
        }
        return false;
    }

    @NotNull
    public final InlayTextMetricsStorage getTextMetricStorage$intellij_platform_lang_impl(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        InlayTextMetricsStorage storage = (InlayTextMetricsStorage)editor2.getUserData(TEXT_METRICS_STORAGE);
        if (storage == null) {
            InlayTextMetricsStorage newStorage = new InlayTextMetricsStorage(editor2);
            editor2.putUserData(TEXT_METRICS_STORAGE, (Object)newStorage);
            return newStorage;
        }
        return storage;
    }

    static {
        Key key = Key.create("InlayTextMetricsStorage");
        Intrinsics.checkNotNullExpressionValue(key, (String)"create<InlayTextMetricsS\u2026InlayTextMetricsStorage\")");
        TEXT_METRICS_STORAGE = key;
    }
}

