/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.HintInfoFilter;
import com.intellij.codeInsight.hints.HintUtilsKt;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.filtering.Matcher;
import com.intellij.codeInsight.hints.filtering.MatcherConstructor;
import com.intellij.codeInsight.hints.settings.Diff;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettings;
import com.intellij.lang.Language;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class MethodInfoExcludeListFilter
implements HintInfoFilter {
    private final List<Matcher> myMatchers;

    public MethodInfoExcludeListFilter(Set<String> list2) {
        this.myMatchers = list2.stream().map(item -> MatcherConstructor.INSTANCE.createMatcher(item)).filter(e -> e != null).collect(Collectors.toList());
    }

    @NotNull
    public static MethodInfoExcludeListFilter forLanguage(@NotNull Language language) {
        if (language == null) {
            MethodInfoExcludeListFilter.$$$reportNull$$$0(0);
        }
        Set<String> list2 = MethodInfoExcludeListFilter.fullExcludelist(language);
        return new MethodInfoExcludeListFilter(list2);
    }

    @Override
    public boolean showHint(@NotNull HintInfo info2) {
        if (info2 == null) {
            MethodInfoExcludeListFilter.$$$reportNull$$$0(1);
        }
        if (info2 instanceof HintInfo.MethodInfo) {
            HintInfo.MethodInfo methodInfo = (HintInfo.MethodInfo)info2;
            return !ContainerUtil.exists(this.myMatchers, e -> e.isMatching(methodInfo.getFullyQualifiedName(), methodInfo.getParamNames()));
        }
        return false;
    }

    @NotNull
    private static Set<String> fullExcludelist(Language language) {
        InlayParameterHintsProvider provider2 = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (provider2 == null) {
            Set<String> set2 = Collections.emptySet();
            if (set2 == null) {
                MethodInfoExcludeListFilter.$$$reportNull$$$0(2);
            }
            return set2;
        }
        Set<String> excludeList = MethodInfoExcludeListFilter.excludeList(language);
        Language dependentLanguage = provider2.getBlackListDependencyLanguage();
        if (dependentLanguage != null) {
            excludeList = ContainerUtil.union(excludeList, MethodInfoExcludeListFilter.excludeList(dependentLanguage));
        }
        Set<String> set3 = excludeList;
        if (set3 == null) {
            MethodInfoExcludeListFilter.$$$reportNull$$$0(3);
        }
        return set3;
    }

    @NotNull
    private static Set<String> excludeList(@NotNull Language language) {
        InlayParameterHintsProvider provider2;
        if (language == null) {
            MethodInfoExcludeListFilter.$$$reportNull$$$0(4);
        }
        if ((provider2 = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language)) != null) {
            ParameterNameHintsSettings settings = ParameterNameHintsSettings.getInstance();
            Diff diff = settings.getExcludeListDiff(HintUtilsKt.getLanguageForSettingKey(language));
            Set<String> set2 = diff.applyOn(provider2.getDefaultBlackList());
            if (set2 == null) {
                MethodInfoExcludeListFilter.$$$reportNull$$$0(5);
            }
            return set2;
        }
        Set<String> set3 = Collections.emptySet();
        if (set3 == null) {
            MethodInfoExcludeListFilter.$$$reportNull$$$0(6);
        }
        return set3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/hints/MethodInfoExcludeListFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/hints/MethodInfoExcludeListFilter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fullExcludelist";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "excludeList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "excludeList";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 5, 6 -> new IllegalStateException(string2);
        };
    }
}

