/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.HintInfoFilter;
import com.intellij.codeInsight.hints.HintUtilsKt;
import com.intellij.codeInsight.hints.HintWidthAdjustment;
import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.MethodInfoExcludeListFilter;
import com.intellij.codeInsight.hints.ParameterHintsPassFactory;
import com.intellij.codeInsight.hints.ParameterHintsUpdater;
import com.intellij.codeInsight.hints.ParameterNameHintsSuppressor;
import com.intellij.codeWithMe.ClientId;
import com.intellij.lang.Language;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.editor.ClientEditorManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.concurrency.AppExecutorUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;

public final class ParameterHintsPass
extends EditorBoundHighlightingPass {
    private final Int2ObjectMap<List<HintData>> myHints;
    private final Int2ObjectMap<String> myShowOnlyIfExistedBeforeHints;
    private final PsiElement myRootElement;
    private final HintInfoFilter myHintInfoFilter;
    private final boolean myForceImmediateUpdate;

    public ParameterHintsPass(@NotNull PsiElement element, @NotNull Editor editor2, @NotNull HintInfoFilter hintsFilter, boolean forceImmediateUpdate) {
        if (element == null) {
            ParameterHintsPass.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            ParameterHintsPass.$$$reportNull$$$0(1);
        }
        if (hintsFilter == null) {
            ParameterHintsPass.$$$reportNull$$$0(2);
        }
        super(editor2, element.getContainingFile(), true);
        this.myHints = new Int2ObjectOpenHashMap<List<HintData>>();
        this.myShowOnlyIfExistedBeforeHints = new Int2ObjectOpenHashMap<String>();
        this.myRootElement = element;
        this.myHintInfoFilter = hintsFilter;
        this.myForceImmediateUpdate = forceImmediateUpdate;
    }

    @Deprecated(forRemoval=true)
    public static void syncUpdate(@NotNull PsiElement element, @NotNull Editor editor2) {
        if (element == null) {
            ParameterHintsPass.$$$reportNull$$$0(3);
        }
        if (editor2 == null) {
            ParameterHintsPass.$$$reportNull$$$0(4);
        }
        MethodInfoExcludeListFilter filter2 = MethodInfoExcludeListFilter.forLanguage(element.getLanguage());
        ParameterHintsPass pass2 = new ParameterHintsPass(element, editor2, filter2, true);
        try {
            pass2.doCollectInformation(new ProgressIndicatorBase());
        }
        catch (IndexNotReadyException e) {
            return;
        }
        pass2.applyInformationToEditor();
    }

    @NotNull
    public static CancellablePromise<?> asyncUpdate(@NotNull PsiElement element, @NotNull Editor editor2) {
        if (element == null) {
            ParameterHintsPass.$$$reportNull$$$0(5);
        }
        if (editor2 == null) {
            ParameterHintsPass.$$$reportNull$$$0(6);
        }
        MethodInfoExcludeListFilter filter2 = MethodInfoExcludeListFilter.forLanguage(element.getLanguage());
        AsyncPromise promise = new AsyncPromise();
        SmartPsiElementPointer<PsiElement> elementPtr = SmartPointerManager.getInstance(element.getProject()).createSmartPsiElementPointer(element);
        ReadAction.nonBlocking(() -> ParameterHintsPass.collectInlaysInPass(editor2, filter2, elementPtr)).finishOnUiThread(ModalityState.any(), pass2 -> {
            if (pass2 != null) {
                try (AccessToken ignored = ClientId.withClientId(ClientEditorManager.getClientId((Editor)editor2));){
                    pass2.applyInformationToEditor();
                }
            }
            promise.setResult(null);
        }).submit(AppExecutorUtil.getAppExecutorService());
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            ParameterHintsPass.$$$reportNull$$$0(7);
        }
        return asyncPromise;
    }

    private static ParameterHintsPass collectInlaysInPass(@NotNull Editor editor2, MethodInfoExcludeListFilter filter2, SmartPsiElementPointer<PsiElement> elementPtr) {
        PsiElement element;
        if (editor2 == null) {
            ParameterHintsPass.$$$reportNull$$$0(8);
        }
        if ((element = elementPtr.getElement()) == null || editor2.isDisposed()) {
            return null;
        }
        AccessToken ignored = ClientId.withClientId(ClientEditorManager.getClientId((Editor)editor2));
        try {
            ParameterHintsPass pass2 = new ParameterHintsPass(element, editor2, filter2, true);
            pass2.doCollectInformation(new ProgressIndicatorBase());
            ParameterHintsPass parameterHintsPass = pass2;
            if (ignored != null) {
                ignored.close();
            }
            return parameterHintsPass;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IndexNotReadyException e) {
                return null;
            }
        }
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            ParameterHintsPass.$$$reportNull$$$0(9);
        }
        this.myHints.clear();
        Language language = this.myFile.getLanguage();
        InlayParameterHintsProvider provider2 = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (provider2 == null || !provider2.canShowHintsWhenDisabled() && !ParameterHintsPass.isEnabled(language) || DiffUtil.isDiffEditor((Editor)this.myEditor)) {
            return;
        }
        if (!HighlightingLevelManager.getInstance(this.myFile.getProject()).shouldHighlight(this.myFile)) {
            return;
        }
        provider2.createTraversal(this.myRootElement).forEach(element -> this.process((PsiElement)element, provider2));
    }

    private static boolean isEnabled(Language language) {
        return HintUtilsKt.isParameterHintsEnabledForLanguage(language);
    }

    private void process(@NotNull PsiElement element, @NotNull InlayParameterHintsProvider provider2) {
        List<InlayInfo> hints;
        if (element == null) {
            ParameterHintsPass.$$$reportNull$$$0(10);
        }
        if (provider2 == null) {
            ParameterHintsPass.$$$reportNull$$$0(11);
        }
        if ((hints = provider2.getParameterHints(element, this.myFile)).isEmpty()) {
            return;
        }
        HintInfo info2 = provider2.getHintInfo(element, this.myFile);
        boolean showHints = info2 == null || info2 instanceof HintInfo.OptionInfo || this.myHintInfoFilter.showHint(info2);
        Stream<Object> inlays = hints.stream();
        if (!showHints) {
            inlays = inlays.filter(inlayInfo -> !inlayInfo.isFilterByExcludeList());
        }
        inlays.forEach(hint -> {
            int offset2 = hint.getOffset();
            if (!this.canShowHintsAtOffset(offset2)) {
                return;
            }
            if (ParameterNameHintsSuppressor.All.isSuppressedFor(this.myFile, (InlayInfo)hint)) {
                return;
            }
            String presentation2 = provider2.getInlayPresentation(hint.getText());
            if (hint.isShowOnlyIfExistedBefore()) {
                this.myShowOnlyIfExistedBeforeHints.put(offset2, presentation2);
            } else {
                ArrayList<HintData> hintList = (ArrayList<HintData>)this.myHints.get(offset2);
                if (hintList == null) {
                    hintList = new ArrayList<HintData>();
                    this.myHints.put(offset2, (List<HintData>)hintList);
                }
                HintWidthAdjustment widthAdjustment = ParameterHintsPass.convertHintPresentation(hint.getWidthAdjustment(), provider2);
                hintList.add(new HintData(presentation2, hint.getRelatesToPrecedingText(), widthAdjustment));
            }
        });
    }

    private static HintWidthAdjustment convertHintPresentation(HintWidthAdjustment widthAdjustment, InlayParameterHintsProvider provider2) {
        String adjusterHintPresentation;
        String hintText;
        if (widthAdjustment != null && (hintText = widthAdjustment.getHintTextToMatch()) != null && !hintText.equals(adjusterHintPresentation = provider2.getInlayPresentation(hintText))) {
            widthAdjustment = new HintWidthAdjustment(widthAdjustment.getEditorTextToMatch(), adjusterHintPresentation, widthAdjustment.getAdjustmentPosition());
        }
        return widthAdjustment;
    }

    @Override
    public void doApplyInformationToEditor() {
        EditorScrollingPositionKeeper.perform((Editor)this.myEditor, (boolean)false, () -> {
            ParameterHintsPresentationManager manager = ParameterHintsPresentationManager.getInstance();
            List<Inlay<?>> hints = this.hintsInRootElementArea(manager);
            ParameterHintsUpdater updater2 = new ParameterHintsUpdater(this.myEditor, hints, this.myHints, this.myShowOnlyIfExistedBeforeHints, this.myForceImmediateUpdate);
            updater2.update();
        });
        if (ParameterHintsUpdater.hintRemovalDelayed(this.myEditor)) {
            ParameterHintsPassFactory.forceHintsUpdateOnNextPass(this.myEditor);
        } else if (this.myRootElement == this.myFile) {
            ParameterHintsPassFactory.putCurrentPsiModificationStamp(this.myEditor, this.myFile);
        }
    }

    @NotNull
    private List<Inlay<?>> hintsInRootElementArea(ParameterHintsPresentationManager manager) {
        TextRange range = this.myRootElement.getTextRange();
        int elementStart = range.getStartOffset();
        int elementEnd = range.getEndOffset();
        if (this.myDocument.getTextLength() != range.getLength()) {
            ++elementStart;
            --elementEnd;
        }
        List<Inlay<?>> list2 = manager.getParameterHintsInRange(this.myEditor, elementStart, elementEnd);
        if (list2 == null) {
            ParameterHintsPass.$$$reportNull$$$0(12);
        }
        return list2;
    }

    private boolean canShowHintsAtOffset(int offset2) {
        TextRange rootRange = this.myRootElement.getTextRange();
        if (!rootRange.containsOffset(offset2)) {
            return false;
        }
        if (offset2 > rootRange.getStartOffset() && offset2 < rootRange.getEndOffset()) {
            return true;
        }
        return this.myDocument.getTextLength() == rootRange.getLength();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintsFilter";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/hints/ParameterHintsPass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/hints/ParameterHintsPass";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "asyncUpdate";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "hintsInRootElementArea";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "syncUpdate";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "asyncUpdate";
                break;
            }
            case 7: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectInlaysInPass";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doCollectInformation";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7, 12 -> new IllegalStateException(string2);
        };
    }

    static class HintData {
        final String presentationText;
        final boolean relatesToPrecedingText;
        final HintWidthAdjustment widthAdjustment;

        HintData(@NotNull String text2, boolean relatesToPrecedingText, HintWidthAdjustment widthAdjustment) {
            if (text2 == null) {
                HintData.$$$reportNull$$$0(0);
            }
            this.presentationText = text2;
            this.relatesToPrecedingText = relatesToPrecedingText;
            this.widthAdjustment = widthAdjustment;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/hints/ParameterHintsPass$HintData", "<init>"));
        }
    }
}

