/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.hints.ExcludeListDialog;
import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.ParameterHintsPassFactory;
import com.intellij.codeInsight.hints.settings.InlayProviderSettingsModel;
import com.intellij.codeInsight.hints.settings.InlaySettingsConfigurableKt;
import com.intellij.codeInsight.hints.settings.language.ParameterInlayProviderSettingsModel;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a$\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\"\u0010\r\u001a\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\b\u0010\u000e\u001a\u00020\u000fH\u0002\u001a&\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0016\u0010\u0013\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014\u001a\u001c\u0010\u0016\u001a\u00020\f*\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\n\u0010\u0018\u001a\u00020\u0015*\u00020\u0019\u00a8\u0006\u001a"}, d2={"getHintInfoFromProvider", "Lcom/intellij/codeInsight/hints/HintInfo;", "offset", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getInfoForElement", "element", "Lcom/intellij/psi/PsiElement;", "hasEditorParameterHintAtOffset", "", "hasHints", "refreshAllOpenEditors", "", "showParameterHintsDialog", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getPattern", "Lkotlin/Function1;", "", "hasDisabledOptionHintInfo", "Lcom/intellij/codeInsight/hints/InlayParameterHintsProvider;", "toPattern", "Lcom/intellij/codeInsight/hints/HintInfo$MethodInfo;", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nPopupActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PopupActions.kt\ncom/intellij/codeInsight/hints/PopupActionsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,352:1\n13579#2:353\n13579#2:354\n13580#2:356\n13580#2:357\n1#3:355\n*S KotlinDebug\n*F\n+ 1 PopupActions.kt\ncom/intellij/codeInsight/hints/PopupActionsKt\n*L\n317#1:353\n322#1:354\n322#1:356\n317#1:357\n*E\n"})
public final class PopupActionsKt {
    public static final void showParameterHintsDialog(@NotNull AnActionEvent e, @NotNull Function1<? super HintInfo, String> getPattern) {
        String pattern;
        Object selectedLanguage;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter(getPattern, (String)"getPattern");
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return;
        }
        PsiFile file2 = psiFile;
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        Language language = file2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"file.language");
        Language fileLanguage = language;
        if ((InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(fileLanguage) == null) {
            return;
        }
        int offset2 = editor3.getCaretModel().getOffset();
        HintInfo info2 = PopupActionsKt.getHintInfoFromProvider(offset2, file2, editor3);
        Object object = info2 instanceof HintInfo.MethodInfo ? (HintInfo.MethodInfo)info2 : null;
        if (object == null || (object = ((HintInfo.MethodInfo)object).getLanguage()) == null) {
            object = selectedLanguage = fileLanguage;
        }
        if ((pattern = (String)getPattern.invoke((Object)info2)) == null) {
            Project project2 = file2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"file.project");
            InlaySettingsConfigurableKt.showInlaySettings(project2, fileLanguage, PopupActionsKt::showParameterHintsDialog$lambda$0);
        } else {
            new ExcludeListDialog((Language)selectedLanguage, pattern).show();
        }
    }

    private static final boolean hasDisabledOptionHintInfo(InlayParameterHintsProvider $this$hasDisabledOptionHintInfo, PsiElement element, PsiFile file2) {
        HintInfo info2 = $this$hasDisabledOptionHintInfo.getHintInfo(element, file2);
        return info2 instanceof HintInfo.OptionInfo && !((HintInfo.OptionInfo)info2).isOptionEnabled();
    }

    private static final boolean hasEditorParameterHintAtOffset(Editor editor2, PsiFile file2) {
        if (editor2 instanceof EditorWindow || editor2 instanceof ImaginaryEditor) {
            return false;
        }
        int offset2 = editor2.getCaretModel().getOffset();
        PsiElement elementToRight = file2.findElementAt(offset2);
        if (PopupActionsKt.hasHints(elementToRight, offset2, editor2)) {
            return true;
        }
        return offset2 > 0 && PopupActionsKt.hasHints(file2.findElementAt(offset2 - 1), offset2, editor2);
    }

    private static final boolean hasHints(PsiElement element, int offset2, Editor editor2) {
        Object object = element;
        int startOffset = object != null && (object = object.getTextRange()) != null ? ((TextRange)object).getStartOffset() : offset2;
        Object object2 = element;
        int endOffset = object2 != null && (object2 = object2.getTextRange()) != null ? ((TextRange)object2).getEndOffset() : offset2;
        List<Inlay<?>> list2 = ParameterHintsPresentationManager.getInstance().getParameterHintsInRange(editor2, startOffset, endOffset);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getInstance().getParamet\u2026, startOffset, endOffset)");
        return !((Collection)list2).isEmpty();
    }

    private static final void refreshAllOpenEditors() {
        ParameterHintsPassFactory.forceHintsUpdateOnNextPass();
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getInstance().openProjects");
        Object[] $this$forEach$iv = projectArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Project project2 = (Project)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)PsiManager.getInstance(project2), (String)"getInstance(project)");
            DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance(project2);
            FileEditorManager fileEditorManager = FileEditorManager.getInstance(project2);
            VirtualFile[] virtualFileArray = fileEditorManager.getSelectedFiles();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"fileEditorManager.selectedFiles");
            Object[] $this$forEach$iv2 = virtualFileArray;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                PsiFile it;
                PsiManager psiManager;
                VirtualFile file2 = (VirtualFile)element$iv2;
                boolean bl2 = false;
                if (psiManager.findFile(file2) == null) continue;
                boolean bl3 = false;
                daemonCodeAnalyzer.restart(it);
            }
        }
    }

    private static final HintInfo getHintInfoFromProvider(int offset2, PsiFile file2, Editor editor2) {
        HintInfo infoForElementToRight;
        PsiElement element = file2.findElementAt(offset2);
        HintInfo hintInfo = infoForElementToRight = PopupActionsKt.getInfoForElement(file2, element, editor2);
        if (hintInfo != null) {
            return hintInfo;
        }
        if (offset2 == 0) {
            return null;
        }
        return PopupActionsKt.getInfoForElement(file2, file2.findElementAt(offset2 - 1), editor2);
    }

    private static final HintInfo getInfoForElement(PsiFile file2, PsiElement element, Editor editor2) {
        InlayParameterHintsProvider inlayParameterHintsProvider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(file2.getLanguage());
        if (inlayParameterHintsProvider == null) {
            return null;
        }
        InlayParameterHintsProvider provider2 = inlayParameterHintsProvider;
        PsiElement method2 = PsiTreeUtil.findFirstParent(element, arg_0 -> PopupActionsKt.getInfoForElement$lambda$4((Function1)new Function1<PsiElement, Boolean>(provider2, file2, editor2){
            final /* synthetic */ InlayParameterHintsProvider $provider;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ Editor $editor;
            {
                this.$provider = $provider;
                this.$file = $file;
                this.$editor = $editor;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(PsiElement it) {
                boolean bl;
                if (!(it instanceof PsiFile)) {
                    boolean bl2;
                    HintInfo hintInfo = this.$provider.getHintInfo(it, this.$file);
                    if (hintInfo != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        bl2 = hintInfo.isOwnedByPsiElement(it, this.$editor);
                    } else {
                        bl2 = false;
                    }
                    if (!bl2) {
                        bl = false;
                        return bl;
                    }
                }
                bl = true;
                return bl;
            }
        }, arg_0));
        if (method2 == null || method2 instanceof PsiFile) {
            return null;
        }
        return provider2.getHintInfo(method2, file2);
    }

    @NotNull
    public static final String toPattern(@NotNull HintInfo.MethodInfo $this$toPattern) {
        Intrinsics.checkNotNullParameter((Object)$this$toPattern, (String)"<this>");
        return $this$toPattern.getFullyQualifiedName() + "(" + CollectionsKt.joinToString$default((Iterable)$this$toPattern.getParamNames(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ")";
    }

    private static final boolean showParameterHintsDialog$lambda$0(InlayProviderSettingsModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof ParameterInlayProviderSettingsModel;
    }

    private static final boolean getInfoForElement$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ HintInfo access$getHintInfoFromProvider(int offset2, PsiFile file2, Editor editor2) {
        return PopupActionsKt.getHintInfoFromProvider(offset2, file2, editor2);
    }

    public static final /* synthetic */ boolean access$hasEditorParameterHintAtOffset(Editor editor2, PsiFile file2) {
        return PopupActionsKt.hasEditorParameterHintAtOffset(editor2, file2);
    }

    public static final /* synthetic */ void access$refreshAllOpenEditors() {
        PopupActionsKt.refreshAllOpenEditors();
    }

    public static final /* synthetic */ boolean access$hasDisabledOptionHintInfo(InlayParameterHintsProvider $receiver, PsiElement element, PsiFile file2) {
        return PopupActionsKt.hasDisabledOptionHintInfo($receiver, element, file2);
    }
}

