/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.codeVision;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.codeVision.CodeVisionEntry;
import com.intellij.codeInsight.codeVision.EditorCodeVisionContextKt;
import com.intellij.codeInsight.hints.codeVision.CodeVisionPass;
import com.intellij.codeInsight.hints.codeVision.CodeVisionPassFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/codeInsight/hints/codeVision/CodeVisionPassFactory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactoryRegistrar;", "()V", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "registerHighlightingPassFactory", "", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.platform.lang.impl"})
public final class CodeVisionPassFactory
implements TextEditorHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<RegistryValue> registry = LazyKt.lazy((Function0)Companion.registry.1.INSTANCE);
    @NotNull
    private static final Key<Long> PSI_MODIFICATION_STAMP;

    @Override
    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, false, -1);
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (!((RegistryValue)registry.getValue()).asBoolean()) {
            return null;
        }
        Long savedStamp = (Long)editor2.getUserData(PSI_MODIFICATION_STAMP);
        long currentStamp = CodeVisionPassFactory.Companion.getCurrentModificationStamp(file2);
        if (savedStamp != null) {
            long l = currentStamp;
            if (savedStamp == l) {
                return null;
            }
        }
        return new CodeVisionPass(file2, editor2);
    }

    @JvmStatic
    public static final void applyPlaceholders(@NotNull Editor editor2, @NotNull List<Pair<TextRange, CodeVisionEntry>> placeholders) {
        Companion.applyPlaceholders(editor2, placeholders);
    }

    static {
        Key key = Key.create("code.vision.psi.modification.stamp");
        Intrinsics.checkNotNullExpressionValue(key, (String)"create(\"code.vision.psi.modification.stamp\")");
        PSI_MODIFICATION_STAMP = key;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00100\u000fH\u0007J\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\r\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/codeInsight/hints/codeVision/CodeVisionPassFactory$Companion;", "", "()V", "PSI_MODIFICATION_STAMP", "Lcom/intellij/openapi/util/Key;", "", "registry", "Lkotlin/Lazy;", "Lcom/intellij/openapi/util/registry/RegistryValue;", "Lorg/jetbrains/annotations/NotNull;", "applyPlaceholders", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "placeholders", "", "Lkotlin/Pair;", "Lcom/intellij/openapi/util/TextRange;", "Lcom/intellij/codeInsight/codeVision/CodeVisionEntry;", "clearModificationStamp", "getCurrentModificationStamp", "file", "Lcom/intellij/psi/PsiFile;", "putCurrentModificationStamp", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final void putCurrentModificationStamp(@NotNull Editor editor2, @NotNull PsiFile file2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            editor2.putUserData(PSI_MODIFICATION_STAMP, (Object)this.getCurrentModificationStamp(file2));
        }

        private final long getCurrentModificationStamp(PsiFile file2) {
            return file2.getManager().getModificationTracker().getModificationCount();
        }

        public final void clearModificationStamp(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            editor2.putUserData(PSI_MODIFICATION_STAMP, null);
        }

        @JvmStatic
        public final void applyPlaceholders(@NotNull Editor editor2, @NotNull List<Pair<TextRange, CodeVisionEntry>> placeholders) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter(placeholders, (String)"placeholders");
            if (!((RegistryValue)registry.getValue()).asBoolean()) {
                return;
            }
            EditorCodeVisionContextKt.getLensContextOrThrow(editor2).setResults(placeholders);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

