/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.codeVision;

import com.intellij.codeInsight.codeVision.BypassBasedPlaceholderCollector;
import com.intellij.codeInsight.codeVision.CodeVisionAnchorKind;
import com.intellij.codeInsight.codeVision.CodeVisionEntry;
import com.intellij.codeInsight.codeVision.CodeVisionHost;
import com.intellij.codeInsight.codeVision.CodeVisionPlaceholderCollector;
import com.intellij.codeInsight.codeVision.ui.model.ClickableTextCodeVisionEntry;
import com.intellij.codeInsight.hints.InlayHintsUtils;
import com.intellij.codeInsight.hints.codeVision.DaemonBoundCodeVisionProvider;
import com.intellij.codeInsight.hints.settings.language.SingleLanguageInlayHintsSettingsPanelKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntaxTraverser;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH&J*\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00100\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH'J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\rH\u0016J\"\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH&J\u0018\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u0016H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006!"}, d2={"Lcom/intellij/codeInsight/hints/codeVision/CodeVisionProviderBase;", "Lcom/intellij/codeInsight/hints/codeVision/DaemonBoundCodeVisionProvider;", "()V", "defaultAnchor", "Lcom/intellij/codeInsight/codeVision/CodeVisionAnchorKind;", "getDefaultAnchor", "()Lcom/intellij/codeInsight/codeVision/CodeVisionAnchorKind;", "acceptsElement", "", "element", "Lcom/intellij/psi/PsiElement;", "acceptsFile", "file", "Lcom/intellij/psi/PsiFile;", "computeForEditor", "", "Lkotlin/Pair;", "Lcom/intellij/openapi/util/TextRange;", "Lcom/intellij/codeInsight/codeVision/CodeVisionEntry;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getHint", "", "getPlaceholderCollector", "Lcom/intellij/codeInsight/codeVision/CodeVisionPlaceholderCollector;", "psiFile", "handleClick", "", "event", "Ljava/awt/event/MouseEvent;", "logClickToFUS", "hint", "ClickHandler", "intellij.platform.lang.impl"})
public abstract class CodeVisionProviderBase
implements DaemonBoundCodeVisionProvider {
    public abstract boolean acceptsFile(@NotNull PsiFile var1);

    public abstract boolean acceptsElement(@NotNull PsiElement var1);

    @Nls
    @Nullable
    public abstract String getHint(@NotNull PsiElement var1, @NotNull PsiFile var2);

    public void logClickToFUS(@NotNull PsiElement element, @NotNull String hint) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)hint, (String)"hint");
    }

    @Override
    @NotNull
    public List<Pair<TextRange, CodeVisionEntry>> computeForEditor(@NotNull Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (file2.getProject().isDefault()) {
            return CollectionsKt.emptyList();
        }
        if (!this.acceptsFile(file2)) {
            return CollectionsKt.emptyList();
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && !CodeVisionHost.Companion.isCodeLensTest()) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile2 = file2.getViewProvider().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"file.viewProvider.virtualFile");
        VirtualFile virtualFile3 = virtualFile2;
        if (ProjectFileIndex.getInstance(file2.getProject()).isInLibrarySource(virtualFile3)) {
            return CollectionsKt.emptyList();
        }
        ArrayList<Pair> lenses = new ArrayList<Pair>();
        SyntaxTraverser<PsiElement> syntaxTraverser = SyntaxTraverser.psiTraverser(file2);
        Intrinsics.checkNotNullExpressionValue(syntaxTraverser, (String)"psiTraverser(file)");
        SyntaxTraverser<PsiElement> traverser = syntaxTraverser;
        for (PsiElement element : traverser) {
            String hint;
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"element");
            if (!this.acceptsElement(element) || !InlayHintsUtils.isFirstInLine(element) || (hint = this.getHint(element, file2)) == null) continue;
            ClickHandler handler2 = new ClickHandler(element, hint);
            TextRange range = InlayHintsUtils.INSTANCE.getTextRangeWithoutLeadingCommentsAndWhitespaces(element);
            lenses.add(TuplesKt.to((Object)range, (Object)new ClickableTextCodeVisionEntry(hint, this.getId(), handler2, null, null, null, null, 120, null)));
        }
        return lenses;
    }

    public abstract void handleClick(@NotNull Editor var1, @NotNull PsiElement var2, @Nullable MouseEvent var3);

    @Override
    @Nullable
    public CodeVisionPlaceholderCollector getPlaceholderCollector(@NotNull Editor editor2, @Nullable PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (psiFile == null || !this.acceptsFile(psiFile)) {
            return null;
        }
        return new BypassBasedPlaceholderCollector(this){
            final /* synthetic */ CodeVisionProviderBase this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public List<TextRange> collectPlaceholders(@NotNull PsiElement element, @NotNull Editor editor2) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                if (!this.this$0.acceptsElement(element)) {
                    return CollectionsKt.emptyList();
                }
                TextRange range = InlayHintsUtils.INSTANCE.getTextRangeWithoutLeadingCommentsAndWhitespaces(element);
                return CollectionsKt.listOf((Object)range);
            }
        };
    }

    @Override
    @NotNull
    public CodeVisionAnchorKind getDefaultAnchor() {
        return CodeVisionAnchorKind.Default;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001b\u0010\u000e\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u0003H\u0096\u0002R!\u0010\n\u001a\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00060\u00060\u000b\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/codeInsight/hints/codeVision/CodeVisionProviderBase$ClickHandler;", "Lkotlin/Function2;", "Ljava/awt/event/MouseEvent;", "Lcom/intellij/openapi/editor/Editor;", "", "element", "Lcom/intellij/psi/PsiElement;", "hint", "", "(Lcom/intellij/codeInsight/hints/codeVision/CodeVisionProviderBase;Lcom/intellij/psi/PsiElement;Ljava/lang/String;)V", "elementPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "invoke", "event", "editor", "intellij.platform.lang.impl"})
    private final class ClickHandler
    implements Function2<MouseEvent, Editor, Unit> {
        @NotNull
        private final String hint;
        @NotNull
        private final SmartPsiElementPointer<PsiElement> elementPointer;

        public ClickHandler(@NotNull PsiElement element, String hint) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)hint, (String)"hint");
            this.hint = hint;
            SmartPsiElementPointer<PsiElement> smartPsiElementPointer = SmartPointerManager.createPointer(element);
            Intrinsics.checkNotNullExpressionValue(smartPsiElementPointer, (String)"createPointer(element)");
            this.elementPointer = smartPsiElementPointer;
        }

        public void invoke(@Nullable MouseEvent event, @NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            if (SingleLanguageInlayHintsSettingsPanelKt.isInlaySettingsEditor(editor2)) {
                return;
            }
            PsiElement psiElement = this.elementPointer.getElement();
            if (psiElement == null) {
                return;
            }
            PsiElement element = psiElement;
            CodeVisionProviderBase.this.logClickToFUS(element, this.hint);
            CodeVisionProviderBase.this.handleClick(editor2, element, event);
        }
    }
}

