/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.declarative.impl;

import com.intellij.codeInsight.hints.declarative.InlayHintsProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.util.ResourceUtil;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J(\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004J\u0016\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/codeInsight/hints/declarative/impl/DeclarativeHintsPreviewProvider;", "", "()V", "MAIN_PREVIEW_NAME", "", "getOptionPreview", "provider", "Lcom/intellij/codeInsight/hints/declarative/InlayHintsProvider;", "language", "Lcom/intellij/lang/Language;", "optionId", "providerId", "getPreview", "getPreviewOptionSearchPath", "getPreviewSearchPath", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public final class DeclarativeHintsPreviewProvider {
    @NotNull
    public static final DeclarativeHintsPreviewProvider INSTANCE = new DeclarativeHintsPreviewProvider();
    @NotNull
    private static final String MAIN_PREVIEW_NAME = "preview";

    private DeclarativeHintsPreviewProvider() {
    }

    @Nullable
    public final String getPreview(@NotNull Language language, @NotNull String providerId, @NotNull InlayHintsProvider provider2) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        return this.getOptionPreview(provider2, language, MAIN_PREVIEW_NAME, providerId);
    }

    @Nullable
    public final String getOptionPreview(@NotNull Language language, @NotNull String providerId, @NotNull String optionId, @NotNull InlayHintsProvider provider2) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        Intrinsics.checkNotNullParameter((Object)optionId, (String)"optionId");
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        return this.getOptionPreview(provider2, language, optionId, providerId);
    }

    private final String getOptionPreview(InlayHintsProvider provider2, Language language, String optionId, String providerId) {
        InputStream stream;
        String path2 = this.getPreviewOptionSearchPath(providerId, language, optionId);
        InputStream inputStream = stream = provider2.getClass().getClassLoader().getResourceAsStream(path2);
        return inputStream != null ? ResourceUtil.loadText(inputStream) : null;
    }

    @NotNull
    public final String getPreviewSearchPath(@NotNull String providerId, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return this.getPreviewOptionSearchPath(providerId, language, MAIN_PREVIEW_NAME);
    }

    @NotNull
    public final String getPreviewOptionSearchPath(@NotNull String providerId, @NotNull Language language, @NotNull String optionId) {
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)optionId, (String)"optionId");
        LanguageFileType languageFileType = language.getAssociatedFileType();
        if (languageFileType == null) {
            languageFileType = PlainTextFileType.INSTANCE;
        }
        LanguageFileType extension2 = languageFileType;
        return "inlayProviders/" + providerId + "/" + optionId + "." + extension2.getDefaultExtension();
    }
}

